# NAME

Task::Cpanel::Internal - These modules are used for internal cPanel development.

# SYNOPSIS

    cpan Task::Cpanel::Internal

# DESCRIPTION

This package includes all of the needed CPAN modules for __cPanel & WHM__ development
by cPanel.

They are not necessarily needed for anything on a __cPanel & WHM__ installation, but
you may find them helpful during your own perl development.

The first two numbers of this version (eg: 11.36) refer to the major version of
cPanel which it applies to.

## MODULES REQUIRED

- [Acme::Bleach](http://search.cpan.org/perldoc?Acme::Bleach)

For really clean programs

- [App::Ack](http://search.cpan.org/perldoc?App::Ack)

A container for functions for the ack program

- [Archive::Any](http://search.cpan.org/perldoc?Archive::Any)

Single interface to deal with file archives.

- [Archive::Tar](http://search.cpan.org/perldoc?Archive::Tar)

module for manipulations of tar archives

- [Archive::Tar::Builder](http://search.cpan.org/perldoc?Archive::Tar::Builder)

Stream tarball data to a file handle

- [Authen::Libwrap](http://search.cpan.org/perldoc?Authen::Libwrap)

access to Wietse Venema's TCP Wrappers library

- [B::C](http://search.cpan.org/perldoc?B::C)

Perl compiler's C backend

- [B::Flags](http://search.cpan.org/perldoc?B::Flags)

Friendlier flags for B

- [BSD::Resource](http://search.cpan.org/perldoc?BSD::Resource)

BSD process resource limit and priority functions

- [Business::ISBN](http://search.cpan.org/perldoc?Business::ISBN)

work with International Standard Book Numbers

- [Capture::Tiny](http://search.cpan.org/perldoc?Capture::Tiny)

Capture STDOUT and STDERR from Perl, XS or external programs

- [Class::C3](http://search.cpan.org/perldoc?Class::C3)

A pragma to use the C3 method resolution order algortihm

- [Class::Inspector](http://search.cpan.org/perldoc?Class::Inspector)

Get information about a class and its structure

- [Compress::Zlib](http://search.cpan.org/perldoc?Compress::Zlib)

Interface to zlib compression library

- [Crypt::DES\_EDE3](http://search.cpan.org/perldoc?Crypt::DES\_EDE3)

Triple-DES EDE encryption/decryption

- [Crypt::OpenPGP](http://search.cpan.org/perldoc?Crypt::OpenPGP)

Pure-Perl OpenPGP implementation

- [Crypt::Random](http://search.cpan.org/perldoc?Crypt::Random)

Cryptographically Secure, True Random Number Generator.

- [Cwd](http://search.cpan.org/perldoc?Cwd)

get pathname of current working directory

- [DBD::Mock](http://search.cpan.org/perldoc?DBD::Mock)

Mock database driver for testing

- [DBD::Pg](http://search.cpan.org/perldoc?DBD::Pg)

PostgreSQL database driver for the DBI module

- [DBI](http://search.cpan.org/perldoc?DBI)

Database independent interface for Perl

- [Date::Parse](http://search.cpan.org/perldoc?Date::Parse)

Parse date strings into time values

- [DateTime](http://search.cpan.org/perldoc?DateTime)

A date and time object

- [Devel::Cover](http://search.cpan.org/perldoc?Devel::Cover)

Code coverage metrics for Perl

- [Devel::NYTProf](http://search.cpan.org/perldoc?Devel::NYTProf)

Powerful fast feature-rich perl source code profiler

- [Devel::REPL](http://search.cpan.org/perldoc?Devel::REPL)

a modern perl interactive shell

- [Devel::Size](http://search.cpan.org/perldoc?Devel::Size)

Perl extension for finding the memory usage of Perl variables

- [Diff::LibXDiff](http://search.cpan.org/perldoc?Diff::LibXDiff)

Calculate a diff with LibXDiff (via XS)

- [Digest::MD5](http://search.cpan.org/perldoc?Digest::MD5)

Perl interface to the MD5 Algorithm

- [Dist::Zilla::Plugin::Repository](http://search.cpan.org/perldoc?Dist::Zilla::Plugin::Repository)

Publish repo information into META for a dzil distro.

- [Dist::Zilla::PluginBundle::Git](http://search.cpan.org/perldoc?Dist::Zilla::PluginBundle::Git)

Git related utilities for building dzil modules.

- [Dist::Zilla::Plugin::GitHub::Meta](http://search.cpan.org/perldoc?Dist::Zilla::Plugin::GitHub::Meta)

Utilities for publishing dzil modules to Github

- [Email::Address](http://search.cpan.org/perldoc?Email::Address)

RFC 2822 Address Parsing and Creation

- [Encode::Detect](http://search.cpan.org/perldoc?Encode::Detect)

An Encode::Encoding subclass that detects the encoding of data

- [Expect](http://search.cpan.org/perldoc?Expect)

Expect for Perl

- [Error](http://search.cpan.org/perldoc?Error)

Error/exception handling in an OO-ish way

- [ExtUtils::CBuilder](http://search.cpan.org/perldoc?ExtUtils::CBuilder)

Compile and link C code for Perl modules

- [ExtUtils::Constant](http://search.cpan.org/perldoc?ExtUtils::Constant)

generate XS code to import C header constants

- [File::Comments](http://search.cpan.org/perldoc?File::Comments)

Recognizes file formats and extracts format-specific comments

- [File::Comments::Plugin::C](http://search.cpan.org/perldoc?File::Comments::Plugin::C)

Plugin to detect comments in C/C++ source code

- [File::Copy::Recursive](http://search.cpan.org/perldoc?File::Copy::Recursive)

Perl extension for recursively copying files and directories

- [File::Glob](http://search.cpan.org/perldoc?File::Glob)

Perl extension for BSD glob routine

- [File::Path::Tiny](http://search.cpan.org/perldoc?File::Path::Tiny)

recursive versions of mkdir() and rmdir() without as much overhead as File::Path

- [File::Which](http://search.cpan.org/perldoc?File::Which)

Portable implementation of the which utility

- [Filesys::Df](http://search.cpan.org/perldoc?Filesys::Df)

Perl extension for filesystem disk space information.

- [Filesys::POSIX](http://search.cpan.org/perldoc?Filesys::POSIX)

Provide POSIX-like filesystem semantics in pure Perl

- [Filter::Util::Call](http://search.cpan.org/perldoc?Filter::Util::Call)

Perl Source Filter Utility Module

- [GSSAPI](http://search.cpan.org/perldoc?GSSAPI)

Perl extension providing access to the GSSAPIv2 library

- [Getopt::Euclid](http://search.cpan.org/perldoc?Getopt::Euclid)

Executable Uniform Command-Line Interface Descriptions

- [Getopt::Param](http://search.cpan.org/perldoc?Getopt::Param)

param() style opt handling

- [Git::Repository](http://search.cpan.org/perldoc?Git::Repository)

Perl interface to Git repositories

- [Git::Wrapper](http://search.cpan.org/perldoc?Git::Wrapper)

Wrap git(7) command-line interface

- [Graph::Easy::As\_svg](http://search.cpan.org/perldoc?Graph::Easy::As\_svg)

Output a Graph::Easy as Scalable Vector Graphics (SVG)

- [Graph::Easy::Manual](http://search.cpan.org/perldoc?Graph::Easy::Manual)

HTML manual for Graph::Easy

- [IO::AIO](http://search.cpan.org/perldoc?IO::AIO)

Asynchronous Input/Output

- [IO::Interface](http://search.cpan.org/perldoc?IO::Interface)

Perl extension for access to network card configuration information

- [IO::Prompt](http://search.cpan.org/perldoc?IO::Prompt)

Interactively prompt for user input

- [IO::Tty](http://search.cpan.org/perldoc?IO::Tty)

Low-level allocate a pseudo-Tty, import constants.

- [Image::Xbm](http://search.cpan.org/perldoc?Image::Xbm)

Load, create, manipulate and save xbm image files.

- [Image::Xpm](http://search.cpan.org/perldoc?Image::Xpm)

Load, create, manipulate and save xpm image files.

- [JSON::XS](http://search.cpan.org/perldoc?JSON::XS)

JSON serialising/deserialising, done correctly and fast

- [Log::Log4perl](http://search.cpan.org/perldoc?Log::Log4perl)

Log4j implementation for Perl

- [Mail::SendEasy](http://search.cpan.org/perldoc?Mail::SendEasy)

Send plain/html e-mails through SMTP servers (platform independent). Supports SMTP authentication and attachments.

- [Mail::Sender::Easy](http://search.cpan.org/perldoc?Mail::Sender::Easy)

Super Easy to use simplified interface to Mail::Sender&\#39;s excellentness

- [Math::BigInt::GMP](http://search.cpan.org/perldoc?Math::BigInt::GMP)

Use the GMP library for Math::BigInt routines

- [Math::BigInt::Pari](http://search.cpan.org/perldoc?Math::BigInt::Pari)

Use Math::Pari for Math::BigInt routines

- [Math::Pari](http://search.cpan.org/perldoc?Math::Pari)

Perl interface to PARI.

- [Math::Round](http://search.cpan.org/perldoc?Math::Round)

Perl extension for rounding numbers

- [Module::Extract::VERSION](http://search.cpan.org/perldoc?Module::Extract::VERSION)

Extract a module version without running code

- [Module::Install](http://search.cpan.org/perldoc?Module::Install)

Standalone, extensible Perl module installer

- [Module::Metadata](http://search.cpan.org/perldoc?Module::Metadata)

Gather package and POD information from perl module files

- [Module::Signature](http://search.cpan.org/perldoc?Module::Signature)

Module signature file manipulation

- [Module::Want](http://search.cpan.org/perldoc?Module::Want)

Check @INC once for modules that you want but may not have

- [Moo](http://search.cpan.org/perldoc?Moo)

Minimalist Object Orientation (with Moose compatiblity)

- [Moose](http://search.cpan.org/perldoc?Moose)

A postmodern object system for Perl 5

- [Net::Ident](http://search.cpan.org/perldoc?Net::Ident)

lookup the username on the remote end of a TCP/IP connection

- [Net::Jabber::Bot](http://search.cpan.org/perldoc?Net::Jabber::Bot)

Automated Bot creation with safeties

- [Net::OpenSSH](http://search.cpan.org/perldoc?Net::OpenSSH)

Perl SSH client package implemented on top of OpenSSH

- [Net::SSLeay](http://search.cpan.org/perldoc?Net::SSLeay)

Perl extension for using OpenSSL

- [Net::TCPwrappers](http://search.cpan.org/perldoc?Net::TCPwrappers)

Perl interface to tcp\_wrappers.

- [Opcodes](http://search.cpan.org/perldoc?Opcodes)

More Opcodes information from opnames.h and opcode.h

- [Path::Iter](http://search.cpan.org/perldoc?Path::Iter)

Simple Efficient Path Iteration

- [Perl::Tidy](http://search.cpan.org/perldoc?Perl::Tidy)

Parses and beautifies perl source

- [Perlbal](http://search.cpan.org/perldoc?Perlbal)

Reverse-proxy load balancer and webserver

- [Pristine::Tar](http://search.cpan.org/perldoc?Pristine::Tar)

regenerate a pristine upstream tarball using only a small binary delta file and a copy of the source

- [Pod::Markdown](http://search.cpan.org/perldoc?Pod::Markdown)

Converts POD to Markdown in order to generate README.md files on github

- [REST::Google::Translate](http://search.cpan.org/perldoc?REST::Google::Translate)

OO interface to Google Translate (aka Languages) API

- [REST::Google::Translate2](http://search.cpan.org/perldoc?REST::Google::Translate2)

OO interface to Google Translate API v2

- [Readonly::XS](http://search.cpan.org/perldoc?Readonly::XS)

Companion module for Readonly.pm, to speed up read-only scalar variables.

- [Regexp::Parser](http://search.cpan.org/perldoc?Regexp::Parser)

base class for parsing regexes

- [SOAP::Lite](http://search.cpan.org/perldoc?SOAP::Lite)

Perl's Web Services Toolkit

- [Storable](http://search.cpan.org/perldoc?Storable)

persistence for Perl data structures

- [String::BOM](http://search.cpan.org/perldoc?String::BOM)

simple utilities to check for a BOM and strip a BOM

- [String::CRC32](http://search.cpan.org/perldoc?String::CRC32)

Perl interface for cyclic redundency check generation

- [Sub::Install](http://search.cpan.org/perldoc?Sub::Install)

install subroutines into packages easily

- [Test::Class](http://search.cpan.org/perldoc?Test::Class)

Easily create test classes in an xUnit/JUnit style

- [Test::CPAN::Meta](http://search.cpan.org/perldoc?Test::CPAN::Meta)

Validation of the META.yml file in a CPAN distribution.

- [Test::Exception](http://search.cpan.org/perldoc?Test::Exception)

Test exception based code

- [Test::File::Contents](http://search.cpan.org/perldoc?Test::File::Contents)

Test routines for examining the contents of files

- [Test::Manifest](http://search.cpan.org/perldoc?Test::Manifest)

interact with a t/test\_manifest file

- [Test::MinimumVersion](http://search.cpan.org/perldoc?Test::MinimumVersion)

does your code require newer perl than you think?

- [Test::Mock::Cmd](http://search.cpan.org/perldoc?Test::Mock::Cmd)

Mock system(), exec(), and qx() for testing

- [Test::MockModule](http://search.cpan.org/perldoc?Test::MockModule)

Override subroutines in a module for unit testing

- [Test::MockObject](http://search.cpan.org/perldoc?Test::MockObject)

Perl extension for emulating troublesome interfaces

- [Test::NoWarnings](http://search.cpan.org/perldoc?Test::NoWarnings)

Make sure you didn't emit any warnings while testing

- [Test::Object](http://search.cpan.org/perldoc?Test::Object)

Thoroughly testing objects via registered handlers

- [Test::Output](http://search.cpan.org/perldoc?Test::Output)

Utilities to test STDOUT and STDERR messages.

- [Test::Parallel](http://search.cpan.org/perldoc?Test::Parallel)

simple object interface to launch unit test in parallel

- [Test::Pod](http://search.cpan.org/perldoc?Test::Pod)

check for POD errors in files

- [Test::Pod::Coverage](http://search.cpan.org/perldoc?Test::Pod::Coverage)

Check for pod coverage in your distribution.

- [Test::Script](http://search.cpan.org/perldoc?Test::Script)

Basic cross-platform tests for scripts

- [Test::SubCalls](http://search.cpan.org/perldoc?Test::SubCalls)

Track the number of times subs are called

- [Test::Tester](http://search.cpan.org/perldoc?Test::Tester)

Ease testing test modules built with Test::Builder

- [Test::Unit](http://search.cpan.org/perldoc?Test::Unit)

the PerlUnit testing framework

- [Test::Warn](http://search.cpan.org/perldoc?Test::Warn)

Perl extension to test methods for warnings

- [Test::YAML::Meta](http://search.cpan.org/perldoc?Test::YAML::Meta)

Validation of the META.yml file in a distribution.

- [Test::YAML::Valid](http://search.cpan.org/perldoc?Test::YAML::Valid)

Test for valid YAML

- [Text::Extract::MaketextCallPhrases](http://search.cpan.org/perldoc?Text::Extract::MaketextCallPhrases)

Extract phrases from maketext--call--looking text

- [Text::Fold](http://search.cpan.org/perldoc?Text::Fold)

Turn "unicode" and "byte" string text into lines of a given width, soft-hyphenating broken words 

- [Text::Iconv](http://search.cpan.org/perldoc?Text::Iconv)

Perl interface to iconv() codeset conversion function

- [Text::Trim](http://search.cpan.org/perldoc?Text::Trim)

remove leading and/or trailing whitespace from strings

- [Time::HiRes](http://search.cpan.org/perldoc?Time::HiRes)

High resolution alarm, sleep, gettimeofday, interval timers

- [Variable::Magic](http://search.cpan.org/perldoc?Variable::Magic)

Associate user-defined magic to variables from Perl.

- [WWW::Mechanize](http://search.cpan.org/perldoc?WWW::Mechanize)

Handy web browsing in a Perl object

- [XML::DOM](http://search.cpan.org/perldoc?XML::DOM)

A perl module for building DOM Level 1 compliant document structures

- [XML::SAX](http://search.cpan.org/perldoc?XML::SAX)

Simple API for XML

- [YAML](http://search.cpan.org/perldoc?YAML)

YAML Ain't Markup Language (tm)

- [cPanel::SyncUtil](http://search.cpan.org/perldoc?cPanel::SyncUtil)

Perl extension for creating utilities that work with cpanelsync aware directories

# AUTHOR

cPanel, `<cpanel at cpan.org>`

# BUGS

Please report any bugs or feature requests to `bug-task-cpanel-internal at rt.cpan.org`, or through
the web interface at [http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Task-Cpanel-Internal](http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Task-Cpanel-Internal).  We will be notified, and then you'll
automatically be notified of progress on your bug as we make changes.

# SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Task::Cpanel::Internal



You can also look for information at:

- RT: CPAN's request tracker (report bugs here)

[http://rt.cpan.org/NoAuth/Bugs.html?Dist=Task-Cpanel-Internal](http://rt.cpan.org/NoAuth/Bugs.html?Dist=Task-Cpanel-Internal)

- AnnoCPAN: Annotated CPAN documentation

[http://annocpan.org/dist/Task-Cpanel-Internal](http://annocpan.org/dist/Task-Cpanel-Internal)

- CPAN Ratings

[http://cpanratings.perl.org/d/Task-Cpanel-Internal](http://cpanratings.perl.org/d/Task-Cpanel-Internal)

- Meta CPAN

[http://metacpan.org/module/Task-Cpanel-Internal/](http://metacpan.org/module/Task-Cpanel-Internal/)



# LICENSE AND COPYRIGHT

Copyright 2012 cPanel.

All rights reserved.

http://cpanel.net

This is free software; you can redistribute it and/or modify it under the
same terms as Perl itself. See [perlartistic](http://search.cpan.org/perldoc?perlartistic).

See http://dev.perl.org/licenses/ for more information.
