#!/usr/bin/env perl

use strict;
use warnings;
use v5.30;

use PDK::Device::H3c;
use PDK::Device::Cisco;
use PDK::Concern::Netdisco::H3c;
use PDK::Concern::Netdisco::Cisco;
use Data::Dumper;
use Data::Printer;

my $config = <<NXOS;
ZHBG-CSW01# show cdp neighbor | begin Device[- ]ID
Device ID        Local Intrfce     Holdtme    Capability  Platform  Port ID
ZHBG-LEAF02.cisco.com(FDO25432FSE)
                 Twe 1/0/28        152             R S C  N9K-C9318 mgmt0
ZHBG-LEAF02.cisco.com(FDO25432FSE)
                 Twe 2/0/2         152             R S C  N9K-C9318 Eth 1/47
ZHBG-LEAF02.cisco.com(FDO25432FSE)
                 Twe 2/0/2         152             R S C  N9K-C9318 Eth 1/48
ZHBG-LEAF09.cisco.com(FDO25432FKX)
                 Twe 2/0/37        126             R S C  N9K-C9318 mgmt0
ZHBG-LEAF16.cisco.com(FDO272205Z1)
                 Twe 2/0/38        178             R S C  N9K-C9318 mgmt0
PAAS-02          Twe 2/0/38        162               H    DM5000H   e0M
PAAS-01          Twe 2/0/38        131               H    DM5000H   e0M
ZHBG-BDR02.cisco.com(FDO25432F50)
                 Twe 1/0/31        150             R S C  N9K-C9318 mgmt0
ZHBG-LEAF08.cisco.com(FDO26251LTT)
                 Twe 2/0/36        172             R S C  N9K-C9310 mgmt0
ZHBG-LEAF07.cisco.com(FDO262524E1)
                 Twe 2/0/36        164             R S C  N9K-C9310 mgmt0
ZHBG-LEAF10.cisco.com(FDO25432F07)
                 Twe 2/0/37        153             R S C  N9K-C9318 mgmt0

Device ID        Local Intrfce     Holdtme    Capability  Platform  Port ID
ZHBG-SPN02.cisco.com(FDO25460TPN)
                 Twe 1/0/31        150             R S C  N9K-C9336 mgmt0
ZHBG-LEAF12.cisco.com(FDO23080F21)
                 Twe 2/0/35        127             R S C  N9K-C9310 mgmt0
ZHBG-LEAF13.cisco.com(FDO27010M43)
                 Twe 2/0/38        143             R S C  N9K-C9318 mgmt0
Nova463-CYKG     Twe 2/0/5         138            R B S I CISCO2911 Gig 0/2
Nova463-CYKG     Twe 1/0/41        146            R B S I CISCO2911 Gig 0/1
ZHBG-LEAF11.cisco.com(FDO23100YQC)
                 Twe 1/0/34        145             R S C  N9K-C9310 mgmt0
ZHBG-LEAF06(FDO27220634)
                 Twe 2/0/33        150             R S C  N9K-C9318 mgmt0
ZHBG-BDR01.cisco.com(FDO26221F1Y)
                 Twe 2/0/30        173             R S C  N9K-C9318 mgmt0
ZHBG-SPN01.cisco.com(FDO26390442)
                 Twe 2/0/30        174             R S C  N9K-C9336 mgmt0
ZHBG-LEAF05.cisco.com(FDO262524DL)
                 Twe 2/0/33        160             R S C  N9K-C9310 mgmt0
ZHBG-LEAF01.cisco.com(FDO262524HY)
                 Twe 1/0/27        134             R S C  N9K-C9310 mgmt0
ZHBG-LEAF03.cisco.com(FDO261309NW)
                 Twe 1/0/29        135             R S C  N9K-C9318 mgmt0
ZHBG-LEAF03.cisco.com(FDO261309NW)

Device ID        Local Intrfce     Holdtme    Capability  Platform  Port ID
                 Twe 2/0/2         135             R S C  N9K-C9318 Eth 1/48
ZHBG-LEAF03.cisco.com(FDO261309NW)
                 Twe 2/0/2         135             R S C  N9K-C9318 Eth 1/47
ZHBG-LEAF15.cisco.com(FDO272205YC)
                 Twe 2/0/38        126             R S C  N9K-C9318 mgmt0
ZHBG-LEAF04.cisco.com(FDO261309NX)
                 Twe 1/0/32        162             R S C  N9K-C9318 mgmt0
ZHBG-LEAF14.cisco.com(FDO265316LQ)
                 Twe 2/0/38        126             R S C  N9K-C9318 mgmt0
DM7100F-01       Twe 1/0/30        144               H    DM7100H   e0M
FAS_C01-01       Twe 2/0/37        176               H    FAS2720   e0M
FAS_C02-02       Twe 2/0/37        151               H    FAS2720   e0M
DM7100F-02       Twe 1/0/31        173               H    DM7100H   e0M
FAS_C01-02       Twe 2/0/37        177               H    FAS2720   e0M
FAS_C02-01       Twe 2/0/37        153               H    FAS2720   e0M
DM3000H-02       Twe 2/0/31        174               H    DM3000H   e0M
DM3000H-01       Twe 1/0/30        172               H    DM3000H   e0M

Total cdp entries displayed : 36
NXOS

my @config = split(/\n/, $config);
say Dumper @config;

my $d = PDK::Device::Cisco->new(host => 'fake');
my $nd = PDK::Concern::Netdisco::Cisco->new(device => $d, debug => 1);
say Dumper $nd->gen_iface_desc(\@config);
