#!/usr/bin/env perl

use strict;
use warnings;
use v5.30;

use PDK::Device::H3c;
use PDK::Device::Cisco;
use PDK::Concern::Netdisco::H3c;
use PDK::Concern::Netdisco::Cisco;
use Data::Dumper;
use Data::Printer;

my $config = <<NXOS;
ZSWE-CSW01# show cdp neighbor | begin Device[- ]ID
Device ID        Local Intrfce     Holdtme    Capability  Platform  Port ID
ZSWE-BDR01.transsion.com(FDO233201JA)
                    mgmt0          172    R S s     N9K-C93180YC- mgmt0
ZSWE-LEF07(FDO23100CJS)
                    mgmt0          172    R S s     N9K-C93108TC- mgmt0
ZSWE-LEF04(FDO23100YME)
                    mgmt0          172    R S s     N9K-C93108TC- mgmt0
ZSWE-LEF03(FDO23440ZDB)
                    mgmt0          172    R S s     N9K-C93108TC- mgmt0
ZSWE-LEF05(FDO23100DB0)
                    mgmt0          172    R S s     N9K-C93108TC- mgmt0
ZSWE-LEF06(FDO231014DF)
                    mgmt0          172    R S s     N9K-C93108TC- mgmt0
ZSWE-BDR02(FDO27110NBX)
                    mgmt0          161    R S s     N9K-C93180YC- mgmt0
ZSWE-LEF02(FDO23100CLG)
                    mgmt0          172    R S s     N9K-C93108TC- mgmt0
ZSWE-SPN02(FDO230906H6)
                    mgmt0          172    R S s     N9K-C9336C-FX mgmt0
ZSWE-SPN01.transsion.com(FDO25460TMP)
                    mgmt0          172    R S s     N9K-C9336C-FX mgmt0
ZSWE-SPN01.transsion.com(FDO25460TMP)
                    Eth1/49        172    R S s     N9K-C9336C-FX Eth1/1
ZSWE-SPN02(FDO230906H6)
                    Eth1/50        172    R S s     N9K-C9336C-FX Eth1/1

Total entries displayed: 12
NXOS

my @config = split(/\n/, $config);
say Dumper @config;

my $d = PDK::Device::Cisco->new(host => 'fake');
my $nd = PDK::Concern::Netdisco::Cisco->new(device => $d, debug => 1);
say Dumper $nd->gen_iface_desc(\@config);
