#!/usr/bin/env perl
use Module::Build;
use strict; use warnings;

my $class = Module::Build->subclass(
  class => 'POEx::ZMQ3::Builder',
  code  => q[

    sub ACTION_versionify {
      my $self = shift;

      my $base = $self->base_dir;
      my $vers = $self->dist_version;

      ++$|;

      print "Versionifying ($vers) ";
      require File::Find;
      File::Find->import('find');

      my $x;
      find(sub {
          if ($_ =~ /\.pm(.in)?$/) {
            my $path = $File::Find::name;
            open my $fh, '<', $path
              or die "open: $path $!";
            my @thisf = readline($fh);
            close $fh;

            my $package_l = $thisf[0] || return;
            my $pkg;
            unless (($pkg) = $package_l =~ /^package\s+(\S+)$/) {
              warn "\nSkipping, no package: $path\n";
              return
            }

            ++$x;
            print ". ";

            my $v_line = "our \$VERSION = '$vers';\n";

            if ($thisf[1] =~ /VERSION/) {
              $thisf[1] = $v_line
            }

            open $fh, '>', $path
              or die "open: $path $!";
            print $fh @thisf;
            close $fh;
          }
        },
        $base."/lib"
      );
      print "\n$x modules\n";
    }

  ],
);

my $build = $class->new(
  module_name => 'POEx::ZMQ3',
  license     => 'perl',

  dist_abstract => 'POE-enabled ZeroMQ components',
  dist_author   => 'Jon Portnoy <avenj@cobaltirc.org>',

  recursive_test_files => 1,

  create_readme      => 1,
  create_makefile_pl => 'small',

  configure_requires => {
    'Module::Build' => '0.40',
  },

  build_requires => {
    'Test::More'      => 0,
    'Test::TCP'       => 0,
  },

  requires => {
    'perl'     => '5.10.1',
    'Carp'     => 0,
    'Storable' => 0,

    ## Faster simple accessors.
    ## You need a C compiler for ZMQ, anyway:
    'Class::XSAccessor'         => 0,

    'strictures'                => 1,
    'namespace::clean'          => '0.23',

    'Moo'                       => '1.000003',
    'MooX::Role::POE::Emitter'  => '0.10',

    'POE'                       => '1.3',

    'Try::Tiny'                 => 0,

    'ZMQ::LibZMQ3'              => '1.03',
    'ZMQ::Constants'            => '1.02',
  },

  recommends => {
  },

  meta_merge => {
    resources => {
      repository => 'http://github.com/avenj/poex-zmq3.git',
    },
  },
);

$build->create_build_script;

__END__
Cake.
