#!/usr/bin/perl -w
# $File: //member/autrijus/PAR/myldr/Makefile.PL $ $Author: autrijus $
# $Revision: #11 $ $Change: 3309 $ $DateTime: 2003/01/07 13:30:13 $
#
# Copyright (c) 2002 Mattia Barbon.
# Copyright (c) 2002 Autrijus Tang.
# This package is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.

use strict;
use Config;
use File::Spec;
use ExtUtils::Embed;

xsinit(undef);

my $debug = 0;

my $exe = $Config{_exe};
my $o = $Config{obj_ext};
my $pccflags = ccopts;
my $pldflags = ldopts;
my $ld = $Config{ld};
my $cc = $Config{cc};
my $f2c = File::Spec->catfile(".", "file2c.pl");
my $par_pl = File::Spec->catfile('..', 'script', "par.pl");
my $par_exe = File::Spec->catfile('.', "par$exe");
my $parl_exe = File::Spec->catfile('..', 'script', "parl$exe");
my $lib_path = join(' ', map "-I$_", @INC);

system($^X, $f2c, $par_pl, 'my_par_pl.c', 'load_me_2');

print "Writing Makefile for the par$exe program\n";

open OUT, "> Makefile" or die "open 'Makefile': $!";

my( $out, $ccdebug, $lddebug, $warn, $rm, $mv );

if( $cc =~ m/^cl/ ) {
    $out = '-out:';
    $ccdebug = $debug ? '-Zi ' : '';
    $lddebug = $debug ? '-debug ' : '-release ';
    $warn = $debug ? '-W3' : '';
} elsif ($cc =~ m/^gcc/) {
    $out = '-o ';
    $ccdebug = $debug ? '-g ' : '';
    $lddebug = $debug ? '' : '-s ';
    $warn = $debug ? '-Wall -Wno-comments ' : '';
} else {
    $out = '-o ';
    $ccdebug = '';
    $lddebug = '';
    $warn = '';
}

$rm = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e rm_f' : 'rm';
$mv = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e mv' : 'mv';

my  $cflags = "$ccdebug$warn$pccflags";
my $ldflags = "$lddebug$pldflags";

print OUT <<EOT;
# AUTOGENERATED, DO NOT EDIT, RERUN Makefile.PL

RM=$rm
MV=$mv
PERL=$^X
LD=$ld
CC=$cc
CFLAGS=$cflags
LDFLAGS=$ldflags
NOOP=\$(PERL) -e1

OBJECTS=main$o

.c$o:
	\$(CC) -c \$(CFLAGS) \$<

all: $parl_exe

clean:
	-\$(RM) my_par_pl.c
	-\$(RM) *$o
	-\$(RM) *.opt *.pdb perlxsi.c
	\$(MV) Makefile Makefile.old

realclean: clean
	-\$(RM) $par_exe
	-\$(RM) $parl_exe
	-\$(RM) Makefile Makefile.old

distclean: clean
	-\$(RM) $par_exe
	-\$(RM) $parl_exe
	-\$(RM) Makefile Makefile.old

$par_exe: \$(OBJECTS) my_par_pl.c
	\$(LD) \$(OBJECTS) \$(LDFLAGS) $out\$@

$parl_exe: $par_exe
	$par_exe -I../blib/lib $lib_path -B -O$parl_exe

main$o: main.c

disttest:
	-\$(NOOP)

test:
	-\$(NOOP)

.DEFAULT:
	-\$(NOOP)

.SUFFIXES: $o

EOT

# local variables:
# mode: cperl
# end:
