package Evo::Loop;
use Evo '-Realm *; -Export *; -Realm *';
use Evo ':Comp';

use constant DEFAULT => Evo::Loop::Comp::new();

sub start : Export(loop_start) { DEFAULT->realm_lord->start(@_) }

sub timer : Export(loop_timer) { DEFAULT->realm_lord->timer(@_); }

sub timer_remove : Export(loop_timer_remove) {
  DEFAULT->realm_lord->timer_remove(@_);
}


sub handle : Export(loop_handle)             { DEFAULT->realm_lord->handle(@_) }
sub handle_catch : Export(loop_handle_catch) { DEFAULT->realm_lord->handle_catch(@_) }

sub handle_remove : Export(loop_handle_remove) {
  DEFAULT->realm_lord->handle_remove(@_);
}


sub postpone : prototype(&) : Export(loop_postpone) { DEFAULT->realm_lord->postpone(@_) }

sub zone : Export(loop_zone) { DEFAULT->realm_lord->zone(@_) }

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Loop

=head1 VERSION

version 0.0183

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
