package main;
use Evo;
use Test::More;
use Benchmark ':all';
use Evo::Mdn;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $EXPECT = 10 * $ENV{TEST_EVO_PERF};
my $N      = 30;
my $n      = 100;
my $k      = 100;

my $sender = My::Obj->new;
my $mdn    = Evo::Mdn->new;
my $I;

my $t = timeit(
  $N,
  sub {
    my @senders     = map { My::Obj->new } 1 .. $n;
    my @subscribers = map { My::Obj->new } 1 .. $k;

    foreach my $snd (@senders) {
      $mdn->subscribe($_, $snd, 0, sub { $I++ }) for @subscribers;
    }

    $mdn->broadcast($_, 'foo') for @senders;
  }
);

ok $I == $n * $k * $N, "$I = $n x $k x $N";
diag "$I: $N(iters) x $n(senders) x $k(subscriberds); " . timestr $t;

my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";

done_testing;

{

  package My::Obj;
  use Evo -class;
}
