package main;
use Evo ':all';
use Test::More;
use Benchmark ':all';

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

# not more that 1.15 times
my $EXPECT_DIFF = 5;
my $EXPECT      = 200_000;
my $N           = 1_000_000;

{

  package MyFoo;
  use Evo -class;
  has 'val';

}

my ($t_evo, $t_pure);
call {foo => 'MyFoo'}, sub {
  $t_evo = timeit($N, sub { die unless dep_new(foo => val => 2)->val == 2 });
};

my $perf_evo = $N / $t_evo->cpu_a;
diag $perf_evo;
ok $perf_evo > $EXPECT, "$perf_evo > $EXPECT";


# compair with pure
$t_pure = timeit($N, sub { die unless MyFoo::->new(val => 2)->val == 2 });
my $perf_pure = $N / $t_pure->cpu_a;
my $diff      = $perf_pure / $perf_evo;
diag $perf_evo;
diag $perf_pure;
diag $diff;

ok $diff < $EXPECT_DIFF, "$diff < $EXPECT_DIFF";

done_testing;
