package main;
use Evo::Base -strict;
use Evo;
use Test::More;
use Benchmark ':all';

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $EXPECT = 70_000;
my $N      = 100_000;

my $sender = Evo::Base->new;

my $t = timeit(
  $N,
  sub {
    my $me = Evo::Base->new;
    Evo::mdn_subscribe $me, $sender, sub { };
    Evo::mdn_broadcast $sender, 'foo';
  }
);

diag timestr $t;
my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";

done_testing;
