package Evo::Guard;
use Evo::Base -base;

has 'cb';
sub DESTROY { (delete $_[0]->{cb} or return)->(); }

1;

# ABSTRACT: A guard

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Guard - A guard

=head1 VERSION

version 0.0155

=head1 SYNOPSIS

  use Evo::Base -strict;
  use Evo::Guard;
  my $guard = Evo::Guard->new(cb => sub { say "done" });
  undef $guard;

=head1 DESCRIPTION

  Executes a code when no refs are pointed to this object.
  The behavoiur is the same as L<Guard/"guard">, but this module is pure
  perl (and about 70-80% slower). But that doesn't really matter at all

=head1 ATTRIBUTES

=head2 cb

A callback that will be eventually executed

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
