package main;
use Evo::Base -strict;
use Evo::Manager;
use Evo;
use Time::Piece;
use Time::HiRes;
use Test::More;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my ($start, $end, $dur);
my $me = Receiver->new;

#1Kx1K 9.5mb 5-6s
my $N = 1000;
my $L = 1000;

$start = localtime;

for (1 .. $N) {
  my @senders;
  push @senders, Evo::Base->new for 1 .. $L;
  Evo::mdn_subscribe $me, $_ foreach @senders;
  Evo::mdn_unsubscribe_from_all $me;
}

$end = localtime;
$dur = $end - $start;
diag "Subscribe/Unsubscribe to $L senders $N times:, $dur";
ok $dur< 10;

done_testing;

{

  package Receiver;
  use Evo::Base -base;
  sub when_message($self, $msg, $from) {$msg}
}

