package main;
use Evo::Base -strict;
use Test::More;
use Evo::MDN;
use Test::Fatal qw(lives_ok exception);
use Hash::Util::FieldHash qw(id);

my ($FROM, $MSG);
my $mdn  = Evo::MDN->new;
my $from = Evo::Base->new;
my $me   = Evo::Base->new;

# not implemented when_message
like exception {
  $mdn->subscribe(Evo::Base->new, $from);
},
  qr/when_message/;

like exception {
  $mdn->subscribe($me, $from, sub { });
  $mdn->subscribe($me, $from, sub { });
}, qr/has been subscribed to/i;

# not subscribed, prev subscriber didn't unsubscribe
# with the same memory address
lives_ok {
  delete $mdn->_all_subscribers->{id($me)};
  $mdn->subscribe($me, $from, sub { });
};

done_testing;

