package main;
use Evo::Base -strict;
use Test::More;
use Evo::Messenger;

my ($FROM, $MSG);
my $msn      = Evo::Messenger->new;
my $sender   = Receiver->new;
my $receiver = Receiver->new;

$msn->subscribe($receiver, $sender);
$msn->broadcast($sender, 'foo');

is $FROM, $sender;
is $MSG,  'foo';

# unsubscribe, must be unchanged
$msn->unsubscribe($receiver, $sender);
$msn->broadcast($sender, 'BAD');
is $FROM, $sender;
is $MSG,  'foo';

{

  package Receiver;
  use Evo::Base -base;
  sub when_message($self, $msg, $from) { $FROM = $from; $MSG = $msg }
}

done_testing;
