package Plack::Middleware::Acme::PHPE9568F34::D428::11d2::A769::00AA001ACF42;
{
  $Plack::Middleware::Acme::PHPE9568F34::D428::11d2::A769::00AA001ACF42::VERSION = '3.141000';
}

# ABSTRACT: Implement PHP's best features with PSGI!

use strict;
use warnings;

use MIME::Base64;
use Data::Section -setup;

my $get_image = sub {
   my ($self, $section) = @_;

   my $data = ${$self->section_data($section)};
   $data =~ s/^\s+//mg;
   $data =~ s/\s+$//mg;
   decode_base64($data)
};

sub sillies {
   my $self = shift;

   (
      '=PHPE9568F34-D428-11d2-A769-00AA001ACF42' => $self->$get_image('logo'),
      '=PHPE9568F35-D428-11d2-A769-00AA001ACF42' => $self->$get_image('zend'),
      '=PHPE9568F36-D428-11d2-A769-00AA001ACF42' => $self->$get_image('child'),
   )
}

use base 'Plack::Middleware';

sub call {
   my($self, $env) = @_;

   my %responses = $self->sillies;
   if (my $ret = $responses{$env->{QUERY_STRING}}) {
      return [ 200, [
        'Content-Type' => 'image/gif',
        'X-PHP-SUX' => '1',
      ], [ $ret ] ]
   } else {
      return $self->app->($env);
   }
}

1;

=pod

=head1 NAME

Plack::Middleware::Acme::PHPE9568F34::D428::11d2::A769::00AA001ACF42 - Implement PHP's best features with PSGI!

=head1 VERSION

version 3.141000

=head1 SYNOPSIS

 builder {
    enable 'Plack::Middleware::Acme::PHPE9568F34::D428::11d2::A769::00AA001ACF42';
    $app;
 }

=head1 DESCRIPTION

Who in the Perl community doesn't envy PHP's
L<awesome features|http://phpsadness.com/?page=sad/11>?  This module will give
you the features you've always hoped and dreamed for!

=head1 AUTHOR

Arthur Axel "fREW" Schmidt <frioux+cpan@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2012 by Arthur Axel "fREW" Schmidt.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
__[ logo ]__
R0lGODlheABDAOZqAH+CuDk3RyglKszN4qGky9PV57K01ENCWIOGuYKDs1JScpCSwsLE3qqs0ExLY1tc
g93e7Ds4PG5xpWptnWFjjXV5sXt+teXm8JmcxoyNwbm62Wtrkk5Oa3F0qXp6o4iLvXJ0o3RzmI6QwVpb
fuLj73t9raSl0G1wonJ2rJWWyLu92XR4roWIu5KVw9jZ6pKSxGRmkmtun6WozpSWxS4rL1NRaLO012xq
jFxbdoqNv2ZolmhqmpyfyDEuOa6w05yczVVWeJ6hypaZxYGCr2dplz89ULy+2l5giZiZyIyOv4mKuldY
fLa319XX6CIeIGxvns7Q5L/A3Hd7tHZ4p19efZmZzG5vmHN3riIeH////5COj1lWV8fGx+7u9dXU1fb2
+oKAgayqq3Ryc/Hw8Z6cnePi40tISbm4uWdkZYmJtgD/AEdGX9/g7ZuczGlrnG9zp4yMuri52bi615qb
zKeqz9vc65qcyWZkhGhniaeo0m5woIuLucbH4MfJ4WlsnJeYyyH5BAEAAGoALAAAAAB4AEMAAAf/gGqC
g4SFhoeIiYqLjI2Oj5CRkpOUlZaXlm0/bXOYnp+gP3l5Nj4acUwaGkwGPj4NMgRBPBhCLQtJIjkfGTki
LymgwqENGgx9TQVQUAN9fAxRUSpyrK90sbNCMy26HwgAFhYVVyglFgkZwcPrjCZxfC5sbBAQdS7JA9Qy
syIf/iwAEQgEQLDgN4LhpKxA8UbCCT87nkwZkoSdRTVBbAxgQ+KCRxIk8jUQskCKyZMoU6pceXJcBwkT
duiAQeEIBStDRFzEFIQJFI4eL7gwQqcFy6NIk6K88iYGjCNHHoxYcsSDzp2Qfmh0AYEjBCMEWCgdSzbp
lRM6HiwBokDBiCkz/7AuMqGhQBMXdQoYSFK2r1+kHWAsUcCBgwM8CeQayhNlAJQCA3zk+LtyAYbLmDF8
oJz0DQUFDtasUeBBsZo8Rvj0GcBkBueVH7JwmU2bS5fXSt0sWXPggIMQO91FYcCgAQLcKzFwwcK8uZnb
yJN22F2kyJrSw374kGNEBQ8L0VeqINO8uZgC4ZVeeXAgQAAOcECZMMBEDgEA6VcWEFOeORkV+Sn1hgLu
9XAHJnPQ4YMBMhwXoEpdmNEfFlwQ8KBSMazRQw8H7FHJDzI00EBJF6YEQBYTYpHFZiUm9UAAGwInSRsE
7ONgiycpN6EZX+ColB9F0EADFZHYEQQBM4CH1P8HmTXZJItHqRDGhGJc0CSJLDHp5Jb4jYWCAzQIUMMj
SGAQBJRHffBFFmy26eabWXRRQANdolQAGBOSAWebFwxg4UkL7Ckom10M0IBSQAgggAONzCAEBmIpRcBy
KVZqBhhcfAEgSl1sUWmKNGyhRRldkGjAlJ9OuAUYXnRxKFIjCOAEo4psI8SNSY2X6qdbeAFBlyfu+ikY
Y2AgxQB4CqtqGQMkNYITTuCQSAoitIBmUhDwp2yKYUBgEgZebJsiGrdd4Km45dHgRbNIrQEtdoX84ctk
ZX0hIbr9eQGglPjm2wCK/TZHQxl/HhWAEwIsYEg/9JIVW8DlbdHjnRAzp8X/BeFWjIUY0B3VgaxjEpIC
Ah/UOdakO8I5xhnaTugFAZ1OyMWbY3CBRopaZIFqxHCWcca5E5aBJUsKQJsGId7gOpau/YnhLUoLNNAF
eRNqwQDA/a2IEgYNfBFB1VloUTW7gBrwRbL9hWGAUjTMOsgfACCgZFnZ5rmpiVl83XQWGZfH40oQAN1c
zoIzd8baKn0wBs53H7UEtAqrIYIFJpNlr8wFpxS4qjpT+XRKMfd3RhY0BG3sSqGXp0XjLHUA7Q2CsJBQ
Xw9POMa1J23eHxpZoN3cfyoFG3QZE9KQxVGpD846S0W4rUY4c5OFcn8R9MjS5f0RjrlK4BafxRmqXnAU
/9blAa8UB070IEgFlDFdHhqfp1R72uQ3d7tK/Pa3Rdhjs4QB8dtTCgWgJYgVUKZu2VueSQwAvqD1rTnV
04/vmAOGLBQOC4djCQOo1p/7CZCAKbgC+/yCvfJUiCXJY04EOre7+J0khVgIA+lMtxIAeG1C5CLLAJ0g
CBQYsC/C6yDujkWp7PWuassLYnm8AMB0HU8/HCxPGBS4kh0KogMoGCFZdES9J6LkAwXwQun6Q4MxfOGC
J0xJ9yb0vfBxDwJinFD1KncUK6phIVpcWhSZQy4V+FEFEOjCGLQwRtENoH7M8SBK8sczsWWvC38EZBfK
4EiZUXEl6FPf8zpwhb7sR/9VWghlKMVwrxSJ4QsEeKAKvWinCWKhghcUlSi1QMphia8szaPVB97Qgb5E
SGNo+MICToVDF5rEXBOSYSEDdsqhSed1gkiBBN7wQ6UosV/NPJYrrbYSRGKBiRoDgzD78jgnRO55Eujl
WNbYLxqcYZxSQGZ/uPCqramSOW0MWATOcAFnss15gnjBCSTQSaUwUlxmIMMYBlCnGXbQn8TUH//wZQYZ
MoCOSSmaE45GiCGc4A1joZj+ZjlLMnBhDIVCU6BIGkpWnkQFXGDp6C4oBpaG0qQoZcAQpQMyQ6TgBCdQ
J1JgyIUL0IMeBfgjAfxpEkAe9aiZA9QAnkqPQy6TOV7/MOpRk+pHAux0LAdL2CGSEIMToAAp10wkU30k
hQU0sTxZwChy3OUEeBkiAWUtaHLuuUK2sqQBDYxYx/JTTmkpogR5ZclB+WhMv0qBAZVsDhjQE6By0moR
iDWrBKvGAMeqRHdSvCRlNHpZRpRgAjHoQB6lQNR6etYkeXPZ6aLTgQNAq7SNSABqJaDFtGJhDGv10QIW
x0a5+oUIPYCWYSOhhCdMQLNS+N8Wpktd3r3WntSlLhgG+xoFyEoAMprEC0DghxjwFgAFoCo9EHddKaBX
vRBwLWWIcDAnRICjlkiAG1D7htW2168nsK1yQfGCKfgBtar9r19RwAFZOaEI+AWF/xL04IYD91fBJTrB
Ghzcg/CygwUUPrAEzorh8BzhAIoSQA9gpxgWgGAHbnBDDKhZYsr4gQMBCJMAAsBi0wgiCSUgwg5gPAEa
1zgpEyBQD4QkJrv6eBApSIAedEAEIbshqP7F8BuOgOMNLbkIeHjBkxfxAinr4Mxn3sFHSXzdHRxBAe2B
0YYOcAMPjfkRL0DAFIgAgz77mQh++KhQ8zMBIjwANNVxj6JxEAI735kSIhjCnilA6UpT+gh9rnCg38Bp
Tkvg058GKlCJcGm2iKY3B6hOEQJwABxsIDGPFkYKPlACEFgBKlB5gK53PZUlrAUIbGkLYQpjmNCcujdF
UAAVbjgwBDHHWjEpUAICPOCBDWwgLb4GdrDbQmzDcIAKIxiBFaxQgmY/+9yLEEEaEHAVdLv73fCOd7wD
AQA7AA==
__[ zend ]__
R0lGODlhcQBIANUAAA0NDgEDBgIFCS5EXhUdJwUPGgQKER0rOgABAgkZKiZpqxhDbQ0kOwobLQkZKSNg
nSBXjh1PghpGchQ2Vx1NfAoaKiJYjQoYJgsaKQECAzdQaS0/UTE1OQUPGAkaKh5ViiFclRpJdQocLSBZ
jh5UhhpIcw8qQxc+YwwgMwcVIQkaKQgXIwcZJTM6PwIEBRkaGjEyMv9mAP///8zMzMfHx7+/v6urq5KS
knNzc1VVVTw8PDc3NyYmJgcHBwMDAwAAACwAAAAAcQBIAAAG/8CZcEgsGo/IpHJ5/DGf0KiU+Ks6p9Kr
0KrFer9GbReM7IrJ6O95Zt262durUy5uD8/rtL58h7vlf3+AcHlsdoR7iU12eIhzbXVVfpOTgGOKiWNr
kpKUhZ99iJijl4d5kFSdXKmdb6OvsFOXsbS1oba4ubq7vL1DNjg6ODW+xVg3OTw/AisCOMbQSsA6AD8F
DAsjIwwv0d5DNcnLIhMU2uclPzbf3jwC2Ofx585MwTfssD8n8vwjKDpLcggo8OMZPkw8GPSTN6HKCxg5
hhHJ8WOCv4IHFeEwsDAeiQULJjBYUQXGM4oWtTU0mDGNjR/mOi48gcJKynMrW+oBcFNmP/8SJnri/JFD
J5kaL0T4XLqwYVGjWGy8MFCCqVWGRKFKsQGgAImrYIc+1bqEq9ewaEc0vEc2CdKzacOmY9vWxjoiMAx8
1Sajr9+/MhaE2Iu2hAAexPraJUbGxo3HkB/f/XKjCgBhwH5kOwcYsAoU5dKSMIBYSN8cOSZvxRGjtevX
OnREZDwFhogSE1AYqKIwXl8VBlKoUNHXgAEUJwhfJVGgtGkZsek+Afa6uvUY0bFUjEdhgnJtIUwwmLDA
b4cU3tM2pz2jb/YnN67Lr/4eSuWYPkmEGDyiL4MODITgm1+CkdBZgSh00xkMOkiHRHzWxSahDvNJyN4S
G6HV1wSfJcf/GWAMdObfCQv8IOILDUoj34QTrhgbS0zAgEJYfqGgQnp8yXACA8N9NkFfHQRX4wl+6cAD
DH2h6KBdz7jIYosRShjFdmD5B6CAH/JIHkgh9JUCeuXJAOBpPDTYF4MO4mDCAU5KmMMNxNDAWpSx2QdT
lTJwiNxeIhbYnwzDZeMlcTLAAAOc7qVIxAsVsrjkdRNCkeFVNd5ImIgqmCDgbyoICiihZd5gQ189KDoD
DTcYcN1lE+JAgxE2QCrlEzLi+V+Af+4XpnHCafpnoL8SWugNOwD5gqg4oMbDCtahkAGD9RUBIX2xjbUE
lUyJ6BcDJoQJ2AldfuppoCJe0IEOB5hw/wIEKFRQnQgesJrDhUTI+iJ8d2arbXGdjhDub6BxOm6nJvzV
wMEMSCDBAw+AwIAHr3kgQgdl5vAqEjXYq4NqSeAgAFjd2djjyL7qJ9JwDCQXnq/+mqBpCQXsWIEHKVPw
QcMgOOyAaw4k0EAKGCmhsbVKVLbCBFUtte+GC+ylH5df6cffCFIbKAMJJ5A4GARcdz2BA2CH3YAIDABA
7y8aO1g0NeOEttDSgLJMowwuh9D13VwDFTbYCZjQMEBIDO3FNACY0NFvwY3M72ZoLWCACRTgLfnXYTPw
AQgKmFAUDjjQ1SbHtfXWz29gggSSSHKHRcIKJkAAguR4R/C1CJFD8P+AAiykABoCQrQJoxc4FHC4uPLo
d+DUfxI4mF8O/AhYgXj/JdjNEUSgwAMY1ECDxjpcDEZl330IrDzapvyViCn7FUD5yXXdWcqXg3D7CdPC
NqHaWNSA7YDPIw+kkH1BTo3OA6QA9UUAIvhfCoZEAgj0ZUdhA03tRvAAEvhuDzpQCj8wJTcvgamAVgqY
DIQTpgIkcIQfFFOAHCgDBjTPdFvj2gPaRDQy4CBf5JMBr4bTQeINinTe+U0BCiYDBzSgL2BbAAtT4IA+
xbBrIODe2cDwghltEIVb8p8PPyWwPxlAAERsgAeQ6AAlklFEDtAUFKNIp9iADlXJQs2bbuA9Jdz/ED/i
69eHwgUsTvkFPVb7QQUk0BcPNLGIZWRhEsPFqzTazXUzbKOphBCrNnaujkUwS/jgFqItkqszCKDdGRFp
RlJa7VuDiaQliVBJ7t0LVl0JX/K0ZYAuCuyUfrEGBUaZREUmEgL/KiJoIqBKagljCPUz5pN+N4MaxLIj
4RmZNINSN/BUE2s86gsADBABEJSgbit7ZDjzFgKRgC1lEJgPdiw2g2Ta70lvOkINeACXhTzNdPgUDAX2
4zR+asN4MjiSAS73AX5WjZxPhMA9Q/ABdbYGVY1aJuiGsBFZxqUjhhFGDlwgP4aN4HWwC2nXLOjQiLJI
InbUy0Wt4pQa2IUH/ydQwARmKr8RiDSkJW3T/TCJMXpadKX/ZEBWKEqAFgDgBjCYgAJAetO75VSZjuKp
EuYpgKQBlR8lYqZdhsCBhTG1qSR96pMkREcvUNWq/CBPXOixBA5QIGdN5dpTsTPWBkk1CmftR0N+YACk
hUUEgJOGD0jwVa7l7LCvy2ld33TXKeQ1HiuxQQ5eUIUVoEBdS5kAAJ7gghM84G45Y9jtSgCCCHjAA2Pz
wGHqOqF4KuKxagkaJTmngxcIzycU+AH+iFADFCwVtCAgTwRQEIALQEAEIlBBB15QJtbKZrdpqAEMqhrb
GiIThx0pgHWJgAMJ/NawDxhADzj3DBioSwQGAIfADpyLUloIpCbbHQJPlsIAGCxhBxa4HcM6at865qCc
RFlsWXORA5MwIYMyWQADBBBfIdzgBRpAwVtvpzkjhCM1lHQMZKb4DY/xozsiEMAPeNDeJNDAMT/YwAkk
wICJcpgsL9mMgglyGRxMlAmiAoCN2zIFeoZ4xK6NLo+nYIMX3XjISNZKEAAAOw==
__[ child ]__
R0lGODlheABDAPcAAAD/AGtysgAAAB8fH////2pxsD8/P39/f2pwrr+/v2lvq9/f3+/v75CVxWpvrfX2
+mluqtrb6y8vL6KmziMkKJmeyl9fX6+vr1hdjZ+fn3R6tn2Du4+PjyYmKWhsp6uv02ltqGZmmWhspS0u
OrW42G9vb4aMwGZsqE9PT8fK4igpMVxiljU1P+zt9YKCq3p6oGhrozIzQy0tNM/Pz0VIaA8PDz09SuPk
8Ds+Vmdqomtri0lNcWZnnDY4TGFnn4mJtiMjJr7B3ZGRwWdpn05SekxMX5OUyFxcdWlpnGdpoJaWykBD
X3JylWxsn4+PwlRUaoyMv2ZonTAwPRsdKnJypVNYhJmZzHl+un9/stDS5pWVyJKSxY2PxTc3Q5CRx4WF
uHx8r25zq4KFv1hbiVZckJqcrFdci1VWfXZ7uHl6rHyAu1JWgicnLmNjgEVFVWFlmUtLa3N5toeKwmVr
pVJUZWZmjDU5WUVHZYmJvG10s4KCtjk5TF1jm3V1qD4/VlRUek9PcnB1sTo6R3+DvWpqlkxMZYaHuxQU
H0JHb32BtqyttFZYg+Xm6mxwq2RpoaGlyzU1Rl9hkjo8Udnb6sPE0FJVfXB2tVJSanJ1r5qdw4aGs29v
ogYHC25vkl1dik1PdHN3s2dsoTxAZGJikSgoLzMzP0VFX0lOesXGyjY2Og0OFmxyrpWYuGVsp1hYgmps
olZbjVRUdFZWWoGDuoSHtaCjt9PU4Ftbe21tdWhoh1ZWc1pcbFFTemdqgkZGY3l+qouLuklKXm1tlIuM
vYeKorCzx3Nzc2pqkDs/YkNFYPHx8WZplXh4okREWllZczM0T3FxmCEjN72+109PaNXW2l5fjqOksFZZ
hXBwnFBRdj9BWmZnfH6BnUhIYpaWmkhKZHBwl4qLwHp9tDEyQE5Obnd3nX1+rk1Rd31+tDg4SHZ4rS4x
TVxghLy9xUFBUaWoyDEzQo+TwlBSb8DD1+vr8mlvqkpNa7e60m1vpXV4mEFCWra2umhoiXt/o6qru25x
oyH5BAEAAAAALAAAAAB4AEMAAAj/AAEIHEiwoMGDCBMqXMiwocOHECNKnEixosWLGDNq3MjRopEraLx0
HEnSoBeRCI0YVDIogEsReuRwQchFjJKSOFOqCZAGwAsmRb7RWFLEho0BLAYoHUBBHhMdR4r6iYGjyp1r
YzBggPZDyIsXQj661OAkZ84fOlw4S9YjxtK3cJmOWDrnzwtDcVasOEFEW9u5PeKOoEGjx6dRZkcCRRp3
qQocO7TS2BGJipg8AbT6SMIDlEuXBRB8/rxiB5x/GHbEGNFDigogNlwA4KIy8USvTzq8pRBjyY4xkUSP
/gwBhnCXHniIGM78cwEPCkYryBF9hb4OHXBUwmP7oZAjMljo/x4giEYVH59BRG9eQMR6lwiG5DjefLQD
CKPbgxgtGgOFAWwA0x1DOrzVwRHiYPYZAvjVp0CDJpAQgAdJRPfLPWTUB5oCBUjnQYfNIbDHADIsM+BB
LhwRzFIdFAGGJcMVACJzBTgAYgUEELDNM+tMIUACC3CjoY38eUDfcCLwoIAPMajgzg8nCoTWeBTcUYcR
aGjI3owBRJCjBCgYUAIHDFxgR31cBqCAA0MO4cFoawzQgQ4n5qYUBUu0wkMjWvbpkgMEoCJABhIcMEAN
BxyAiJ8IsIkmDDmkqcAYMgxgwwtiXIHSSEI88RYOJyggQpp+MgdBJgQkIMCqrF5gQIYayv9I6mfTOcrc
KtgcodQIGATyxWw3aeRCUrtioOaRpQ6HQHReHsAqqzOkkix7MDRYnwhRoOGDahQAUYo9K1iyBUYu2DkA
Ec65NEEFDUzwgUsNbFCqjAFs8OWzqxIwxbQuyRtAPB9+psEG8cKXxH4L5kBEYAPgQI4mFukwXsMnDBdE
jhg/kPEDEWRBwrrvNtdAqvgKIMEMZyZrgpcaE3BDyy3n+EAL9ESgwWceIByAD2v4USkLbQyjBhq1MSRE
EUstUTFzGGM8gzWKJJCAl00T0MIEE9z8mZcSlFzCDKcku0HMTkudwD5lpK0IAxq38EAKtKQZBRJ6tKEb
BTsEEEZZCw3/uxS69eUY5gAlC3DIFHTgcgCZGKfQQAA4ZlD4AAxQEgEx+bxDQgoRtJDjDVlMADkBDCSQ
wQEG1FD4swYsgHELj38mAhZWyFEPDUqtEUUffY+3A+AiE7DA6qvXkMECrj9QwQQEyLK6AVIzMEP0OUp9
QAJWk0CAs8SvbsEBDDDQgnNR4BPHZzsMoIIj3CUkRKUUGKsl89x3PzkKBARxsQX2239AjgtQXf+8RwCX
QCAKOvsMYDahEDeob2layoKqBri6CxTjAwQwAAWJ5zoNbrBkFzgALJIwquacQAUDAERCmKCUvPXJXvX7
4KokUAIBlIEAdJAhvmrgOh3i6wAWOASy/4jDCwqMICGVwkGpUrC9klkgRxywHw0TRYBd+JBVBsjR6kqQ
qERZQAL8K9wMBLAo5iAAOicIzDEO0okHlqoCD4ihAAbQtASEyQIJ4EAGCMcq410Ah907QAakRqjCkalw
GagaxhaQAD6yygIGUIWprLWCAUihIEpQg1tiAJo+mSCOJVtABMJANYzNgxEMcKQAsqiv1aHAdW67AQEu
UDLK0TKUBMhEBZZXgQ9MgBULiOKzBqAqPjiHQ87JwQC6QBAjxKEKSlmBA4Y4HCaqMl9BCIAGTIC1gomC
A8JkVQ9XZ7UKuARHYXwWBwjQtVDeoDl8QMEtn5UBA6zhT/RRQAhC0P+FAUBJIFcIQGCAAIJZDQdHY9wh
AWLXHE4sQJXSW50ECBCyAFzsmgIgHTmzyRxkoCCcrKqnHegVoyZAwQUDoJNAWrLJZHmphvjKognqw4cf
PQt/kitcCRb6mRswoHAkqyUBtMYfUdRgnuKUAKyaE4ItpKEURSCIOpSyBPYMx17sLFkNeHrVBvTCAEjt
YAUJMFOXBJV1witcFv0lsArUwgJIFYAFZhCN+sRnCIE4gfr4BgBNKKUKw5kmczA4vJJlUUIHnWUJPCgA
/E2wcAwo4GdAGVMtlmyiDB2L8AzQzlaVYKmj8QACXaLXAVBhIC9Qihk+c580dUiWIMUiAcw5mg3/eCmu
/+usQiXrkgekU7YEUOtshyPLwuKLAftSFglnVACl1AG1SqmGjNyTH0dp4F6GpWg1CeCNkmGPeFmMwGgy
6DXLVpa22tReOwr3P3YMxwPzGQ0EQqAUJkB3AFD4AgyYq4DjjOynhXtiCkzwAQ1UQJa24AS+8BfcLRJA
vPBqML7+aNxn/e8DJmhAAzz3AB/hi3KUyA917TOEJnSBBQRJ7QCsIAb5JjAA2supd2XWNEbodlWJlPCM
ORqAkQF1lpDNkedyxADG3pQBoaCVtWL0BRbYgCC6WnFA1WQc5mhPjo8sXQYukEgG3HhV2NMxvnJUUR9X
tom4BBIHXPdbeqYA/zREsqsvBvAEKA/ADVZQQhhg8KbmaK/NxJOAAPG10xxhdJU5KmsAmFeydZK3ll8W
ruhI6iAesGEARyBIG5TiAivMwqAwfvQVWSk49lptNGZ+luvErEPXEfVRIYCDUlQqEBXzY8oawpGRZUi5
/OUIyz8iAGI/I2Y6ntWHO32zlhTAgxCAIRckKsgPlAI8DY1s1wM0wPUI8ICs/frHbDXrmYFNwYk+INxm
5AESTlopN2BSKTToZH3shW0LcKCL+B7k6wpsVgIAOovvHI0JGjwAMYUZBSVDwQEi3cf/3eDVDoKCFY4y
ANkQJBRKwQECqKmurKpTkVV7m6L7zYFrrrOiEf8GucdZVWjhcWBwqzKABTIQWWX7CQJNeIFuUFyQPCiF
FKB2iZdKlqN+hGGmE3hEItA9nKbN4OUGaB1vR0OCCKSABA3QwIYB/KzI3sAf1FA5t7NWKhCEoAlIK4IQ
DMIFSESzTxF47Kq2ylUGBd0lBNbAB8gm7GQ9QO754qqGsxCBIHyABB+oAMQ1BIMQbAIcSvmnQZiR8fwc
aRKAZ6UJCqAefuH9BhEgMHr7NDKYPitHi/e8S4bgbCYk5ckJ8dS5AlAjLikABpivbAtA0GfV+z4A1iR6
Fn7PHEfEglgsWHtCXFCpAdxhDvzJAX7+Xllp2Ir4/LKXjE9vc+yvYC5KsYH/8hXyg/HEYAcnKAAM9qtN
IKNVdEPCfn2YiO2MDtv3J6ABBf4jpzY85Az8xxSesBwRZnoxRwBM9yfXJ3+jEQFcd1MEAH++p39LwQJM
IHkM4QU7A35KoQI9YCwVkEqrMgBwFVkjBx8QwCWUJn/MswAXsADTczrYk4B9sgIotBQyQGsQoQYK8AaA
IAVwoQIPMAOLMwPcFgGFFyOd5xxxFiKq1y6IVwGPwDkRIIHJYoNLAQSF0AkWQQVIgAVa8ALEohTGoAwE
EDo06AG95xJroiGNgn0K8B6el383CASmYA4j4QKXQApvMRhVYAYYsAK0UmVK5obI9HsIIAILOC0+AH5A
/wAIYKAFOJEGf1AIEwMXMfAJi6AVxnJGiwgaS2hXHNceazgvDbIC/LcHhDAutuECFNcYu+EHgtgcvKcl
b6ghIJAEn6glIMADQ3ACOMB/zQAFUQIAaFEEXSAFMrAH8ACLHygdObCLtNeGDjIEBDgtCsB6rgAJ/JcO
wlCMBbEFVNAHUCAHAfAGZ5ANOMCBAzACRDAHfKYlEPBi+ZEDUXB9KzAGJ4AeJ2AGgCg/BZADowAHl6YU
UkAIkgiOCYEFIYAE6EBaRMCBQCAJGnJ7HCcCIZAELkEEVRCMTOEWsCgDQPAWgnAJfKWQCcGK4aAzi1CQ
u7IE8uMDCFAtzCE/ENBsZ74wDhSgAiAJiz75BBiIkg5hCIEAAUPAAwWAO0HIFEuwBDTAjnABBM0XhCtQ
CZ4QAnxyjmfwB92gAzrABC8glBXhBEiABJjgEj4gCQHokz7ZAUYxDbpQDomgAElwdl+gBJiQAw2JBWLJ
EUYACjcZAgjgA+cgBVLQBTLQAcQCBIJgA0fgBrdQBy9gcQcBBlQAhgLhBH2QBgnZlxvhBE3QBHf5Cg2p
BwSBBVTQPp65mgixBVDQmawZm7I5m7QplAEBADsA
