# Generated by default/object.tt
package Paws::SecurityHub::AwsElbLoadBalancerAccessLog;
  use Moose;
  has EmitInterval => (is => 'ro', isa => 'Int');
  has Enabled => (is => 'ro', isa => 'Bool');
  has S3BucketName => (is => 'ro', isa => 'Str');
  has S3BucketPrefix => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsElbLoadBalancerAccessLog

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsElbLoadBalancerAccessLog object:

  $service_obj->Method(Att1 => { EmitInterval => $value, ..., S3BucketPrefix => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsElbLoadBalancerAccessLog object:

  $result = $service_obj->Method(...);
  $result->Att1->EmitInterval

=head1 DESCRIPTION

Contains information about the access log configuration for the load
balancer.

=head1 ATTRIBUTES


=head2 EmitInterval => Int

The interval in minutes for publishing the access logs.

You can publish access logs either every 5 minutes or every 60 minutes.


=head2 Enabled => Bool

Indicates whether access logs are enabled for the load balancer.


=head2 S3BucketName => Str

The name of the S3 bucket where the access logs are stored.


=head2 S3BucketPrefix => Str

The logical hierarchy that was created for the S3 bucket.

If a prefix is not provided, the log is placed at the root level of the
bucket.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

