package t::Crypt::Perl::Ed25519::Math;

use Test::More;
use Test::FailWarnings;
use Test::Deep;

use Crypt::Perl::Ed25519::Math;

#----------------------------------------------------------------------

my @reduce_tests = (
    {
        in => [ 254, 229, 34, 65, 201, 64, 241, 213, 32, 163, 195, 81, 123, 234, 141, 189, 210, 236, 177, 64, 95, 199, 172, 37, 4, 41, 96, 123, 26, 57, 144, 253, 5, 255, 233, 205, 158, 45, 35, 191, 225, 100, 129, 89, 204, 181, 144, 225, 139, 87, 78, 220, 155, 126, 105, 238, 110, 30, 244, 141, 223, 44, 254, 241 ],
        out => [ 217, 154, 174, 181, 125, 49, 173, 237, 9, 219, 122, 129, 34, 223, 236, 24, 52, 69, 107, 107, 124, 24, 93, 190, 52, 34, 26, 26, 31, 32, 192, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ],
    },
    {
        in => [ 162, 210, 105, 105, 175, 216, 20, 137, 213, 119, 69, 23, 97, 139, 20, 52, 181, 132, 8, 165, 45, 21, 222, 69, 10, 93, 158, 43, 9, 80, 26, 51, 203, 216, 91, 166, 172, 125, 124, 98, 67, 74, 98, 160, 103, 130, 145, 105, 153, 243, 44, 12, 141, 4, 126, 83, 204, 170, 18, 146, 91, 91, 85, 9 ],
        out => [ 184, 33, 170, 205, 74, 59, 236, 200, 135, 174, 55, 139, 54, 214, 110, 206, 118, 166, 30, 64, 249, 59, 37, 26, 118, 154, 204, 130, 129, 243, 180, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ],
    },
);

my @modL_tests = (
    {
        in_r => [ (0) x 32 ],
        in_x => [ 16744, 34854, 80824, 74091, 101852, 93072, 125818, 137050, 155169, 180961, 194753, 173565, 225031, 287074, 218957, 237179, 279029, 324091, 320873, 326981, 314359, 363110, 391370, 436569, 351082, 420852, 531090, 501144, 496546, 492635, 519934, 543956, 581698, 466008, 451175, 465051, 442998, 436842, 383192, 342175, 388345, 396253, 355943, 294844, 295745, 328642, 281603, 270610, 233088, 243287, 239671, 219249, 183299, 146952, 162478, 155657, 107545, 62071, 50402, 42626, 21273, 6299, 1078, 0 ],
        out_r => [ 196, 140, 234, 0, 108, 120, 214, 136, 146, 99, 161, 80, 206, 244, 93, 244, 112, 27, 174, 166, 51, 227, 239, 53, 3, 231, 189, 160, 232, 207, 204, 3 ],
    },
);

plan tests => @reduce_tests + @modL_tests;

#----------------------------------------------------------------------

for my $idx (0 .. $#reduce_tests) {
    my $rt = $reduce_tests[$idx];

    Crypt::Perl::Ed25519::Math::reduce( my $reduce_out = [ @{ $rt->{'in'} } ] );

    cmp_deeply(
        $reduce_out,
        $rt->{'out'},
        sprintf( "reduce() - %d", 1 + $idx ),
    ) or diag explain "got: @$reduce_out\nwanted: @{$rt->{'out'}}";
}

for my $idx (0 .. $#modL_tests) {
    my $t = $modL_tests[$idx];

    my @r = @{ $t->{'in_r'} };
    my @x = @{ $t->{'in_x'} };

    Crypt::Perl::Ed25519::Math::modL(\@r, \@x);

    cmp_deeply(
        \@r,
        $t->{'out_r'},
        sprintf( "modL() - %d", 1 + $idx ),
    ) or diag explain "got: @r";
}

done_testing();
