# $Id: /mirror/coderepos/lang/perl/Google-Chart/branches/moose/lib/Google/Chart/Type/Bar.pm 66683 2008-07-24T05:52:58.814530Z daisuke  $

package Google::Chart::Type::Bar;
use Moose;
use Moose::Util::TypeConstraints;

with 'Google::Chart::Type::Simple';

enum 'Google::Chart::Type::Bar::Orientation' => qw(horizontal vertical);

has 'colored' => (
    is => 'rw',
    isa => 'Bool',
    required => 1,
    default => 0,
);

has 'orientation' => (
    is => 'rw',
    isa => 'Google::Chart::Type::Bar::Orientation',
    required => 1,
    default => 'vertical',
);

__PACKAGE__->meta->make_immutable;

no Moose;

sub parameter_value {
    my $self = shift;

    return sprintf( 'b%s%s', 
        $self->orientation eq 'vertical' ? 'v' : 'h',
        $self->colored                   ? 'g' : 's'
    );
}

1;

__END__

=head1 NAME

Google::Chart::Type::Bar - Google::Chart Bar Type

=head1 SYNOPSIS

  Google::Chart->new(
    type => {
      module => "Bar",
      orientation => "horizontal",
    }
  );

=head1 METHODS

=head2 parameter_value

=cut