/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.ResultSetStatistics;

public class RealHashTableStatistics
extends RealNoPutResultSetStatistics {
    public int hashtableSize;
    public int[] hashKeyColumns;
    public String isolationLevel;
    public String nextQualifiers;
    public FormatableProperties scanProperties;
    public ResultSetStatistics childResultSetStatistics;
    public ResultSetStatistics[] subqueryTrackingArray;

    public RealHashTableStatistics(int n, int n2, int n3, long l, long l2, long l3, long l4, int n4, int n5, int[] nArray, String string, Properties properties, double d, double d2, ResultSetStatistics[] resultSetStatisticsArray, ResultSetStatistics resultSetStatistics) {
        super(n, n2, n3, l, l2, l3, l4, n4, d, d2);
        this.hashtableSize = n5;
        this.hashKeyColumns = nArray;
        this.nextQualifiers = string;
        this.scanProperties = new FormatableProperties();
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                this.scanProperties.put(string2, properties.get(string2));
            }
        }
        this.subqueryTrackingArray = resultSetStatisticsArray;
        this.childResultSetStatistics = resultSetStatistics;
    }

    public String getStatementExecutionPlanText(int n) {
        String string;
        int n2;
        String string2 = "";
        this.initFormatInfo(n);
        if (this.subqueryTrackingArray != null) {
            boolean bl = false;
            for (n2 = 0; n2 < this.subqueryTrackingArray.length; ++n2) {
                if (this.subqueryTrackingArray[n2] == null) continue;
                if (!bl) {
                    string2 = this.indent + MessageService.getTextMessage("43X56.U") + ":\n";
                    bl = true;
                }
                string2 = string2 + this.subqueryTrackingArray[n2].getStatementExecutionPlanText(this.sourceDepth);
            }
        }
        this.initFormatInfo(n);
        if (this.hashKeyColumns.length == 1) {
            string = MessageService.getTextMessage("43X53.U") + " " + this.hashKeyColumns[0];
        } else {
            string = MessageService.getTextMessage("43X54.U") + " (" + this.hashKeyColumns[0];
            for (n2 = 1; n2 < this.hashKeyColumns.length; ++n2) {
                string = string + "," + this.hashKeyColumns[n2];
            }
            string = string + ")";
        }
        return this.indent + MessageService.getTextMessage("43X57.U") + " (" + this.resultSetNumber + "):" + "\n" + this.indent + MessageService.getTextMessage("43X03.U") + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X31.U") + " = " + this.hashtableSize + "\n" + this.indent + string + "\n" + this.indent + MessageService.getTextMessage("43X04.U") + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage("43X32.U") + " = " + this.rowsFiltered + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + (this.rowsSeen > 0 ? this.subIndent + MessageService.getTextMessage("43X33.U") + " = " + this.nextTime / (long)this.rowsSeen + "\n" : "") + "\n" + this.subIndent + MessageService.getTextMessage("43X37.U") + ":\n" + this.nextQualifiers + "\n" + this.indent + MessageService.getTextMessage("43X05.U") + ":\n" + this.childResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth);
    }

    public String getScanStatisticsText(String string, int n) {
        if (string == null) {
            return this.getStatementExecutionPlanText(n);
        }
        return null;
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    public String getNodeOn() {
        return "";
    }

    public String getNodeName() {
        return MessageService.getTextMessage("43X58.U");
    }
}

