=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Sd - Package for language Sindhi

=cut

package Locale::CLDR::Locales::Sd;
# This file auto generated from Data\common\main\sd.xml
#	on Wed 15 Jan 11:22:39 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.46.0');

use v5.12.0;
use mro 'c3';
use utf8;
use feature 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'افار',
 				'ab' => 'ابقازیان',
 				'ace' => 'اچائينيز',
 				'ada' => 'ادنگمي',
 				'ady' => 'اديگهي',
 				'af' => 'آفريڪي',
 				'agq' => 'اگهيم',
 				'ain' => 'آئينو',
 				'ak' => 'اڪان',
 				'ale' => 'اليوٽ',
 				'alt' => 'ڏکڻ التائي',
 				'am' => 'امهاري',
 				'an' => 'ارگني',
 				'ann' => 'اوبولو',
 				'anp' => 'انجيڪا',
 				'ar' => 'عربي',
 				'ar_001' => 'جديد معياري عربي',
 				'arn' => 'ماپوچي',
 				'arp' => 'اراپائو',
 				'ars' => 'نجدي عربي',
 				'as' => 'آسامي',
 				'asa' => 'اسو',
 				'ast' => 'اسٽورين',
 				'atj' => 'اٽيڪاميڪو',
 				'av' => 'اويرس',
 				'awa' => 'اواڌي',
 				'ay' => 'ایمارا',
 				'az' => 'آزربائيجاني',
 				'az@alt=short' => 'ازري',
 				'ba' => 'ڪينيڊا',
 				'ban' => 'بالينيس',
 				'bas' => 'باسا',
 				'be' => 'بيلاروسي',
 				'bem' => 'بيمبا',
 				'bez' => 'بينا',
 				'bg' => 'بلغاريائي',
 				'bgc' => 'ھريانوي',
 				'bho' => 'ڀوجپوري',
 				'bi' => 'بسلاما',
 				'bin' => 'بني',
 				'bla' => 'سڪسڪا',
 				'blo' => 'آنيائي',
 				'bm' => 'بمبارا',
 				'bn' => 'بنگلا',
 				'bo' => 'تبيتائي',
 				'br' => 'بريٽن',
 				'brx' => 'بودو',
 				'bs' => 'بوسنيائي',
 				'bug' => 'بگنيز',
 				'byn' => 'بلن',
 				'ca' => 'ڪيٽالان',
 				'cay' => 'ڪايوگا',
 				'ccp' => 'چمڪا',
 				'ce' => 'چیچن',
 				'ceb' => 'سبوانو',
 				'cgg' => 'چگا',
 				'ch' => 'چمورو',
 				'chk' => 'چڪيز',
 				'chm' => 'ماري',
 				'cho' => 'چوڪ تو',
 				'chp' => 'چائپائن',
 				'chr' => 'چروڪي',
 				'chy' => 'چايان',
 				'ckb' => 'مرڪزي ڪردش',
 				'clc' => 'چلڪوٽن',
 				'co' => 'ڪارسيڪائي',
 				'crg' => 'ميچيف',
 				'crj' => 'ڏکڻ اڀرندو ڪري',
 				'crk' => 'پلينز ڪري',
 				'crl' => 'اترين اوڀر ڪري',
 				'crm' => 'موس ڪري',
 				'crr' => 'ڪيرولينا الگانڪويئن',
 				'crs' => 'سيسلوا ڪريئول فرانسي',
 				'cs' => 'چيڪ',
 				'csw' => 'سوامپي ڪري',
 				'cu' => 'چرچ سلاوی',
 				'cv' => 'چو واش',
 				'cy' => 'ويلش',
 				'da' => 'ڊينش',
 				'dak' => 'ڊڪوٽا',
 				'dar' => 'ڊارگوا',
 				'dav' => 'تائيتا',
 				'de' => 'جرمن',
 				'de_AT' => 'آسٽريائي جرمن',
 				'de_CH' => 'سوئس هائي جرمن',
 				'dgr' => 'داگرب',
 				'dje' => 'زارما',
 				'doi' => 'ڊوگري',
 				'dsb' => 'لوئر سوربين',
 				'dua' => 'ڊيولا',
 				'dv' => 'دويهي',
 				'dyo' => 'جولا فوني',
 				'dz' => 'زونخا',
 				'dzg' => 'دزاگا',
 				'ebu' => 'ايمبيو',
 				'ee' => 'ايو',
 				'efi' => 'ايفڪ',
 				'eka' => 'ايڪاجڪ',
 				'el' => 'يوناني',
 				'en' => 'انگريزي',
 				'en_AU' => 'آسٽريليائي انگريزي',
 				'en_CA' => 'ڪينيڊيائي انگريزي',
 				'en_GB' => 'برطانوي انگريزي',
 				'en_US' => 'آمريڪي انگريزي',
 				'en_US@alt=short' => 'انگريزي (آمريڪا)',
 				'eo' => 'ايسپرانٽو',
 				'es' => 'هسپانوي',
 				'es_419' => 'لاطيني آمريڪي اسپينش',
 				'es_ES' => 'يورپي اسپيني',
 				'es_MX' => 'ميڪسيڪين اسپيني',
 				'et' => 'ايستونائي',
 				'eu' => 'باسق',
 				'ewo' => 'اوانڊو',
 				'fa' => 'فارسي',
 				'fa_AF' => 'دري',
 				'ff' => 'فلاهه',
 				'fi' => 'فنش',
 				'fil' => 'فلپائني',
 				'fj' => 'فجي',
 				'fo' => 'فيروايس',
 				'fon' => 'فون',
 				'fr' => 'فرانسيسي',
 				'fr_CA' => 'ڪينيڊيائي فرانسيسي',
 				'fr_CH' => 'سوئس فرانسيسي',
 				'frc' => 'ڪيجن فرانسيسي',
 				'frr' => 'اترين فريسين',
 				'fur' => 'فرائي لئين',
 				'fy' => 'مغربي فريشن',
 				'ga' => 'آئرش',
 				'gaa' => 'گا',
 				'gd' => 'اسڪاٽش گيلڪ',
 				'gez' => 'جيز',
 				'gil' => 'گلبرٽيز',
 				'gl' => 'گليشئين',
 				'gn' => 'گواراني',
 				'gor' => 'گورنٽلو',
 				'gsw' => 'سوئس جرمن',
 				'gu' => 'گجراتي',
 				'guz' => 'گشي',
 				'gv' => 'مينڪس',
 				'gwi' => 'گوچن',
 				'ha' => 'هوسا',
 				'hai' => 'ھائيڊا',
 				'haw' => 'هوائي',
 				'hax' => 'ڏاکڻي ھائڊا',
 				'he' => 'عبراني',
 				'hi' => 'هندي',
 				'hil' => 'هلي گيانان',
 				'hmn' => 'مونگ',
 				'hr' => 'ڪروشيائي',
 				'hsb' => 'اپر سربيائي',
 				'ht' => 'هيٽي ڪرولي',
 				'hu' => 'هنگري',
 				'hup' => 'هوپا',
 				'hur' => 'ھاڪملم',
 				'hy' => 'ارماني',
 				'hz' => 'هريرو',
 				'ia' => 'انٽرلنگئا',
 				'iba' => 'ايبن',
 				'ibb' => 'ابيبيو',
 				'id' => 'انڊونيشي',
 				'ie' => 'انٽرلنگئي',
 				'ig' => 'اگبو',
 				'ii' => 'سچوان يي',
 				'ikt' => 'مغربي ڪينيڊين انوڪٽيٽ',
 				'ilo' => 'الوڪو',
 				'inh' => 'انگش',
 				'io' => 'ادو',
 				'is' => 'آئيس لينڊڪ',
 				'it' => 'اطالوي',
 				'iu' => 'انو ڪتوت',
 				'ja' => 'جاپاني',
 				'jbo' => 'لوجبين',
 				'jgo' => 'نغومبا',
 				'jmc' => 'ميڪم',
 				'jv' => 'جاونيز',
 				'ka' => 'جارجيائي',
 				'kab' => 'ڪبائل',
 				'kac' => 'ڪچن',
 				'kaj' => 'پوڪيپسي',
 				'kam' => 'ڪئمبا',
 				'kbd' => 'ڪبارڊيئن',
 				'kcg' => 'تياپ',
 				'kde' => 'مڪوندي',
 				'kea' => 'ڪيبيو ويرڊيانو',
 				'kfo' => 'ڪورو',
 				'kgp' => 'ڪئينگينگ',
 				'kha' => 'خاسي',
 				'khq' => 'ڪيورا چني',
 				'ki' => 'اڪويو',
 				'kj' => 'ڪنياما',
 				'kk' => 'قازق',
 				'kkj' => 'ڪڪو',
 				'kl' => 'ڪالا ليسٽ',
 				'kln' => 'ڪيلين جن',
 				'km' => 'خمر',
 				'kmb' => 'ڪنمبونڊو',
 				'kn' => 'ڪناڊا',
 				'ko' => 'ڪوريائي',
 				'kok' => 'ڪونڪي',
 				'kpe' => 'ڪپيل',
 				'kr' => 'ڪنوري',
 				'krc' => 'ڪراچي بالڪر',
 				'krl' => 'ڪريلئين',
 				'kru' => 'ڪورخ',
 				'ks' => 'ڪشميري',
 				'ksb' => 'شمبالا',
 				'ksf' => 'بافيا',
 				'ksh' => 'ڪلونئين',
 				'ku' => 'ڪردي',
 				'kum' => 'ڪومڪ',
 				'kv' => 'ڪومي',
 				'kw' => 'ڪورنش',
 				'kwk' => 'ڪئاڪ ولا',
 				'kxv' => 'ڪووي',
 				'ky' => 'ڪرغيز',
 				'la' => 'لاطيني',
 				'lad' => 'لڊينو',
 				'lag' => 'لانگي',
 				'lb' => 'لگزمبرگ',
 				'lez' => 'ليزگهين',
 				'lg' => 'گاندا',
 				'li' => 'لمبرگش',
 				'lij' => 'لگيوريئن',
 				'lil' => 'ليلوئيٽ',
 				'lkt' => 'لڪوٽا',
 				'lmo' => 'لامبارڊ',
 				'ln' => 'لنگالا',
 				'lo' => 'لائو',
 				'lou' => 'لوئيزيانا ڪريئول',
 				'loz' => 'لوزي',
 				'lrc' => 'اتر لوري',
 				'lsm' => 'ساميا',
 				'lt' => 'ليٿونيائي',
 				'lu' => 'لوبا-ڪتانگا',
 				'lua' => 'لوبا-لولوا',
 				'lun' => 'لنڊا',
 				'luo' => 'لو',
 				'lus' => 'ميزو',
 				'luy' => 'لوهيا',
 				'lv' => 'لاتوين',
 				'mad' => 'مدورائي',
 				'mag' => 'مگاهي',
 				'mai' => 'ميٿلي',
 				'mak' => 'مڪاسر',
 				'mas' => 'مسائي',
 				'mdf' => 'موڪشا',
 				'men' => 'مينڊي',
 				'mer' => 'ميرو',
 				'mfe' => 'موریسیین',
 				'mg' => 'ملاگاسي',
 				'mgh' => 'مخووا ميتو',
 				'mgo' => 'ميتا',
 				'mh' => 'مارشليز',
 				'mi' => 'مائوري',
 				'mic' => 'ميڪ مڪ',
 				'min' => 'مناڪابوا',
 				'mk' => 'ميسي ڊونيائي',
 				'ml' => 'مليالم',
 				'mn' => 'منگولي',
 				'mni' => 'ماني پوري',
 				'moe' => 'انو آئيمن',
 				'moh' => 'موهاڪ',
 				'mos' => 'موسي',
 				'mr' => 'مراٺي',
 				'ms' => 'ملي',
 				'mt' => 'مالٽي',
 				'mua' => 'من دانگ',
 				'mul' => 'هڪ کان وڌيڪ ٻوليون',
 				'mus' => 'ڪريڪ',
 				'mwl' => 'مرانڊيز',
 				'my' => 'برمي',
 				'myv' => 'ايريزيا',
 				'mzn' => 'مزيندراني',
 				'na' => 'نائو',
 				'nap' => 'نيپولٽن',
 				'naq' => 'ناما',
 				'nb' => 'نارويائي بوڪمال',
 				'nd' => 'اتر دبيلي',
 				'nds' => 'لو جرمن',
 				'ne' => 'نيپالي',
 				'new' => 'نيواري',
 				'ng' => 'ڊونگا',
 				'nia' => 'نياس',
 				'niu' => 'نووي',
 				'nl' => 'ڊچ',
 				'nl_BE' => 'فليمش',
 				'nmg' => 'ڪويسيو',
 				'nn' => 'نارويائي نيوناسڪ',
 				'nnh' => 'نغيمبون',
 				'no' => 'نارويجيائي',
 				'nog' => 'نوگائي',
 				'nqo' => 'نڪو',
 				'nr' => 'ڏکڻ دبيلي',
 				'nso' => 'اتر سوٿو',
 				'nus' => 'نيور',
 				'nv' => 'نواجو',
 				'ny' => 'نيانجا',
 				'nyn' => 'نايانڪول',
 				'oc' => 'آڪسيٽن',
 				'ojb' => 'اتر الھندي اوجيبوا',
 				'ojc' => 'وچولي اوجيبوي',
 				'ojs' => 'اوجي ڪري',
 				'ojw' => 'مغربي اوجيبو',
 				'oka' => 'اوڪاناگن',
 				'om' => 'اورومو',
 				'or' => 'اوڊيا',
 				'os' => 'اوسيٽڪ',
 				'pa' => 'پنجابي',
 				'pag' => 'پانگا سينان',
 				'pam' => 'پيم پينگا',
 				'pap' => 'پاپي امينٽو',
 				'pau' => 'پلون',
 				'pcm' => 'نائيجرين پجن',
 				'pis' => 'پائجن',
 				'pl' => 'پولش',
 				'pqm' => 'ماليسيٽ پاسماڪئوڊي',
 				'prg' => 'پرشن',
 				'ps' => 'پشتو',
 				'pt' => 'پورٽگليز',
 				'pt_BR' => 'برازيلي پرتگالي',
 				'pt_PT' => 'يورپي پرتگالي',
 				'qu' => 'ڪيچوا',
 				'quc' => 'ڪچي',
 				'raj' => 'راجستاني',
 				'rap' => 'ريپنوئي',
 				'rar' => 'ريرو ٽينگو',
 				'rhg' => 'روھنگيا',
 				'rm' => 'رومانش',
 				'rn' => 'رونڊي',
 				'ro' => 'روماني',
 				'ro_MD' => 'مالديوي',
 				'rof' => 'رومبو',
 				'ru' => 'روسي',
 				'rup' => 'ارومينين',
 				'rw' => 'ڪنيار وانڊا',
 				'rwk' => 'روا',
 				'sa' => 'سنسڪرت',
 				'sad' => 'سنداوي',
 				'sah' => 'ساخا',
 				'saq' => 'سيمبورو',
 				'sat' => 'سنتالي',
 				'sba' => 'نغمبي',
 				'sbp' => 'سانگوو',
 				'sc' => 'سارڊيني',
 				'scn' => 'سسلي',
 				'sco' => 'اسڪاٽس',
 				'sd' => 'سنڌي',
 				'se' => 'اتر سامي',
 				'seh' => 'سينا',
 				'ses' => 'ڪيورابورو سيني',
 				'sg' => 'سانگو',
 				'shi' => 'تيچل هاتي',
 				'shn' => 'شان',
 				'si' => 'سنهالا',
 				'sk' => 'سلواڪي',
 				'sl' => 'سلوويني',
 				'slh' => 'ڏاکڻي لشوٽسيڊ',
 				'sm' => 'سموئا',
 				'sma' => 'ڏکڻ سامي',
 				'smj' => 'لولي سامي',
 				'smn' => 'اناري سامي',
 				'sms' => 'اسڪاٽ سامي',
 				'sn' => 'شونا',
 				'snk' => 'سونينڪي',
 				'so' => 'سومالي',
 				'sq' => 'الباني',
 				'sr' => 'سربيائي',
 				'srn' => 'سرانن تانگو',
 				'ss' => 'سواتي',
 				'ssy' => 'سهو',
 				'st' => 'ڏکڻ سوٿي',
 				'str' => 'اسٽريٽ سليش',
 				'su' => 'سوڊاني',
 				'suk' => 'سڪوما',
 				'sv' => 'سويڊش',
 				'sw' => 'سواحيلي',
 				'sw_CD' => 'ڪونگو سواحيلي',
 				'swb' => 'ڪمورين',
 				'syr' => 'شامي',
 				'szl' => 'سليسيئن',
 				'ta' => 'تامل',
 				'tce' => 'ڏاکڻي ٽچون',
 				'te' => 'تلگو',
 				'tem' => 'تمني',
 				'teo' => 'تيسو',
 				'tet' => 'تيتم',
 				'tg' => 'تاجڪ',
 				'tgx' => 'ٽئگِش',
 				'th' => 'ٿائي',
 				'tht' => 'ٽهلٽن',
 				'ti' => 'تگرينيائي',
 				'tig' => 'تگري',
 				'tk' => 'ترڪمين',
 				'tlh' => 'ڪلون',
 				'tli' => 'ٽِلنگٽ',
 				'tn' => 'تسوانا',
 				'to' => 'تونگن',
 				'tok' => 'توڪي پونا',
 				'tpi' => 'تاڪ پسن',
 				'tr' => 'ترڪي',
 				'trv' => 'تاروڪو',
 				'ts' => 'سونگا',
 				'tt' => 'تاتار',
 				'ttm' => 'اترين ٽچون',
 				'tum' => 'تمبوڪا',
 				'tvl' => 'توالو',
 				'twq' => 'تساوڪي',
 				'ty' => 'تاهيتي',
 				'tyv' => 'تووينيائي',
 				'tzm' => 'وچ اٽلس تمازائيٽ',
 				'udm' => 'ادمرت',
 				'ug' => 'يوغور',
 				'uk' => 'يوڪراني',
 				'umb' => 'اومبنڊو',
 				'und' => 'اڻڄاتل ٻولي',
 				'ur' => 'اردو',
 				'uz' => 'ازبڪ',
 				'vai' => 'يا',
 				've' => 'وينڊا',
 				'vec' => 'ونيشن',
 				'vi' => 'ويتنامي',
 				'vmw' => 'مکووا',
 				'vo' => 'والپڪ',
 				'vun' => 'ونجو',
 				'wa' => 'ولون',
 				'wae' => 'والسر',
 				'wal' => 'وولايٽا',
 				'war' => 'واري',
 				'wo' => 'وولوف',
 				'wuu' => 'وو چيني',
 				'xal' => 'ڪيلمڪ',
 				'xh' => 'زھوسا',
 				'xnr' => 'ڪينگري',
 				'xog' => 'سوگا',
 				'yav' => 'يانگ بين',
 				'ybb' => 'ييمبا',
 				'yi' => 'يدش',
 				'yo' => 'يوروبا',
 				'yrl' => 'نھين گاٽو',
 				'yue' => 'ڪينٽونيز',
 				'yue@alt=menu' => 'چيني، ڪينٽونيز',
 				'za' => 'جوئنگ',
 				'zgh' => 'معياري مراڪشي تامازائيٽ',
 				'zh' => 'چيني',
 				'zh@alt=menu' => 'چيني، مندارن',
 				'zh_Hans@alt=long' => 'سادي مندارن چيني',
 				'zh_Hant' => 'روايتي چيني',
 				'zh_Hant@alt=long' => 'رواجي مندارن چيني',
 				'zu' => 'زولو',
 				'zun' => 'زوني',
 				'zxx' => 'ڪوئي ٻولي جو مواد ڪونهي',
 				'zza' => 'زازا',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'ايڊلام',
 			'Arab' => 'عربي',
 			'Aran' => 'نستعلیق',
 			'Armn' => 'عرماني',
 			'Beng' => 'بنگلا',
 			'Bopo' => 'بوپوموفو',
 			'Brai' => 'بريل',
 			'Cakm' => 'چڪما',
 			'Cans' => 'يونيفائيڊ ڪينيڊيئن ابارجيني سليبڪس',
 			'Cher' => 'چيروڪي',
 			'Cyrl' => 'سيريلي',
 			'Deva' => 'ديوناگري',
 			'Ethi' => 'ايٿوپيائي',
 			'Geor' => 'جيورجيائي',
 			'Grek' => 'يوناني',
 			'Gujr' => 'گجراتي',
 			'Guru' => 'گرمکي',
 			'Hanb' => 'بوپوموفو سان هين',
 			'Hang' => 'هنگول',
 			'Hani' => 'هين',
 			'Hans' => 'سادي',
 			'Hans@alt=stand-alone' => 'سادي هين',
 			'Hant' => 'روايتي',
 			'Hant@alt=stand-alone' => 'روايتي هين',
 			'Hebr' => 'عبراني',
 			'Hira' => 'هراگنا',
 			'Hrkt' => 'جاپاني لکت',
 			'Ital' => 'قديم اطالوي',
 			'Jamo' => 'جامو',
 			'Java' => 'جاوانيز',
 			'Jpan' => 'جاپاني',
 			'Kana' => 'ڪٽاڪانا',
 			'Khmr' => 'خمر',
 			'Knda' => 'ڪناڊا',
 			'Kore' => 'ڪوريائي',
 			'Laoo' => 'لائو',
 			'Latn' => 'لاطيني',
 			'Mlym' => 'ملايالم',
 			'Mong' => 'منگولي',
 			'Mtei' => 'ميئيٽي مائيڪ',
 			'Mult' => 'ملتاني',
 			'Mymr' => 'ميانمر',
 			'Nkoo' => 'نڪو',
 			'Olck' => 'اول چڪي',
 			'Orya' => 'اوڊيا',
 			'Rohg' => 'ھنيفي',
 			'Sarb' => 'قديم ڏاکڻي عربي',
 			'Sinh' => 'سنهالا',
 			'Sund' => 'سوڊاني',
 			'Syrc' => 'شامي',
 			'Taml' => 'تامل',
 			'Telu' => 'تلگو',
 			'Tfng' => 'ٽفيناگ',
 			'Thaa' => 'ٿانا',
 			'Thai' => 'ٿائي',
 			'Tibt' => 'تبيتن',
 			'Vaii' => 'وائي',
 			'Xpeo' => 'قديم فارسي',
 			'Yiii' => 'يي',
 			'Zmth' => 'رياضي جون نشانيون',
 			'Zsye' => 'ايموجي',
 			'Zsym' => 'نشانيون',
 			'Zxxx' => 'اڻ لکيل',
 			'Zyyy' => 'ڪامن',
 			'Zzzz' => 'اڻڄاتل لکت',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'دنيا',
 			'002' => 'آفريڪا',
 			'003' => 'اتر آمريڪا',
 			'005' => 'ڏکڻ آمريڪا',
 			'009' => 'اوشنيا',
 			'011' => 'اولهه آفريقا',
 			'013' => 'وچ آمريڪا',
 			'014' => 'اوڀر آفريڪا',
 			'015' => 'اتر آفريڪا',
 			'017' => 'وچ آفريڪا',
 			'018' => 'ڏاکڻي آمريڪا',
 			'019' => 'آمريڪا',
 			'021' => 'اترين آمريڪا',
 			'029' => 'ڪيريبين',
 			'030' => 'اوڀر ايشيا',
 			'034' => 'ڏکڻ ايشيا',
 			'035' => 'ڏکڻ اوڀر ايشيا',
 			'039' => 'ڏکڻ يورپ',
 			'053' => 'آسٽریلیشیا',
 			'054' => 'میلانیشیا',
 			'057' => 'مائڪرونيشائي خطو',
 			'061' => 'پولینیشیا',
 			'142' => 'ايشيا',
 			'143' => 'وچ ايشيا',
 			'145' => 'اولهه ايشيا',
 			'150' => 'يورپ',
 			'151' => 'اوڀر يورپ',
 			'154' => 'اترين يورپ',
 			'155' => 'اولهه يورپ',
 			'202' => 'سب-سهارا آفريڪا',
 			'419' => 'لاطيني آمريڪا',
 			'AC' => 'طلوع ٻيٽ',
 			'AD' => 'اندورا',
 			'AE' => 'متحده عرب امارات',
 			'AF' => 'افغانستان',
 			'AG' => 'انٽيگا ۽ باربد',
 			'AI' => 'انگويلا',
 			'AL' => 'البانيا',
 			'AM' => 'ارمینیا',
 			'AO' => 'انگولا',
 			'AQ' => 'انٽارڪٽيڪا',
 			'AR' => 'ارجنٽينا',
 			'AS' => 'آمريڪي ساموا',
 			'AT' => 'آسٽريا',
 			'AU' => 'آسٽريليا',
 			'AW' => 'عروبا',
 			'AX' => 'الند ٻيٽ',
 			'AZ' => 'آذربائيجان',
 			'BA' => 'بوسنيا ۽ هرزوگووينا',
 			'BB' => 'باربڊوس',
 			'BD' => 'بنگلاديش',
 			'BE' => 'بيلجيم',
 			'BF' => 'برڪينا فاسو',
 			'BG' => 'بلغاريا',
 			'BH' => 'بحرين',
 			'BI' => 'برونڊي',
 			'BJ' => 'بينن',
 			'BL' => 'سینٽ برٿلیمی',
 			'BM' => 'برمودا',
 			'BN' => 'برونائي',
 			'BO' => 'بوليويا',
 			'BQ' => 'ڪيريبين نيدرلينڊ',
 			'BR' => 'برازيل',
 			'BS' => 'باهاماس',
 			'BT' => 'ڀوٽان',
 			'BV' => 'بووٽ ٻيٽ',
 			'BW' => 'بوٽسوانا',
 			'BY' => 'بیلارس',
 			'BZ' => 'بيليز',
 			'CA' => 'ڪينيڊا',
 			'CC' => 'ڪوڪوس ٻيٽ',
 			'CD' => 'ڪانگو -ڪنشاسا',
 			'CD@alt=variant' => 'ڪانگو',
 			'CF' => 'وچ آفريقي جمهوريه',
 			'CG' => 'ڪانگو - برازاویل',
 			'CG@alt=variant' => 'ڪانگو (جمهوري)',
 			'CH' => 'سوئزرلينڊ',
 			'CI' => 'ڪوٽي ويرا',
 			'CI@alt=variant' => 'آئيوري ڪوسٽ',
 			'CK' => 'ڪوڪ ٻيٽ',
 			'CL' => 'چلي',
 			'CM' => 'ڪيمرون',
 			'CN' => 'چين',
 			'CO' => 'ڪولمبيا',
 			'CP' => 'ڪلپرٽن ٻيٽ',
 			'CR' => 'ڪوسٽا ريڪا',
 			'CU' => 'ڪيوبا',
 			'CV' => 'ڪيپ وردي',
 			'CW' => 'ڪيوراسائو',
 			'CX' => 'ڪرسمس ٻيٽ',
 			'CY' => 'سائپرس',
 			'CZ' => 'چيڪيا',
 			'CZ@alt=variant' => 'چيڪ جهموريہ',
 			'DE' => 'جرمني',
 			'DG' => 'ڊئيگو گارسيا',
 			'DJ' => 'ڊجبيوتي',
 			'DK' => 'ڊينمارڪ',
 			'DM' => 'ڊومينيڪا',
 			'DO' => 'ڊومينيڪن جمهوريه',
 			'DZ' => 'الجيريا',
 			'EA' => 'سیوٽا ۽ میلیلا',
 			'EC' => 'ايڪواڊور',
 			'EE' => 'ايسٽونيا',
 			'EG' => 'مصر',
 			'EH' => 'اولهه صحارا',
 			'ER' => 'ايريٽيريا',
 			'ES' => 'اسپين',
 			'ET' => 'ايٿوپيا',
 			'EU' => 'يورپين يونين',
 			'EZ' => 'يورو زون',
 			'FI' => 'فن لينڊ',
 			'FJ' => 'فجي',
 			'FK' => 'فاڪ لينڊ ٻيٽ',
 			'FK@alt=variant' => 'فاڪ لينڊ ٻيٽ (اسلس مالويناس)',
 			'FM' => 'مائڪرونيشيا',
 			'FO' => 'فارو ٻيٽ',
 			'FR' => 'فرانس',
 			'GA' => 'گبون',
 			'GB' => 'برطانيہ',
 			'GB@alt=short' => 'برطانيه',
 			'GD' => 'گريناڊا',
 			'GE' => 'جارجيا',
 			'GF' => 'فرانسيسي گيانا',
 			'GG' => 'گورنسي',
 			'GH' => 'گهانا',
 			'GI' => 'جبرالٽر',
 			'GL' => 'گرين لينڊ',
 			'GM' => 'گيمبيا',
 			'GN' => 'گني',
 			'GP' => 'گواڊیلوپ',
 			'GQ' => 'ايڪوٽوريل گائينا',
 			'GR' => 'يونان',
 			'GS' => 'ڏکڻ جارجيا ۽ ڏکڻ سينڊوچ ٻيٽ',
 			'GT' => 'گوئٽي مالا',
 			'GU' => 'گوام',
 			'GW' => 'گني بسائو',
 			'GY' => 'گيانا',
 			'HK' => 'هانگ ڪانگ SAR',
 			'HK@alt=short' => 'هانگ ڪانگ',
 			'HM' => 'هرڊ ۽ مڪڊونلڊ ٻيٽ',
 			'HN' => 'هنڊورس',
 			'HR' => 'ڪروئيشيا',
 			'HT' => 'هيٽي',
 			'HU' => 'هنگري',
 			'IC' => 'ڪينري ٻيٽ',
 			'ID' => 'انڊونيشيا',
 			'IE' => 'آئرلينڊ',
 			'IL' => 'اسرائيل',
 			'IM' => 'انسانن جو ٻيٽ',
 			'IN' => 'ڀارت',
 			'IO' => 'برطانوي هندي سمنڊ خطو',
 			'IQ' => 'عراق',
 			'IR' => 'ايران',
 			'IS' => 'آئس لينڊ',
 			'IT' => 'اٽلي',
 			'JE' => 'جرسي',
 			'JM' => 'جميڪا',
 			'JO' => 'اردن',
 			'JP' => 'جاپان',
 			'KE' => 'ڪينيا',
 			'KG' => 'ڪرغستان',
 			'KH' => 'ڪمبوڊيا',
 			'KI' => 'ڪرباتي',
 			'KM' => 'ڪوموروس',
 			'KN' => 'سينٽ ڪٽس و نيوس',
 			'KP' => 'اتر ڪوريا',
 			'KR' => 'ڏکڻ ڪوريا',
 			'KW' => 'ڪويت',
 			'KY' => 'ڪي مين ٻيٽ',
 			'KZ' => 'قازقستان',
 			'LA' => 'لائوس',
 			'LB' => 'لبنان',
 			'LC' => 'سينٽ لوسيا',
 			'LI' => 'لچي ٽينسٽين',
 			'LK' => 'سري لنڪا',
 			'LR' => 'لائبیریا',
 			'LS' => 'ليسوٿو',
 			'LT' => 'لٿونيا',
 			'LU' => 'لگزمبرگ',
 			'LV' => 'لاتويا',
 			'LY' => 'لبيا',
 			'MA' => 'مراڪش',
 			'MC' => 'موناڪو',
 			'MD' => 'مالدووا',
 			'ME' => 'مونٽي نيگرو',
 			'MF' => 'سينٽ مارٽن',
 			'MG' => 'مدگاسڪر',
 			'MH' => 'مارشل ٻيٽ',
 			'MK' => 'اتر مقدونيا',
 			'ML' => 'مالي',
 			'MM' => 'ميانمار (برما)',
 			'MN' => 'منگوليا',
 			'MO' => 'مڪائو SAR چين',
 			'MO@alt=short' => 'مڪائو',
 			'MP' => 'اتريان ماريانا ٻيٽ',
 			'MQ' => 'مارتينڪ',
 			'MR' => 'موريتانيا',
 			'MS' => 'مونٽسراٽ',
 			'MT' => 'مالٽا',
 			'MU' => 'موريشس',
 			'MV' => 'مالديپ',
 			'MW' => 'مالاوي',
 			'MX' => 'ميڪسيڪو',
 			'MY' => 'ملائيشيا',
 			'MZ' => 'موزمبیق',
 			'NA' => 'نيميبيا',
 			'NC' => 'نیو ڪالیڊونیا',
 			'NE' => 'نائيجر',
 			'NF' => 'نورفوڪ ٻيٽ',
 			'NG' => 'نائيجيريا',
 			'NI' => 'نڪراگوا',
 			'NL' => 'نيدرلينڊ',
 			'NO' => 'ناروي',
 			'NP' => 'نيپال',
 			'NR' => 'نائورو',
 			'NU' => 'نووي',
 			'NZ' => 'نيو زيلينڊ',
 			'OM' => 'عمان',
 			'PA' => 'پناما',
 			'PE' => 'پيرو',
 			'PF' => 'فرانسيسي پولينيشيا',
 			'PG' => 'پاپوا نیو گني',
 			'PH' => 'فلپائن',
 			'PK' => 'پاڪستان',
 			'PL' => 'پولينڊ',
 			'PM' => 'سینٽ پیئر و میڪوئیلون',
 			'PN' => 'پٽڪئرن ٻيٽ',
 			'PR' => 'پيوئرٽو ريڪو',
 			'PS' => 'فلسطيني علائقا',
 			'PS@alt=short' => 'فلسطين',
 			'PT' => 'پرتگال',
 			'PW' => 'پلائو',
 			'PY' => 'پيراگوءِ',
 			'QA' => 'قطر',
 			'QO' => 'بيروني سامونڊي',
 			'RE' => 'ري يونين',
 			'RO' => 'رومانيا',
 			'RS' => 'سربيا',
 			'RU' => 'روس',
 			'RW' => 'روانڊا',
 			'SA' => 'سعودي عرب',
 			'SB' => 'سولومون ٻيٽَ',
 			'SC' => 'شي شلز',
 			'SD' => 'سوڊان',
 			'SE' => 'سوئيڊن',
 			'SG' => 'سنگاپور',
 			'SH' => 'سينٽ ھيلينا',
 			'SI' => 'سلوینیا',
 			'SJ' => 'سوالبارڊ ۽ جان ماین',
 			'SK' => 'سلوواڪيا',
 			'SL' => 'سيرا ليون',
 			'SM' => 'سین مرینو',
 			'SN' => 'سينيگال',
 			'SO' => 'سوماليا',
 			'SR' => 'سورينام',
 			'SS' => 'ڏکڻ سوڊان',
 			'ST' => 'سائو ٽوم ۽ پرنسپیي',
 			'SV' => 'ال سلواڊور',
 			'SX' => 'سنٽ مارٽن',
 			'SY' => 'شام',
 			'SZ' => 'ايسواٽني',
 			'SZ@alt=variant' => 'سوازيلينڊ',
 			'TA' => 'ٽرسٽن دا ڪوها',
 			'TC' => 'ترڪ ۽ ڪيڪوس ٻيٽ',
 			'TD' => 'چاڊ',
 			'TF' => 'فرانسيسي ڏاکڻي علائقا',
 			'TG' => 'ٽوگو',
 			'TH' => 'ٿائيليند',
 			'TJ' => 'تاجڪستان',
 			'TK' => 'ٽوڪلائو',
 			'TL' => 'تيمور ليستي',
 			'TL@alt=variant' => 'اوڀر تيمور',
 			'TM' => 'ترڪمانستان',
 			'TN' => 'تيونيسيا',
 			'TO' => 'ٽونگا',
 			'TR' => 'ترڪييي',
 			'TT' => 'ٽريني ڊيڊ ۽ ٽوباگو ٻيٽ',
 			'TV' => 'توالو',
 			'TW' => 'تائیوان',
 			'TZ' => 'تنزانيا',
 			'UA' => 'يوڪرين',
 			'UG' => 'يوگنڊا',
 			'UM' => 'آمريڪي خارجي ٻيٽ',
 			'UN' => 'گڏيل قومون',
 			'US' => 'آمريڪا جون گڏيل رياستون',
 			'US@alt=short' => 'يوايس',
 			'UY' => 'يوروگوءِ',
 			'UZ' => 'ازبڪستان',
 			'VA' => 'ويٽڪين سٽي',
 			'VC' => 'سینٽ ونسنت ۽ گریناڊینز',
 			'VE' => 'وينزويلا',
 			'VG' => 'برطانوي ورجن ٻيٽ',
 			'VI' => 'آمريڪي ورجن ٻيٽ',
 			'VN' => 'ويتنام',
 			'VU' => 'وينيٽيو',
 			'WF' => 'والس ۽ فتونا',
 			'WS' => 'ساموا',
 			'XA' => 'سوڊو-لهجا',
 			'XB' => 'سوڊو-بي ڊي',
 			'XK' => 'ڪوسووو',
 			'YE' => 'يمن',
 			'YT' => 'مياتي',
 			'ZA' => 'ڏکڻ آفريقا',
 			'ZM' => 'زيمبيا',
 			'ZW' => 'زمبابوي',
 			'ZZ' => 'اڻڄاتل خطو',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'POSIX' => 'ڪمپيوٽر',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'ڪئلينڊر',
 			'cf' => 'سڪي جو فارميٽ',
 			'collation' => 'ترتيب ڇانٽي',
 			'currency' => 'سڪو',
 			'hc' => 'ڪلاڪ سائيڪل',
 			'lb' => 'لائن ٽوڙڻ انداز',
 			'ms' => 'ماپڻ جو نظام',
 			'numbers' => 'انگ',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{ٻڌ ڌرم جو ڪئلينڊر},
 				'chinese' => q{چيني ڪئلينڊر},
 				'coptic' => q{ڪاپٽڪ ڪئلينڊر},
 				'dangi' => q{دانگي ڪئلينڊر},
 				'ethiopic' => q{ايٿوپيائي ڪئلينڊر},
 				'ethiopic-amete-alem' => q{ايٿوپڪ اميٽي عليم ڪئلينڊر},
 				'gregorian' => q{جارجيائي ڪئلينڊر},
 				'hebrew' => q{عبراني ڪئلينڊر},
 				'indian' => q{هندوستاني قومي ڪئلينڊر},
 				'islamic' => q{هجري ڪئلينڊر},
 				'islamic-civil' => q{هجري ڪئلينڊر (ٽيبل وارو، شهري دور)},
 				'islamic-tbla' => q{هجري ڪئلينڊر (ٽيبلر، فلڪياتي دور)},
 				'islamic-umalqura' => q{هجري ڪئلينڊر (اُم القرا)},
 				'iso8601' => q{ISO-8601 ڪئلينڊر},
 				'japanese' => q{جاپاني ڪئلينڊر},
 				'persian' => q{فارسي ڪئلينڊر},
 				'roc' => q{منگوو ڪئلينڊر},
 			},
 			'cf' => {
 				'account' => q{اڪائونٽنگ سڪو فارميٽ},
 				'standard' => q{معياري سڪو فارميٽ},
 			},
 			'collation' => {
 				'ducet' => q{ڊفالٽ يوني ڪوڊ ترتيب ڇانٽي},
 				'search' => q{عام مقصد جي ڳولا},
 				'standard' => q{معياري ترتيب ڇانٽي},
 			},
 			'hc' => {
 				'h11' => q{12 ڪلاڪ جو سسٽم (0–11)},
 				'h12' => q{12 ڪلاڪ جو سسٽم (1–12)},
 				'h23' => q{24 ڪلاڪ جو سسٽم (0–23)},
 				'h24' => q{24 ڪلاڪ جو سسٽم (1–24)},
 			},
 			'lb' => {
 				'loose' => q{لوز لائن ٽوڙ انداز},
 				'normal' => q{عام لائن ٽوڙ انداز},
 				'strict' => q{سخت لائن ٽوڙ انداز},
 			},
 			'ms' => {
 				'metric' => q{ميٽرڪ نظام},
 				'uksystem' => q{امپيريل ماپڻ جو نظام},
 				'ussystem' => q{آمريڪا جو ماپڻ جو نظام},
 			},
 			'numbers' => {
 				'arab' => q{عربي-هندي عدد},
 				'arabext' => q{وڌايل عربي-هندي عدد},
 				'armn' => q{ارمينيائي انگ},
 				'armnlow' => q{ارمينيائي ننڍا انگ},
 				'beng' => q{بنگلا عدد},
 				'cakm' => q{چڪما انگ اکر},
 				'deva' => q{ديوناگري عدد},
 				'ethi' => q{ايٿوپيائي انگ},
 				'fullwide' => q{پوري-ويڪر انگن},
 				'geor' => q{جيارجيائي انگ},
 				'grek' => q{يوناني انگ},
 				'greklow' => q{يوناني ننڍا انگ},
 				'gujr' => q{گجراتي عدد},
 				'guru' => q{گرمکي عدد},
 				'hanidec' => q{چيني اعشاري انگ},
 				'hans' => q{آسان چيني انگ},
 				'hansfin' => q{آسان چيني مالي انگ},
 				'hant' => q{روايتي چيني انگ},
 				'hantfin' => q{روايتي چيني مالي انگ},
 				'hebr' => q{عبراني انگ},
 				'java' => q{جاواني انگ اکر},
 				'jpan' => q{جاپاني انگ},
 				'jpanfin' => q{جاپاني مالي انگ},
 				'khmr' => q{خمر عدد},
 				'knda' => q{ڪناڊا عدد},
 				'laoo' => q{لائو عدد},
 				'latn' => q{مغربي عدد},
 				'mlym' => q{مليالم عدد},
 				'mtei' => q{ميٽي مئيڪ انگ اکر},
 				'mymr' => q{ميانمار عدد},
 				'olck' => q{اول چڪي انگ اکر},
 				'orya' => q{اوڊيا عدد},
 				'roman' => q{رومي انگ},
 				'romanlow' => q{رومي ننڍا انگ},
 				'taml' => q{روايتي تامل انگ},
 				'tamldec' => q{تامل عدد},
 				'telu' => q{تيلگو عدد},
 				'thai' => q{ٿائي عدد},
 				'tibt' => q{تبتي عدد},
 				'vaii' => q{وائي انگ اکر},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{ميٽرڪ},
 			'UK' => q{برطانيه},
 			'US' => q{آمريڪا},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'زبان: {0}',
 			'script' => 'اسڪرپٽ: {0}',
 			'region' => 'خطو: {0}',

		}
	},
);

has 'text_orientation' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { return {
			lines => '',
			characters => 'right-to-left',
		}}
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[َ ُ ِ ئ]},
			index => ['ا', 'ب', 'ٻ', 'پ', 'ڀ', 'ت', 'ث', 'ٺ', 'ٽ', 'ٿ', 'ج', '{جھ}', 'ڃ', 'ڄ', 'چ', 'ڇ', 'ح', 'خ', 'د', 'ذ', 'ڊ', 'ڌ', 'ڍ', 'ڏ', 'ر', 'ز', 'ڙ', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ڦ', 'ق', 'ک', 'ڪ', 'گ', '{گھ}', 'ڱ', 'ڳ', 'ل', 'م', 'ن', 'ڻ', 'ه', 'ھ', 'و', 'ي'],
			main => qr{[ء آ ا ب ٻ پ ڀ ت ث ٺ ٽ ٿ ج {جھ} ڃ ڄ چ ڇ ح خ د ذ ڊ ڌ ڍ ڏ ر ز ڙ س ش ص ض ط ظ ع غ ف ڦ ق ک ڪ گ {گھ} ڱ ڳ ل م ن ڻ ه ھ و ي]},
			punctuation => qr{[⹁ ⁏ \: ! ۔ ‘ ( ) \[ \] \{ \} /]},
		};
	},
EOT
: sub {
		return { index => ['ا', 'ب', 'ٻ', 'پ', 'ڀ', 'ت', 'ث', 'ٺ', 'ٽ', 'ٿ', 'ج', '{جھ}', 'ڃ', 'ڄ', 'چ', 'ڇ', 'ح', 'خ', 'د', 'ذ', 'ڊ', 'ڌ', 'ڍ', 'ڏ', 'ر', 'ز', 'ڙ', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ڦ', 'ق', 'ک', 'ڪ', 'گ', '{گھ}', 'ڱ', 'ڳ', 'ل', 'م', 'ن', 'ڻ', 'ه', 'ھ', 'و', 'ي'], };
},
);


has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(ڪارڊينل ڊائريڪشن),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(ڪارڊينل ڊائريڪشن),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(ڪبي{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(ڪبي{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(ميبي{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(ميبي{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(جيبي{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(جيبي{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(ٽيبي{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(ٽيبي{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(پيبي{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(پيبي{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(اڪسبي{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(اڪسبي{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(زيبي{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(زيبي{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(يوب{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(يوب{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(deci{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(deci{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(pico{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(pico{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(femto{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(femto{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(atto{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(atto{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(سينٽي{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(سينٽي{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(zepto{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(zepto{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(yocto{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(yocto{0}),
					},
					# Long Unit Identifier
					'10p-27' => {
						'1' => q(رونٽو{0}),
					},
					# Core Unit Identifier
					'27' => {
						'1' => q(رونٽو{0}),
					},
					# Long Unit Identifier
					'10p-30' => {
						'1' => q(ڪوئيڪٽو{0}),
					},
					# Core Unit Identifier
					'30' => {
						'1' => q(ڪوئيڪٽو{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(micro{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(micro{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(nano{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(nano{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(deka{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(deka{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(tera{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(tera{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(peta{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(peta{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(exa{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(exa{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(hecto{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(hecto{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(zetta{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(zetta{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(yotta{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(yotta{0}),
					},
					# Long Unit Identifier
					'10p27' => {
						'1' => q(رونا{0}),
					},
					# Core Unit Identifier
					'10p27' => {
						'1' => q(رونا{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(kilo{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(kilo{0}),
					},
					# Long Unit Identifier
					'10p30' => {
						'1' => q(ڪوئيٽا{0}),
					},
					# Core Unit Identifier
					'10p30' => {
						'1' => q(ڪوئيٽا{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(mega{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(mega{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(giga{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(giga{0}),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'one' => q({0} ميٽر في سيڪنڊ اسڪوائر),
						'other' => q({0} ميٽر في سيڪنڊ اسڪوائر),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'one' => q({0} ميٽر في سيڪنڊ اسڪوائر),
						'other' => q({0} ميٽر في سيڪنڊ اسڪوائر),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(آرڪ منٽس),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(آرڪ منٽس),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(ڊگريز),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(ڊگريز),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(ريڊيئنز),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(ريڊيئنز),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'one' => q({0} دنام),
						'other' => q({0} دنامز),
					},
					# Core Unit Identifier
					'dunam' => {
						'one' => q({0} دنام),
						'other' => q({0} دنامز),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'per' => q({0} في اسڪوائر ڪلوميٽر),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'per' => q({0} في اسڪوائر ڪلوميٽر),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'one' => q({0} مليگرام في ڊيسيليٽر),
						'other' => q({0} ملي گرامز في ڊيسي ليٽر),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'one' => q({0} مليگرام في ڊيسيليٽر),
						'other' => q({0} ملي گرامز في ڊيسي ليٽر),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(مولز),
						'one' => q({0} مول),
						'other' => q({0} مولز),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(مولز),
						'one' => q({0} مول),
						'other' => q({0} مولز),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(حصا في ملين),
						'one' => q({0} حصو في ملين),
						'other' => q({0} حصا في ملين),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(حصا في ملين),
						'one' => q({0} حصو في ملين),
						'other' => q({0} حصا في ملين),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'one' => q({0} پيرمائيرڊ),
						'other' => q({0} پيرمائيرڊ),
					},
					# Core Unit Identifier
					'permyriad' => {
						'one' => q({0} پيرمائيرڊ),
						'other' => q({0} پيرمائيرڊ),
					},
					# Long Unit Identifier
					'concentr-portion-per-1e9' => {
						'name' => q(حصا في ارب),
						'one' => q({0} حصو في ارب),
						'other' => q({0} حصا في ارب),
					},
					# Core Unit Identifier
					'portion-per-1e9' => {
						'name' => q(حصا في ارب),
						'one' => q({0} حصو في ارب),
						'other' => q({0} حصا في ارب),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(ليٽرز في 100 ڪلو ميٽر),
						'one' => q({0} ليٽر في 100 ڪلوميٽر),
						'other' => q({0} ليٽرز في 100 ڪلو ميٽر),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(ليٽرز في 100 ڪلو ميٽر),
						'one' => q({0} ليٽر في 100 ڪلوميٽر),
						'other' => q({0} ليٽرز في 100 ڪلو ميٽر),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'one' => q({0} ليٽرز في ڪلو ميٽر),
						'other' => q({0} ليٽرز في ڪلو ميٽر),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'one' => q({0} ليٽرز في ڪلو ميٽر),
						'other' => q({0} ليٽرز في ڪلو ميٽر),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'one' => q({0} ميل في گيلن),
						'other' => q({0} ميل في گيلن),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'one' => q({0} ميل في گيلن),
						'other' => q({0} ميل في گيلن),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'one' => q({0} ميل في امپيريل گيلن),
						'other' => q({0} ميل في امپيريل گيلن),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'one' => q({0} ميل في امپيريل گيلن),
						'other' => q({0} ميل في امپيريل گيلن),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(بٽز),
						'one' => q({0} بٽ),
						'other' => q({0} بٽز),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(بٽز),
						'one' => q({0} بٽ),
						'other' => q({0} بٽز),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(بائيٽز),
						'one' => q({0} بائيٽ),
						'other' => q({0} بائيٽس),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(بائيٽز),
						'one' => q({0} بائيٽ),
						'other' => q({0} بائيٽس),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(گيگا بٽز),
						'one' => q({0} گيگا بٽز),
						'other' => q({0} گيگا بٽز),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(گيگا بٽز),
						'one' => q({0} گيگا بٽز),
						'other' => q({0} گيگا بٽز),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(گيگا بائيٽز),
						'one' => q({0} گيگا بائيٽز),
						'other' => q({0} گيگا بائيٽز),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(گيگا بائيٽز),
						'one' => q({0} گيگا بائيٽز),
						'other' => q({0} گيگا بائيٽز),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(ڪلو بٽس),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(ڪلو بٽس),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(ڪلو بائيٽز),
						'one' => q({0} ڪلو بائيٽز),
						'other' => q({0} ڪلو بائيٽز),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(ڪلو بائيٽز),
						'one' => q({0} ڪلو بائيٽز),
						'other' => q({0} ڪلو بائيٽز),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(ميگا بٽز),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(ميگا بٽز),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(ميگا بائيٽز),
						'one' => q({0} ميگا بائيٽز),
						'other' => q({0} ميگا بائيٽز),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(ميگا بائيٽز),
						'one' => q({0} ميگا بائيٽز),
						'other' => q({0} ميگا بائيٽز),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(پيرا بائيٽس),
						'one' => q({0} پيرا بائيٽس),
						'other' => q({0} پيرا بائيٽس),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(پيرا بائيٽس),
						'one' => q({0} پيرا بائيٽس),
						'other' => q({0} پيرا بائيٽس),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(ٽيرا بٽز),
						'one' => q({0} ٽيرا بٽز),
						'other' => q({0} ٽيرا بٽز),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(ٽيرا بٽز),
						'one' => q({0} ٽيرا بٽز),
						'other' => q({0} ٽيرا بٽز),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(ٽيرا بائيٽز),
						'one' => q({0} ٽيرا بائيٽز),
						'other' => q({0} ٽيرا بائيٽز),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(ٽيرا بائيٽز),
						'one' => q({0} ٽيرا بائيٽز),
						'other' => q({0} ٽيرا بائيٽز),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(صديون),
						'one' => q({0} صدي),
						'other' => q({0} صديون),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(صديون),
						'one' => q({0} صدي),
						'other' => q({0} صديون),
					},
					# Long Unit Identifier
					'duration-month' => {
						'one' => q({0} مهينو),
						'other' => q({0} مهينا),
						'per' => q({0} في مهينو),
					},
					# Core Unit Identifier
					'month' => {
						'one' => q({0} مهينو),
						'other' => q({0} مهينا),
						'per' => q({0} في مهينو),
					},
					# Long Unit Identifier
					'duration-night' => {
						'name' => q(راتيون),
						'one' => q({0} رات),
						'other' => q({0} راتيون),
						'per' => q({0} في رات),
					},
					# Core Unit Identifier
					'night' => {
						'name' => q(راتيون),
						'one' => q({0} رات),
						'other' => q({0} راتيون),
						'per' => q({0} في رات),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(ٽه ماهيون),
						'one' => q({0} ٽه ماهيون),
						'other' => q({0} ٽه ماهيون),
						'per' => q({0}/ٽه ماهي),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(ٽه ماهيون),
						'one' => q({0} ٽه ماهيون),
						'other' => q({0} ٽه ماهيون),
						'per' => q({0}/ٽه ماهي),
					},
					# Long Unit Identifier
					'duration-second' => {
						'one' => q({0} في سيڪنڊ),
						'other' => q({0} سيڪنڊ),
					},
					# Core Unit Identifier
					'second' => {
						'one' => q({0} في سيڪنڊ),
						'other' => q({0} سيڪنڊ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'one' => q({0} هفتو),
						'other' => q({0} هفتا),
						'per' => q({0} في هفتو),
					},
					# Core Unit Identifier
					'week' => {
						'one' => q({0} هفتو),
						'other' => q({0} هفتا),
						'per' => q({0} في هفتو),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'one' => q({0} ملي ايمپئير),
						'other' => q({0} ملي ايمپئير),
					},
					# Core Unit Identifier
					'milliampere' => {
						'one' => q({0} ملي ايمپئير),
						'other' => q({0} ملي ايمپئير),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'one' => q({0} اوهم),
						'other' => q({0} اوهمس),
					},
					# Core Unit Identifier
					'ohm' => {
						'one' => q({0} اوهم),
						'other' => q({0} اوهمس),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(وولٽز),
						'one' => q({0} وولٽ),
						'other' => q({0} وولٽس),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(وولٽز),
						'one' => q({0} وولٽ),
						'other' => q({0} وولٽس),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(برٽش ٿرمل يونٽس),
						'one' => q({0} برٽش ٿرمل يونٽ),
						'other' => q({0} برٽش ٿرمل يونٽس),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(برٽش ٿرمل يونٽس),
						'one' => q({0} برٽش ٿرمل يونٽ),
						'other' => q({0} برٽش ٿرمل يونٽس),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'one' => q({0} ڪيلوري),
						'other' => q({0} ڪيلوريز),
					},
					# Core Unit Identifier
					'calorie' => {
						'one' => q({0} ڪيلوري),
						'other' => q({0} ڪيلوريز),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(اليڪٽرون وولٽس),
						'one' => q({0} اليڪٽرون وولٽ),
						'other' => q({0} اليڪٽرون وولٽز),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(اليڪٽرون وولٽس),
						'one' => q({0} اليڪٽرون وولٽ),
						'other' => q({0} اليڪٽرون وولٽز),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(ڪيلوريز),
						'one' => q({0} ڪيلوري),
						'other' => q({0} ڪيلوريز),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(ڪيلوريز),
						'one' => q({0} ڪيلوري),
						'other' => q({0} ڪيلوريز),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'one' => q({0} جول),
						'other' => q({0} جولز),
					},
					# Core Unit Identifier
					'joule' => {
						'one' => q({0} جول),
						'other' => q({0} جولز),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(ڪلو جولز),
						'one' => q({0} ڪلو جول),
						'other' => q({0} ڪلو جولز),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(ڪلو جولز),
						'one' => q({0} ڪلو جول),
						'other' => q({0} ڪلو جولز),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'one' => q({0} ڪلو واٽ في ڪلاڪ),
						'other' => q({0} ڪلو واٽ في ڪلڪ),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'one' => q({0} ڪلو واٽ في ڪلاڪ),
						'other' => q({0} ڪلو واٽ في ڪلڪ),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(US ٿرمس),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(US ٿرمس),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(ڪلو واٽ آورز في 100 ڪلوميٽر),
						'one' => q({0} ڪلو واٽ آور في 100 ڪلوميٽر),
						'other' => q({0} ڪلو واٽ آور في 100 ڪلوميٽر),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(ڪلو واٽ آورز في 100 ڪلوميٽر),
						'one' => q({0} ڪلو واٽ آور في 100 ڪلوميٽر),
						'other' => q({0} ڪلو واٽ آور في 100 ڪلوميٽر),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(نيوٽنز),
						'one' => q({0} نيوٽن),
						'other' => q({0} نيوٽنز),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(نيوٽنز),
						'one' => q({0} نيوٽن),
						'other' => q({0} نيوٽنز),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(پائونڊز آف فورس),
						'one' => q({0} پائونڊ آف فورس),
						'other' => q({0}پائونڊز آف فورس),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(پائونڊز آف فورس),
						'one' => q({0} پائونڊ آف فورس),
						'other' => q({0}پائونڊز آف فورس),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'one' => q({0} dot),
						'other' => q({0} dots),
					},
					# Core Unit Identifier
					'dot' => {
						'one' => q({0} dot),
						'other' => q({0} dots),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(في سينٽي ميٽر ڊاٽس),
						'one' => q({0} في سينٽي ميٽر ڊاٽ),
						'other' => q({0} في سينٽي ميٽر ڊاٽس),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(في سينٽي ميٽر ڊاٽس),
						'one' => q({0} في سينٽي ميٽر ڊاٽ),
						'other' => q({0} في سينٽي ميٽر ڊاٽس),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(ڊاٽس في انچ),
						'one' => q({0} ڊاٽ في انچ),
						'other' => q({0} ڊاٽس في انچ),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(ڊاٽس في انچ),
						'one' => q({0} ڊاٽ في انچ),
						'other' => q({0} ڊاٽس في انچ),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'name' => q(ٽائپوگرافڪ em),
						'one' => q({0} em),
						'other' => q({0} ems),
					},
					# Core Unit Identifier
					'em' => {
						'name' => q(ٽائپوگرافڪ em),
						'one' => q({0} em),
						'other' => q({0} ems),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'one' => q({0} ميگا پڪسل),
						'other' => q({0} ميگا پڪسلز),
					},
					# Core Unit Identifier
					'megapixel' => {
						'one' => q({0} ميگا پڪسل),
						'other' => q({0} ميگا پڪسلز),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'one' => q({0} پڪسل),
						'other' => q({0} پڪسلز),
					},
					# Core Unit Identifier
					'pixel' => {
						'one' => q({0} پڪسل),
						'other' => q({0} پڪسلز),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(پڪسلز في سينٽي ميٽر),
						'one' => q({0} پگزل في سينٽي ميٽر),
						'other' => q({0} پگزلس في سينٽي ميٽر),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(پڪسلز في سينٽي ميٽر),
						'one' => q({0} پگزل في سينٽي ميٽر),
						'other' => q({0} پگزلس في سينٽي ميٽر),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(پڪسلز في انچ),
						'one' => q({0} پڪسل في انچ),
						'other' => q({0} پڪسلز في انچ),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(پڪسلز في انچ),
						'one' => q({0} پڪسل في انچ),
						'other' => q({0} پڪسلز في انچ),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'one' => q({0} pc),
						'other' => q({0} پارسيڪ),
					},
					# Core Unit Identifier
					'parsec' => {
						'one' => q({0} pc),
						'other' => q({0} پارسيڪ),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'one' => q({0} سولر ريڊيس),
						'other' => q({0} سولر راڊي),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'one' => q({0} سولر ريڊيس),
						'other' => q({0} سولر راڊي),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(ڪنڊيلا),
						'one' => q({0} ڪنڊيلا),
						'other' => q({0} ڪنڊيلا),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(ڪنڊيلا),
						'one' => q({0} ڪنڊيلا),
						'other' => q({0} ڪنڊيلا),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(ليومن),
						'one' => q({0} ليومن),
						'other' => q({0} ليومن),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(ليومن),
						'one' => q({0} ليومن),
						'other' => q({0} ليومن),
					},
					# Long Unit Identifier
					'light-lux' => {
						'one' => q({0} لڪس),
						'other' => q({0} لڪس),
					},
					# Core Unit Identifier
					'lux' => {
						'one' => q({0} لڪس),
						'other' => q({0} لڪس),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'one' => q({0} سولر ليومينوسٽي),
						'other' => q({0} سولر ليومينوسائيٽيز),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'one' => q({0} سولر ليومينوسٽي),
						'other' => q({0} سولر ليومينوسائيٽيز),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'one' => q({0} ڊالٽن),
						'other' => q({0} ڊالٽنز),
					},
					# Core Unit Identifier
					'dalton' => {
						'one' => q({0} ڊالٽن),
						'other' => q({0} ڊالٽنز),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'one' => q({0} ارٿ ماس),
						'other' => q({0} ارٿ ماسز),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'one' => q({0} ارٿ ماس),
						'other' => q({0} ارٿ ماسز),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'one' => q({0} گرام),
						'other' => q({0} گرامَ),
						'per' => q({0} في گرام),
					},
					# Core Unit Identifier
					'gram' => {
						'one' => q({0} گرام),
						'other' => q({0} گرامَ),
						'per' => q({0} في گرام),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(ڪلوگرامَ),
						'one' => q({0} ڪلوگرام),
						'other' => q({0}ڪلوگرامَ),
						'per' => q({0} في ڪلوگرام),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(ڪلوگرامَ),
						'one' => q({0} ڪلوگرام),
						'other' => q({0}ڪلوگرامَ),
						'per' => q({0} في ڪلوگرام),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(مائڪروگرامَ),
						'one' => q({0} مائڪروگرام),
						'other' => q({0} مائڪرو گرام),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(مائڪروگرامَ),
						'one' => q({0} مائڪروگرام),
						'other' => q({0} مائڪرو گرام),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(ملي گرامَ),
						'one' => q({0} ملي گرام),
						'other' => q({0} ملي گرامَ),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(ملي گرامَ),
						'one' => q({0} ملي گرام),
						'other' => q({0} ملي گرامَ),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'one' => q({0} سولر ماس),
						'other' => q({0} سولر ماسز),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'one' => q({0} سولر ماس),
						'other' => q({0} سولر ماسز),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(ميٽرڪ ٽَنَ),
						'one' => q({0} ميٽرڪ ٽَنُ),
						'other' => q({0} ميٽرڪ ٽَنَ),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(ميٽرڪ ٽَنَ),
						'one' => q({0} ميٽرڪ ٽَنُ),
						'other' => q({0} ميٽرڪ ٽَنَ),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0} في {1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0} في {1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'one' => q({0} گيگا واٽ),
						'other' => q({0} گيگا واٽز),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'one' => q({0} گيگا واٽ),
						'other' => q({0} گيگا واٽز),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(ڪلو واٽس),
						'one' => q({0} ڪلو واٽ),
						'other' => q({0} ڪلو واٽز),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(ڪلو واٽس),
						'one' => q({0} ڪلو واٽ),
						'other' => q({0} ڪلو واٽز),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(ميگا واٽز),
						'one' => q({0} ميگا واٽ),
						'other' => q({0} ميگا واٽز),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(ميگا واٽز),
						'one' => q({0} ميگا واٽ),
						'other' => q({0} ميگا واٽز),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(ملي واٽز),
						'one' => q({0} ملي واٽ),
						'other' => q({0} ملي واٽز),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(ملي واٽز),
						'one' => q({0} ملي واٽ),
						'other' => q({0} ملي واٽز),
					},
					# Long Unit Identifier
					'power-watt' => {
						'one' => q({0} واٽ),
						'other' => q({0} واٽز),
					},
					# Core Unit Identifier
					'watt' => {
						'one' => q({0} واٽ),
						'other' => q({0} واٽز),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q(اسڪوائر {0}),
						'one' => q(اسڪوائر {0}),
						'other' => q(اسڪوائر {0}),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q(اسڪوائر {0}),
						'one' => q(اسڪوائر {0}),
						'other' => q(اسڪوائر {0}),
					},
					# Long Unit Identifier
					'power3' => {
						'1' => q(ڪيوبڪ {0}),
						'one' => q(cubic {0}),
						'other' => q(ڪيوبڪ{0}),
					},
					# Core Unit Identifier
					'power3' => {
						'1' => q(ڪيوبڪ {0}),
						'one' => q(cubic {0}),
						'other' => q(ڪيوبڪ{0}),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(ايٽماس فيئر),
						'one' => q({0} ايٽماس فيئر),
						'other' => q({0} ايٽماس فيئر),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(ايٽماس فيئر),
						'one' => q({0} ايٽماس فيئر),
						'other' => q({0} ايٽماس فيئر),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(بارس),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(بارس),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(هيڪٽوپاسڪلز),
						'one' => q({0} هيڪٽوپاسڪلز),
						'other' => q({0} هيڪٽوپاسڪلز),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(هيڪٽوپاسڪلز),
						'one' => q({0} هيڪٽوپاسڪلز),
						'other' => q({0} هيڪٽوپاسڪلز),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(مرڪري جا انچز),
						'one' => q(مرڪري جو {0} انچ),
						'other' => q(مرڪري جا {0} انچز),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(مرڪري جا انچز),
						'one' => q(مرڪري جو {0} انچ),
						'other' => q(مرڪري جا {0} انچز),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(ڪلو پاسڪلز),
						'one' => q({0} ڪلو پاسڪل),
						'other' => q({0} ڪلو پاسڪلز),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(ڪلو پاسڪلز),
						'one' => q({0} ڪلو پاسڪل),
						'other' => q({0} ڪلو پاسڪلز),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(ميگا پاسڪلز),
						'one' => q({0} ميگا پاسڪل),
						'other' => q({0} ميگا پاسڪلز),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(ميگا پاسڪلز),
						'one' => q({0} ميگا پاسڪل),
						'other' => q({0} ميگا پاسڪلز),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(ملي بارز),
						'one' => q({0} ملي بارز),
						'other' => q({0} ملي بارز),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(ملي بارز),
						'one' => q({0} ملي بارز),
						'other' => q({0} ملي بارز),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(مرڪري جو ملي ميٽر),
						'one' => q(مرڪري جو {0} ملي ميٽر),
						'other' => q(مرڪري جو {0} ملي ميٽر),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(مرڪري جو ملي ميٽر),
						'one' => q(مرڪري جو {0} ملي ميٽر),
						'other' => q(مرڪري جو {0} ملي ميٽر),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(پاسڪلز),
						'one' => q({0} پاسڪل),
						'other' => q({0} پاسڪلز),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(پاسڪلز),
						'one' => q({0} پاسڪل),
						'other' => q({0} پاسڪلز),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(پائونڊز في اسڪوائر انچ),
						'one' => q({0} پائونڊ في اسڪوائر انچ),
						'other' => q({0} پائونڊز في اسڪوائر انچ),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(پائونڊز في اسڪوائر انچ),
						'one' => q({0} پائونڊ في اسڪوائر انچ),
						'other' => q({0} پائونڊز في اسڪوائر انچ),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'name' => q(بوفورٽ),
						'one' => q(بوفورٽ {0}),
						'other' => q(بوفورٽ {0}),
					},
					# Core Unit Identifier
					'beaufort' => {
						'name' => q(بوفورٽ),
						'one' => q(بوفورٽ {0}),
						'other' => q(بوفورٽ {0}),
					},
					# Long Unit Identifier
					'speed-light-speed' => {
						'name' => q(نوري),
						'one' => q({0} نوري),
						'other' => q({0} نوري),
					},
					# Core Unit Identifier
					'light-speed' => {
						'name' => q(نوري),
						'one' => q({0} نوري),
						'other' => q({0} نوري),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(ڊگري سيلسيس),
						'one' => q({0} ڊگري سيلسيس),
						'other' => q({0} ڊگري سيلسيس),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(ڊگري سيلسيس),
						'one' => q({0} ڊگري سيلسيس),
						'other' => q({0} ڊگري سيلسيس),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(ڊگريز فارن هائيٽ),
						'one' => q({0} ڊگريز فارن هائيٽ),
						'other' => q({0} ڊگريز فارن هائيٽ),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(ڊگريز فارن هائيٽ),
						'one' => q({0} ڊگريز فارن هائيٽ),
						'other' => q({0} ڊگريز فارن هائيٽ),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'name' => q(ڊگري),
						'one' => q({0} ڊگري),
						'other' => q({0} ڊگري),
					},
					# Core Unit Identifier
					'generic' => {
						'name' => q(ڊگري),
						'one' => q({0} ڊگري),
						'other' => q({0} ڊگري),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(ڪيلونز),
						'one' => q({0} ڪيلونز),
						'other' => q({0} ڪيلونز),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(ڪيلونز),
						'one' => q({0} ڪيلونز),
						'other' => q({0} ڪيلونز),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(نيوٽن-ميٽرز),
						'one' => q({0} نيوٽن-ميٽر),
						'other' => q({0} نيوٽن-ميٽرز),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(نيوٽن-ميٽرز),
						'one' => q({0} نيوٽن-ميٽر),
						'other' => q({0} نيوٽن-ميٽرز),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(پائونڊ-فيٽ),
						'one' => q({0} پائونڊ-فوٽ),
						'other' => q({0} پائونڊ-فيٽ),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(پائونڊ-فيٽ),
						'one' => q({0} پائونڊ-فوٽ),
						'other' => q({0} پائونڊ-فيٽ),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(بيريلز),
						'one' => q({0} بيريلز),
						'other' => q({0} بيريلز),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(بيريلز),
						'one' => q({0} بيريلز),
						'other' => q({0} بيريلز),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(Imp. پاڻياٺ آئونسز),
						'one' => q({0} Imp. پاڻياٺ آئونس),
						'other' => q({0} Imp. پاڻياٺ آئونسز),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(Imp. پاڻياٺ آئونسز),
						'one' => q({0} Imp. پاڻياٺ آئونس),
						'other' => q({0} Imp. پاڻياٺ آئونسز),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'acceleration-g-force' => {
						'one' => q({0}G),
						'other' => q({0}Gs),
					},
					# Core Unit Identifier
					'g-force' => {
						'one' => q({0}G),
						'other' => q({0}Gs),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(m/s²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(m/s²),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'one' => q({0}رئڊ),
						'other' => q({0}رئڊ),
					},
					# Core Unit Identifier
					'radian' => {
						'one' => q({0}رئڊ),
						'other' => q({0}رئڊ),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'one' => q({0}ھيڪٽر),
						'other' => q({0}ھيڪٽر),
					},
					# Core Unit Identifier
					'hectare' => {
						'one' => q({0}ھيڪٽر),
						'other' => q({0}ھيڪٽر),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'one' => q({0}m²),
						'other' => q({0}m²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'one' => q({0}m²),
						'other' => q({0}m²),
					},
					# Long Unit Identifier
					'concentr-portion-per-1e9' => {
						'name' => q(ح ف ا),
						'one' => q({0}ح ف ا),
						'other' => q({0}ح ف ا),
					},
					# Core Unit Identifier
					'portion-per-1e9' => {
						'name' => q(ح ف ا),
						'one' => q({0}ح ف ا),
						'other' => q({0}ح ف ا),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(ص),
						'one' => q({0}ص),
						'other' => q({0}ص),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(ص),
						'one' => q({0}ص),
						'other' => q({0}ص),
					},
					# Long Unit Identifier
					'duration-day' => {
						'one' => q({0}ڏينهن),
						'other' => q({0}ڏينهن),
						'per' => q({0}/ڏينهن),
					},
					# Core Unit Identifier
					'day' => {
						'one' => q({0}ڏينهن),
						'other' => q({0}ڏينهن),
						'per' => q({0}/ڏينهن),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'one' => q({0}ڏهاڪ),
						'other' => q({0}ڏهاڪ),
					},
					# Core Unit Identifier
					'decade' => {
						'one' => q({0}ڏهاڪ),
						'other' => q({0}ڏهاڪ),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'one' => q({0}مائڪرو سيڪنڊ),
						'other' => q({0}مائڪرو سيڪنڊ),
					},
					# Core Unit Identifier
					'microsecond' => {
						'one' => q({0}مائڪرو سيڪنڊ),
						'other' => q({0}مائڪرو سيڪنڊ),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					# Core Unit Identifier
					'millisecond' => {
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(مهينو),
						'one' => q({0}مهينو),
						'other' => q({0}مهينا),
						'per' => q({0}/مهينو),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(مهينو),
						'one' => q({0}مهينو),
						'other' => q({0}مهينا),
						'per' => q({0}/مهينو),
					},
					# Long Unit Identifier
					'duration-night' => {
						'name' => q(راتيون),
						'one' => q({0}رات),
						'other' => q({0}راتيون),
						'per' => q({0}/رات),
					},
					# Core Unit Identifier
					'night' => {
						'name' => q(راتيون),
						'one' => q({0}رات),
						'other' => q({0}راتيون),
						'per' => q({0}/رات),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'one' => q({0}ٽه ماهي),
						'other' => q({0}ٽه ماهي),
						'per' => q({0}/ٽه ماهي),
					},
					# Core Unit Identifier
					'quarter' => {
						'one' => q({0}ٽه ماهي),
						'other' => q({0}ٽه ماهي),
						'per' => q({0}/ٽه ماهي),
					},
					# Long Unit Identifier
					'duration-second' => {
						'one' => q({0}سيڪنڊ),
						'other' => q({0}سيڪنڊ),
					},
					# Core Unit Identifier
					'second' => {
						'one' => q({0}سيڪنڊ),
						'other' => q({0}سيڪنڊ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(هفتو),
						'one' => q({0}هفتو),
						'other' => q({0}هفتا),
						'per' => q({0}/هفتو),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(هفتو),
						'one' => q({0}هفتو),
						'other' => q({0}هفتا),
						'per' => q({0}/هفتو),
					},
					# Long Unit Identifier
					'duration-year' => {
						'one' => q({0}س),
						'other' => q({0}س),
						'per' => q({0}/س),
					},
					# Core Unit Identifier
					'year' => {
						'one' => q({0}س),
						'other' => q({0}س),
						'per' => q({0}/س),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'one' => q({0}ڪ و آ/100 ڪ م),
						'other' => q({0}ڪ و آ/100 ڪ م),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'one' => q({0}ڪ و آ/100 ڪ م),
						'other' => q({0}ڪ و آ/100 ڪ م),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'one' => q({0}dot),
						'other' => q({0}dot),
					},
					# Core Unit Identifier
					'dot' => {
						'one' => q({0}dot),
						'other' => q({0}dot),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'one' => q({0}dpcm),
						'other' => q({0}dpcm),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'one' => q({0}dpcm),
						'other' => q({0}dpcm),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'one' => q({0}dpi),
						'other' => q({0}dpi),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'one' => q({0}dpi),
						'other' => q({0}dpi),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'one' => q({0}em),
						'other' => q({0}em),
					},
					# Core Unit Identifier
					'em' => {
						'one' => q({0}em),
						'other' => q({0}em),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(MP),
						'one' => q({0}MP),
						'other' => q({0}MP),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(MP),
						'one' => q({0}MP),
						'other' => q({0}MP),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(px),
						'one' => q({0}px),
						'other' => q({0}px),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(px),
						'one' => q({0}px),
						'other' => q({0}px),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'one' => q({0}ppcm),
						'other' => q({0}ppcm),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'one' => q({0}ppcm),
						'other' => q({0}ppcm),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'one' => q({0}ppi),
						'other' => q({0}ppi),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'one' => q({0}ppi),
						'other' => q({0}ppi),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'one' => q({0} cm),
						'other' => q({0} cm),
					},
					# Core Unit Identifier
					'centimeter' => {
						'one' => q({0} cm),
						'other' => q({0} cm),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(ايس ايم آئي),
						'one' => q({0}ايس ايم آئي),
						'other' => q({0}ايس ايم آئي),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(ايس ايم آئي),
						'one' => q({0}ايس ايم آئي),
						'other' => q({0}ايس ايم آئي),
					},
					# Long Unit Identifier
					'length-point' => {
						'one' => q({0}پوائينٽ),
						'other' => q({0}پوائينٽ),
					},
					# Core Unit Identifier
					'point' => {
						'one' => q({0}پوائينٽ),
						'other' => q({0}پوائينٽ),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(R☉),
						'one' => q({0}R☉),
						'other' => q({0}R☉),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(R☉),
						'one' => q({0}R☉),
						'other' => q({0}R☉),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(گرام),
						'one' => q({0}g),
						'other' => q({0}g),
						'per' => q({0}/گـ.),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(گرام),
						'one' => q({0}g),
						'other' => q({0}g),
						'per' => q({0}/گـ.),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(kg),
						'one' => q({0}kg),
						'other' => q({0} kg),
						'per' => q({0}/ڪ.گـ.),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(kg),
						'one' => q({0}kg),
						'other' => q({0} kg),
						'per' => q({0}/ڪ.گـ.),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(مـ.گـ.),
						'one' => q({0}مـ.گـ.),
						'other' => q({0}مـ.گـ.),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(مـ.گـ.),
						'one' => q({0}مـ.گـ.),
						'other' => q({0}مـ.گـ.),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(ٽَـ),
						'one' => q({0}ٽَـ),
						'other' => q({0}ٽَـ),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(ٽَـ),
						'one' => q({0}ٽَـ),
						'other' => q({0}ٽَـ),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'one' => q({0} km/h),
						'other' => q({0} km/h),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'one' => q({0} km/h),
						'other' => q({0} km/h),
					},
					# Long Unit Identifier
					'speed-light-speed' => {
						'name' => q(نوري),
						'one' => q({0}نوري),
						'other' => q({0}نوري),
					},
					# Core Unit Identifier
					'light-speed' => {
						'name' => q(نوري),
						'one' => q({0}نوري),
						'other' => q({0}نوري),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(ڊائريڪشن),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(ڊائريڪشن),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(ڪشش ثقل),
						'one' => q({0} ڪشش ثقل),
						'other' => q({0} ڪشش ثقل),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(ڪشش ثقل),
						'one' => q({0} ڪشش ثقل),
						'other' => q({0} ڪشش ثقل),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(ميٽر في سيڪنڊ اسڪوائر),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(ميٽر في سيڪنڊ اسڪوائر),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(آرڪ منٽز),
						'one' => q({0} آرڪ منٽز),
						'other' => q({0} آرڪ منٽز),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(آرڪ منٽز),
						'one' => q({0} آرڪ منٽز),
						'other' => q({0} آرڪ منٽز),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(آرڪ سيڪنڊز),
						'one' => q({0} آرڪ سيڪنڊز),
						'other' => q({0} آرڪ سيڪنڊز),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(آرڪ سيڪنڊز),
						'one' => q({0} آرڪ سيڪنڊز),
						'other' => q({0} آرڪ سيڪنڊز),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(ڊگري),
						'one' => q({0} ڊگريز),
						'other' => q({0} ڊگريز),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(ڊگري),
						'one' => q({0} ڊگريز),
						'other' => q({0} ڊگريز),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(ريڊيئن),
						'one' => q({0} ريڊيئنز),
						'other' => q({0} ريڊيئنز),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(ريڊيئن),
						'one' => q({0} ريڊيئنز),
						'other' => q({0} ريڊيئنز),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(گردش),
						'one' => q({0} گردشون),
						'other' => q({0} گردشون),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(گردش),
						'one' => q({0} گردشون),
						'other' => q({0} گردشون),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(ايڪڙ),
						'one' => q({0} ايڪڙ),
						'other' => q({0} ايڪڙ),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(ايڪڙ),
						'one' => q({0} ايڪڙ),
						'other' => q({0} ايڪڙ),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(دنام),
						'one' => q({0} دنام),
						'other' => q({0} دنام),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(دنام),
						'one' => q({0} دنام),
						'other' => q({0} دنام),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(هيڪٽر),
						'one' => q({0} هيڪٽر),
						'other' => q({0} هيڪٽر),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(هيڪٽر),
						'one' => q({0} هيڪٽر),
						'other' => q({0} هيڪٽر),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(اسڪوائر سينٽي ميٽر),
						'one' => q({0} اسڪوائر سينٽي ميٽر),
						'other' => q({0} اسڪوائر سينٽي ميٽر),
						'per' => q({0} في اسڪوائر سينٽي ميٽر),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(اسڪوائر سينٽي ميٽر),
						'one' => q({0} اسڪوائر سينٽي ميٽر),
						'other' => q({0} اسڪوائر سينٽي ميٽر),
						'per' => q({0} في اسڪوائر سينٽي ميٽر),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(اسڪوائر فٽ),
						'one' => q({0} اسڪوائر فٽ),
						'other' => q({0} اسڪوائر فٽ),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(اسڪوائر فٽ),
						'one' => q({0} اسڪوائر فٽ),
						'other' => q({0} اسڪوائر فٽ),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(اسڪوائر انچ),
						'one' => q({0} اسڪوائر انچ),
						'other' => q({0} اسڪوائر انچ),
						'per' => q({0} في اسڪوائر انچ),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(اسڪوائر انچ),
						'one' => q({0} اسڪوائر انچ),
						'other' => q({0} اسڪوائر انچ),
						'per' => q({0} في اسڪوائر انچ),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(اسڪوائر ڪلوميٽر),
						'one' => q({0} اسڪوائر ڪلوميٽر),
						'other' => q({0} اسڪوائر ڪلوميٽر),
						'per' => q({0} اسڪوائر ڪلوميٽر),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(اسڪوائر ڪلوميٽر),
						'one' => q({0} اسڪوائر ڪلوميٽر),
						'other' => q({0} اسڪوائر ڪلوميٽر),
						'per' => q({0} اسڪوائر ڪلوميٽر),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(اسڪوائر ميٽر),
						'one' => q({0} اسڪوائر ميٽر),
						'other' => q({0} اسڪوائر ميٽر),
						'per' => q({0} في اسڪوائر ميٽر),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(اسڪوائر ميٽر),
						'one' => q({0} اسڪوائر ميٽر),
						'other' => q({0} اسڪوائر ميٽر),
						'per' => q({0} في اسڪوائر ميٽر),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(اسڪوائر ميل),
						'one' => q({0} اسڪوائر ميل),
						'other' => q({0} اسڪوائر ميل),
						'per' => q({0} في اسڪوائر ميل),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(اسڪوائر ميل),
						'one' => q({0} اسڪوائر ميل),
						'other' => q({0} اسڪوائر ميل),
						'per' => q({0} في اسڪوائر ميل),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(اسڪوائر يارڊ),
						'one' => q({0} ااسڪوائر يارڊ),
						'other' => q({0} ااسڪوائر يارڊ),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(اسڪوائر يارڊ),
						'one' => q({0} ااسڪوائر يارڊ),
						'other' => q({0} ااسڪوائر يارڊ),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(آئٽم),
						'one' => q({0} آئٽم),
						'other' => q({0} آئٽم),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(آئٽم),
						'one' => q({0} آئٽم),
						'other' => q({0} آئٽم),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(قيراط),
						'one' => q({0} قيراط),
						'other' => q({0} قيراط),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(قيراط),
						'one' => q({0} قيراط),
						'other' => q({0} قيراط),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(ملي گرامز في ڊيسي ليٽر),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(ملي گرامز في ڊيسي ليٽر),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(ملي مولز في ليٽر),
						'one' => q({0} ملي مولز في ليٽر),
						'other' => q({0} ملي مولز في ليٽر),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(ملي مولز في ليٽر),
						'one' => q({0} ملي مولز في ليٽر),
						'other' => q({0} ملي مولز في ليٽر),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(مول),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(مول),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(پيرمائيرڊ),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(پيرمائيرڊ),
					},
					# Long Unit Identifier
					'concentr-portion-per-1e9' => {
						'name' => q(حصا/ارب),
						'one' => q({0} ح ف ا),
						'other' => q({0} ح ف ا),
					},
					# Core Unit Identifier
					'portion-per-1e9' => {
						'name' => q(حصا/ارب),
						'one' => q({0} ح ف ا),
						'other' => q({0} ح ف ا),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(ليٽرز في ڪلو ميٽر),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(ليٽرز في ڪلو ميٽر),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(ميل في گيلن),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(ميل في گيلن),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(ميل في امپيريل گيلن),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(ميل في امپيريل گيلن),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} اوڀر),
						'north' => q({0} اتر),
						'south' => q({0} ڏکڻ),
						'west' => q({0} اولهه),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} اوڀر),
						'north' => q({0} اتر),
						'south' => q({0} ڏکڻ),
						'west' => q({0} اولهه),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(بٽ),
						'one' => q({0} بٽ),
						'other' => q({0} بٽ),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(بٽ),
						'one' => q({0} بٽ),
						'other' => q({0} بٽ),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(بائيٽ),
						'one' => q({0} بائيٽ),
						'other' => q({0} بائيٽ),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(بائيٽ),
						'one' => q({0} بائيٽ),
						'other' => q({0} بائيٽ),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(ڪلو بٽ),
						'one' => q({0} ڪلو بٽز),
						'other' => q({0} ڪلو بٽز),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(ڪلو بٽ),
						'one' => q({0} ڪلو بٽز),
						'other' => q({0} ڪلو بٽز),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(ڪلو بائيٽ),
						'one' => q({0} ڪلو بائيٽ),
						'other' => q({0} ڪلو بائيٽز),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(ڪلو بائيٽ),
						'one' => q({0} ڪلو بائيٽ),
						'other' => q({0} ڪلو بائيٽز),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(ميگا بٽ),
						'one' => q({0} ميگا بٽز),
						'other' => q({0} ميگا بٽز),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(ميگا بٽ),
						'one' => q({0} ميگا بٽز),
						'other' => q({0} ميگا بٽز),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(ص),
						'one' => q({0} ص),
						'other' => q({0} ص),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(ص),
						'one' => q({0} ص),
						'other' => q({0} ص),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(ڏينهن),
						'one' => q({0} ڏينهن),
						'other' => q({0} ڏينهن),
						'per' => q({0}/ڏينهن),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(ڏينهن),
						'one' => q({0} ڏينهن),
						'other' => q({0} ڏينهن),
						'per' => q({0}/ڏينهن),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(ڏهاڪا),
						'one' => q({0} ڏهاڪو),
						'other' => q({0} ڏهاڪ),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(ڏهاڪا),
						'one' => q({0} ڏهاڪو),
						'other' => q({0} ڏهاڪ),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(ڪلاڪ),
						'one' => q({0} ڪلاڪ),
						'other' => q({0} ڪلاڪ),
						'per' => q({0} في ڪلاڪ),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(ڪلاڪ),
						'one' => q({0} ڪلاڪ),
						'other' => q({0} ڪلاڪ),
						'per' => q({0} في ڪلاڪ),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(مائڪرو سيڪنڊ),
						'one' => q({0} مائڪرو سيڪنڊ),
						'other' => q({0} مائڪرو سيڪنڊ),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(مائڪرو سيڪنڊ),
						'one' => q({0} مائڪرو سيڪنڊ),
						'other' => q({0} مائڪرو سيڪنڊ),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(ملي سيڪنڊ),
						'one' => q({0} ملي سيڪنڊ),
						'other' => q({0} ملي سيڪنڊ),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(ملي سيڪنڊ),
						'one' => q({0} ملي سيڪنڊ),
						'other' => q({0} ملي سيڪنڊ),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(منٽ),
						'one' => q({0} منٽ),
						'other' => q({0} منٽ),
						'per' => q({0} في منٽ),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(منٽ),
						'one' => q({0} منٽ),
						'other' => q({0} منٽ),
						'per' => q({0} في منٽ),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(مهينا),
						'one' => q({0} مهينو),
						'other' => q({0} مهينا),
						'per' => q({0}/مهينو),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(مهينا),
						'one' => q({0} مهينو),
						'other' => q({0} مهينا),
						'per' => q({0}/مهينو),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(نينو سيڪنڊ),
						'one' => q({0} نينو سيڪنڊ),
						'other' => q({0} نينو سيڪنڊ),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(نينو سيڪنڊ),
						'one' => q({0} نينو سيڪنڊ),
						'other' => q({0} نينو سيڪنڊ),
					},
					# Long Unit Identifier
					'duration-night' => {
						'name' => q(راتيون),
						'one' => q({0} رات),
						'other' => q({0} راتيون),
						'per' => q({0}/رات),
					},
					# Core Unit Identifier
					'night' => {
						'name' => q(راتيون),
						'one' => q({0} رات),
						'other' => q({0} راتيون),
						'per' => q({0}/رات),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(ٽه ماهي),
						'one' => q({0} ٽه ماهيون),
						'other' => q({0} ٽه ماهيون),
						'per' => q({0}/ٽه ماهي),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(ٽه ماهي),
						'one' => q({0} ٽه ماهيون),
						'other' => q({0} ٽه ماهيون),
						'per' => q({0}/ٽه ماهي),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(سيڪنڊ),
						'one' => q({0} سيڪنڊ),
						'other' => q({0} سيڪنڊ),
						'per' => q({0} في سيڪنڊ),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(سيڪنڊ),
						'one' => q({0} سيڪنڊ),
						'other' => q({0} سيڪنڊ),
						'per' => q({0} في سيڪنڊ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(هفتا),
						'one' => q({0} هفتو),
						'other' => q({0} هفتا),
						'per' => q({0}/هفتو),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(هفتا),
						'one' => q({0} هفتو),
						'other' => q({0} هفتا),
						'per' => q({0}/هفتو),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
						'per' => q({0}/س),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
						'per' => q({0}/س),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(ایمپئیر),
						'one' => q({0} ایمپئیر),
						'other' => q({0} ایمپئیر),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(ایمپئیر),
						'one' => q({0} ایمپئیر),
						'other' => q({0} ایمپئیر),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(ملي ايمپئير),
						'one' => q({0} ملي ايمپيئر),
						'other' => q({0} ملي ايمپيئر),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(ملي ايمپئير),
						'one' => q({0} ملي ايمپيئر),
						'other' => q({0} ملي ايمپيئر),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(اوهمس),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(اوهمس),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(وولٽ),
						'one' => q({0} وولٽ),
						'other' => q({0} وولٽ),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(وولٽ),
						'one' => q({0} وولٽ),
						'other' => q({0} وولٽ),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(BTU),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(BTU),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(ڪيلوري),
						'one' => q({0} ڪيلوري),
						'other' => q({0} ڪيلوري),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(ڪيلوري),
						'one' => q({0} ڪيلوري),
						'other' => q({0} ڪيلوري),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(اليڪٽرون وولٽ),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(اليڪٽرون وولٽ),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(ڪيلوري),
						'one' => q({0} ڪيلوري),
						'other' => q({0} ڪيلوري),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(ڪيلوري),
						'one' => q({0} ڪيلوري),
						'other' => q({0} ڪيلوري),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(جول),
						'one' => q({0} جول),
						'other' => q({0} جول),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(جول),
						'one' => q({0} جول),
						'other' => q({0} جول),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(ڪلو ڪيلوريز),
						'one' => q({0} ڪلو ڪيلوريز),
						'other' => q({0} ڪلو ڪيلوريز),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(ڪلو ڪيلوريز),
						'one' => q({0} ڪلو ڪيلوريز),
						'other' => q({0} ڪلو ڪيلوريز),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(ڪلو جول),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(ڪلو جول),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(ڪلو واٽ في ڪلاڪ),
						'one' => q({0} ڪلو واٽ في ڪلڪ),
						'other' => q({0} ڪلو واٽ في ڪلڪ),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(ڪلو واٽ في ڪلاڪ),
						'one' => q({0} ڪلو واٽ في ڪلڪ),
						'other' => q({0} ڪلو واٽ في ڪلڪ),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(US ٿرم),
						'one' => q({0} US ٿرم),
						'other' => q({0} US ٿرمس),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(US ٿرم),
						'one' => q({0} US ٿرم),
						'other' => q({0} US ٿرمس),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(ڪ و آ / 100 ڪ م),
						'one' => q({0} ڪ و آ / 100 ڪ م),
						'other' => q({0} ڪ و آ / 100 ڪ م),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(ڪ و آ / 100 ڪ م),
						'one' => q({0} ڪ و آ / 100 ڪ م),
						'other' => q({0} ڪ و آ / 100 ڪ م),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(نيوٽن),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(نيوٽن),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(پائونڊ-فورس),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(پائونڊ-فورس),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(گيگا هرٽز),
						'one' => q({0} گيگا هرٽز),
						'other' => q({0} گيگا هرٽز),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(گيگا هرٽز),
						'one' => q({0} گيگا هرٽز),
						'other' => q({0} گيگا هرٽز),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(هرٽز),
						'one' => q({0} هرٽز),
						'other' => q({0} هرٽز),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(هرٽز),
						'one' => q({0} هرٽز),
						'other' => q({0} هرٽز),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(ڪلو هرٽز),
						'one' => q({0} ڪلو هرٽز),
						'other' => q({0} ڪلو هرٽز),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(ڪلو هرٽز),
						'one' => q({0} ڪلو هرٽز),
						'other' => q({0} ڪلو هرٽز),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(ميگا هرٽز),
						'one' => q({0} ميگا هرٽز),
						'other' => q({0} ميگا هرٽز),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(ميگا هرٽز),
						'one' => q({0} ميگا هرٽز),
						'other' => q({0} ميگا هرٽز),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(dpcm),
						'one' => q({0} dpcm),
						'other' => q({0} dpcm),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(dpcm),
						'one' => q({0} dpcm),
						'other' => q({0} dpcm),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(dpi),
						'one' => q({0} dpi),
						'other' => q({0} dpi),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(dpi),
						'one' => q({0} dpi),
						'other' => q({0} dpi),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(ميگا پڪسلز),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(ميگا پڪسلز),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(پڪسلز),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(پڪسلز),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(فلڪيات جا يونٽ),
						'one' => q({0} فلڪيات جا يونٽ),
						'other' => q({0} فلڪيات جا يونٽ),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(فلڪيات جا يونٽ),
						'one' => q({0} فلڪيات جا يونٽ),
						'other' => q({0} فلڪيات جا يونٽ),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(سينٽي ميٽر),
						'one' => q({0} سينٽي ميٽر),
						'other' => q({0} سينٽي ميٽر),
						'per' => q({0} في سينٽي ميٽر),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(سينٽي ميٽر),
						'one' => q({0} سينٽي ميٽر),
						'other' => q({0} سينٽي ميٽر),
						'per' => q({0} في سينٽي ميٽر),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(ڊيسي ميٽر),
						'one' => q({0} ڊيسي ميٽر),
						'other' => q({0} ڊيسي ميٽر),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(ڊيسي ميٽر),
						'one' => q({0} ڊيسي ميٽر),
						'other' => q({0} ڊيسي ميٽر),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(فوٽ),
						'one' => q({0} فوٽ),
						'other' => q({0} فوٽ),
						'per' => q({0} في فوٽ),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(فوٽ),
						'one' => q({0} فوٽ),
						'other' => q({0} فوٽ),
						'per' => q({0} في فوٽ),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(انچ),
						'one' => q({0} انچ),
						'other' => q({0} انچ),
						'per' => q({0} في انچ),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(انچ),
						'one' => q({0} انچ),
						'other' => q({0} انچ),
						'per' => q({0} في انچ),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(ڪلوميٽر),
						'one' => q({0} ڪلوميٽر),
						'other' => q({0} ڪلوميٽر),
						'per' => q({0} في ڪلوميٽر),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(ڪلوميٽر),
						'one' => q({0} ڪلوميٽر),
						'other' => q({0} ڪلوميٽر),
						'per' => q({0} في ڪلوميٽر),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(لائيٽ ايئرس),
						'one' => q({0} لائيٽ ايئرس),
						'other' => q({0} لائيٽ ايئرس),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(لائيٽ ايئرس),
						'one' => q({0} لائيٽ ايئرس),
						'other' => q({0} لائيٽ ايئرس),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(ميٽر),
						'one' => q({0} ميٽر),
						'other' => q({0} ميٽر),
						'per' => q({0} في ميٽر),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(ميٽر),
						'one' => q({0} ميٽر),
						'other' => q({0} ميٽر),
						'per' => q({0} في ميٽر),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(مائڪرو ميٽر),
						'one' => q({0} مائڪرو ميٽر),
						'other' => q({0} مائڪرو ميٽر),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(مائڪرو ميٽر),
						'one' => q({0} مائڪرو ميٽر),
						'other' => q({0} مائڪرو ميٽر),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(ميل),
						'one' => q({0} ميل),
						'other' => q({0} ميل),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(ميل),
						'one' => q({0} ميل),
						'other' => q({0} ميل),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(اسڪینڊي نیویائي ميل),
						'one' => q({0} اسڪینڊي نیویائي ميل),
						'other' => q({0} اسڪینڊي نیویائي ميل),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(اسڪینڊي نیویائي ميل),
						'one' => q({0} اسڪینڊي نیویائي ميل),
						'other' => q({0} اسڪینڊي نیویائي ميل),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(ملي ميٽر),
						'one' => q({0} ملي ميٽر),
						'other' => q({0} ملي ميٽر),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(ملي ميٽر),
						'one' => q({0} ملي ميٽر),
						'other' => q({0} ملي ميٽر),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(نينو ميٽر),
						'one' => q({0} نينو ميٽر),
						'other' => q({0} نينو ميٽر),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(نينو ميٽر),
						'one' => q({0} نينو ميٽر),
						'other' => q({0} نينو ميٽر),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(سمندري ميل),
						'one' => q({0} سمندري ميل),
						'other' => q({0} سمندري ميل),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(سمندري ميل),
						'one' => q({0} سمندري ميل),
						'other' => q({0} سمندري ميل),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(پارسيڪ),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(پارسيڪ),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(پيڪو ميٽر),
						'one' => q({0} پيڪو ميٽر),
						'other' => q({0} پيڪو ميٽر),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(پيڪو ميٽر),
						'one' => q({0} پيڪو ميٽر),
						'other' => q({0} پيڪو ميٽر),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(پوائينٽون),
						'one' => q({0} پوائينٽون),
						'other' => q({0} پوائينٽون),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(پوائينٽون),
						'one' => q({0} پوائينٽون),
						'other' => q({0} پوائينٽون),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(سولر راڊي),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(سولر راڊي),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(گز),
						'one' => q({0} گز),
						'other' => q({0} گز),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(گز),
						'one' => q({0} گز),
						'other' => q({0} گز),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(لڪس),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(لڪس),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(سولر ليومينوسائيٽيز),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(سولر ليومينوسائيٽيز),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(ڪيرٽ),
						'one' => q({0} ڪيرٽ),
						'other' => q({0} ڪيرٽ),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(ڪيرٽ),
						'one' => q({0} ڪيرٽ),
						'other' => q({0} ڪيرٽ),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(ڊالٽنز),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(ڊالٽنز),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(ارٿ ماسز),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(ارٿ ماسز),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(گرين),
						'one' => q({0} گرين),
						'other' => q({0} گرين),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(گرين),
						'one' => q({0} گرين),
						'other' => q({0} گرين),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(گرامَ),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(گرامَ),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(ڪلو گرام),
						'one' => q({0} ڪلو گرام),
						'other' => q({0} kg),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(ڪلو گرام),
						'one' => q({0} ڪلو گرام),
						'other' => q({0} kg),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(اونس),
						'one' => q({0} اونس),
						'other' => q({0} اونس),
						'per' => q({0} في اونس),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(اونس),
						'one' => q({0} اونس),
						'other' => q({0} اونس),
						'per' => q({0} في اونس),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(ٽرائي اونس),
						'one' => q({0} ٽرائي اونس),
						'other' => q({0} ٽرائي اونس),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(ٽرائي اونس),
						'one' => q({0} ٽرائي اونس),
						'other' => q({0} ٽرائي اونس),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(پائونڊ),
						'one' => q({0} پائونڊ),
						'other' => q({0} پائونڊ),
						'per' => q({0} في پائونڊ),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(پائونڊ),
						'one' => q({0} پائونڊ),
						'other' => q({0} پائونڊ),
						'per' => q({0} في پائونڊ),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(سولر ماسز),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(سولر ماسز),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(ٽن),
						'one' => q({0} ٽن),
						'other' => q({0} ٽن),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(ٽن),
						'one' => q({0} ٽن),
						'other' => q({0} ٽن),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(گيگا واٽ),
						'one' => q({0} گيگا واٽ),
						'other' => q({0} گيگا واٽ),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(گيگا واٽ),
						'one' => q({0} گيگا واٽ),
						'other' => q({0} گيگا واٽ),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(هارس پاور),
						'one' => q({0} هارس پاور),
						'other' => q({0} هارس پاور),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(هارس پاور),
						'one' => q({0} هارس پاور),
						'other' => q({0} هارس پاور),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(ڪلو واٽ),
						'one' => q({0} ڪلو واٽ),
						'other' => q({0} ڪلو واٽ),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(ڪلو واٽ),
						'one' => q({0} ڪلو واٽ),
						'other' => q({0} ڪلو واٽ),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(ميگا واٽ),
						'one' => q({0} ميگا واٽ),
						'other' => q({0} ميگا واٽ),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(ميگا واٽ),
						'one' => q({0} ميگا واٽ),
						'other' => q({0} ميگا واٽ),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(ملي واٽ),
						'one' => q({0} ملي واٽ),
						'other' => q({0} ملي واٽ),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(ملي واٽ),
						'one' => q({0} ملي واٽ),
						'other' => q({0} ملي واٽ),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(واٽز),
						'one' => q({0} واٽ),
						'other' => q({0} واٽ),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(واٽز),
						'one' => q({0} واٽ),
						'other' => q({0} واٽ),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(بار),
						'one' => q({0} بار),
						'other' => q({0} بارس),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(بار),
						'one' => q({0} بار),
						'other' => q({0} بارس),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'one' => q({0} mmHg),
						'other' => q({0} mm Hg),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'one' => q({0} mmHg),
						'other' => q({0} mm Hg),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(ڪلوميٽر في ڪلاڪ),
						'one' => q({0} ڪلوميٽر في ڪلاڪ),
						'other' => q({0} ڪلوميٽر في ڪلاڪ),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(ڪلوميٽر في ڪلاڪ),
						'one' => q({0} ڪلوميٽر في ڪلاڪ),
						'other' => q({0} ڪلوميٽر في ڪلاڪ),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(ناٽ),
						'one' => q({0} ناٽ),
						'other' => q({0} ناٽ),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(ناٽ),
						'one' => q({0} ناٽ),
						'other' => q({0} ناٽ),
					},
					# Long Unit Identifier
					'speed-light-speed' => {
						'name' => q(نوري),
						'one' => q({0} نوري),
						'other' => q({0} نوري),
					},
					# Core Unit Identifier
					'light-speed' => {
						'name' => q(نوري),
						'one' => q({0} نوري),
						'other' => q({0} نوري),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(ميٽر في سيڪنڊ),
						'one' => q({0} ميٽر في سيڪنڊ),
						'other' => q({0} ميٽر في سيڪنڊ),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(ميٽر في سيڪنڊ),
						'one' => q({0} ميٽر في سيڪنڊ),
						'other' => q({0} ميٽر في سيڪنڊ),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(ميل في ڪلاڪ),
						'one' => q({0} ميل في ڪلاڪ),
						'other' => q({0} ميل في ڪلاڪ),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(ميل في ڪلاڪ),
						'one' => q({0} ميل في ڪلاڪ),
						'other' => q({0} ميل في ڪلاڪ),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(ايڪڙ فٽ),
						'one' => q({0} ايڪڙ فٽ),
						'other' => q({0} ايڪڙ فٽ),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(ايڪڙ فٽ),
						'one' => q({0} ايڪڙ فٽ),
						'other' => q({0} ايڪڙ فٽ),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(بيريل),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(بيريل),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(سينٽي ليٽر),
						'one' => q({0} سينٽي ليٽر),
						'other' => q({0} سينٽي ليٽر),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(سينٽي ليٽر),
						'one' => q({0} سينٽي ليٽر),
						'other' => q({0} سينٽي ليٽر),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(ڪيوبڪ سينٽي ميٽر),
						'one' => q({0} ڪيوبڪ سينٽي ميٽر),
						'other' => q({0} ڪيوبڪ سينٽي ميٽر),
						'per' => q({0} في ڪيوبڪ سينٽي ميٽر),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(ڪيوبڪ سينٽي ميٽر),
						'one' => q({0} ڪيوبڪ سينٽي ميٽر),
						'other' => q({0} ڪيوبڪ سينٽي ميٽر),
						'per' => q({0} في ڪيوبڪ سينٽي ميٽر),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(ڪيوبڪ فٽ),
						'one' => q({0} ڪيوبڪ فٽ),
						'other' => q({0} ڪيوبڪ فٽ),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(ڪيوبڪ فٽ),
						'one' => q({0} ڪيوبڪ فٽ),
						'other' => q({0} ڪيوبڪ فٽ),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(ڪيوبڪ انچ),
						'one' => q({0} ڪيوبڪ انچ),
						'other' => q({0} ڪيوبڪ انچ),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(ڪيوبڪ انچ),
						'one' => q({0} ڪيوبڪ انچ),
						'other' => q({0} ڪيوبڪ انچ),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(ڪيوبڪ ڪلوميٽر),
						'one' => q({0} ڪيوبڪ ڪلوميٽر),
						'other' => q({0} ڪيوبڪ ڪلوميٽر),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(ڪيوبڪ ڪلوميٽر),
						'one' => q({0} ڪيوبڪ ڪلوميٽر),
						'other' => q({0} ڪيوبڪ ڪلوميٽر),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(ڪيوبڪ ميٽر),
						'one' => q({0} ڪيوبڪ ميٽر),
						'other' => q({0} ڪيوبڪ ميٽر),
						'per' => q({0} في ڪيوبڪ ميٽر),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(ڪيوبڪ ميٽر),
						'one' => q({0} ڪيوبڪ ميٽر),
						'other' => q({0} ڪيوبڪ ميٽر),
						'per' => q({0} في ڪيوبڪ ميٽر),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(ڪيوبڪ ميل),
						'one' => q({0} ڪيوبڪ ميل),
						'other' => q({0} ڪيوبڪ ميل),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(ڪيوبڪ ميل),
						'one' => q({0} ڪيوبڪ ميل),
						'other' => q({0} ڪيوبڪ ميل),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(ڪيوبڪ يارڊ),
						'one' => q({0} ڪيوبڪ يارڊ),
						'other' => q({0} ڪيوبڪ يارڊ),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(ڪيوبڪ يارڊ),
						'one' => q({0} ڪيوبڪ يارڊ),
						'other' => q({0} ڪيوبڪ يارڊ),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(ڪپ ماپو),
						'one' => q({0} ڪپ ماپو),
						'other' => q({0} ڪپ ماپو),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(ڪپ ماپو),
						'one' => q({0} ڪپ ماپو),
						'other' => q({0} ڪپ ماپو),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(ميٽرڪ ڪپ),
						'one' => q({0} ميٽرڪ ڪپ),
						'other' => q({0} ميٽرڪ ڪپ),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(ميٽرڪ ڪپ),
						'one' => q({0} ميٽرڪ ڪپ),
						'other' => q({0} ميٽرڪ ڪپ),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(ڊيسي ليٽر),
						'one' => q({0} ڊيسي ليٽر),
						'other' => q({0} ڊيسي ليٽر),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(ڊيسي ليٽر),
						'one' => q({0} ڊيسي ليٽر),
						'other' => q({0} ڊيسي ليٽر),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(پاڻياٺ اونس),
						'one' => q({0} پاڻياٺ اونس),
						'other' => q({0} پاڻياٺ اونس),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(پاڻياٺ اونس),
						'one' => q({0} پاڻياٺ اونس),
						'other' => q({0} پاڻياٺ اونس),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(گيلن),
						'one' => q({0} گيلن),
						'other' => q({0} گيلن),
						'per' => q({0} في گيلن),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(گيلن),
						'one' => q({0} گيلن),
						'other' => q({0} گيلن),
						'per' => q({0} في گيلن),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(امپيريل گيلن),
						'one' => q({0} امپيريل گيلن),
						'other' => q({0} امپيريل گيلن),
						'per' => q({0} في امپيريل گيلن),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(امپيريل گيلن),
						'one' => q({0} امپيريل گيلن),
						'other' => q({0} امپيريل گيلن),
						'per' => q({0} في امپيريل گيلن),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(هيڪٽو ليٽر),
						'one' => q({0} هيڪٽو ليٽر),
						'other' => q({0} هيڪٽو ليٽر),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(هيڪٽو ليٽر),
						'one' => q({0} هيڪٽو ليٽر),
						'other' => q({0} هيڪٽو ليٽر),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(ليٽر),
						'one' => q({0} ليٽر),
						'other' => q({0} ليٽر),
						'per' => q({0} في ليٽر),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(ليٽر),
						'one' => q({0} ليٽر),
						'other' => q({0} ليٽر),
						'per' => q({0} في ليٽر),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(ميگا ليٽر),
						'one' => q({0} ميگا ليٽر),
						'other' => q({0} ميگا ليٽر),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(ميگا ليٽر),
						'one' => q({0} ميگا ليٽر),
						'other' => q({0} ميگا ليٽر),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(ملي ليٽر),
						'one' => q({0} ملي ليٽر),
						'other' => q({0} ملي ليٽر),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(ملي ليٽر),
						'one' => q({0} ملي ليٽر),
						'other' => q({0} ملي ليٽر),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(پنٽ),
						'one' => q({0} پنٽ),
						'other' => q({0} پنٽ),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(پنٽ),
						'one' => q({0} پنٽ),
						'other' => q({0} پنٽ),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(ميٽرڪ پنٽ),
						'one' => q({0} ميٽرڪ پنٽ),
						'other' => q({0} ميٽرڪ پنٽ),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(ميٽرڪ پنٽ),
						'one' => q({0} ميٽرڪ پنٽ),
						'other' => q({0} ميٽرڪ پنٽ),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(چوٿائي گيلن),
						'one' => q({0} چوٿائي گيلن),
						'other' => q({0} چوٿائي گيلن),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(چوٿائي گيلن),
						'one' => q({0} چوٿائي گيلن),
						'other' => q({0} چوٿائي گيلن),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(کاڌي جا چمچا),
						'one' => q({0} کاڌي جا چمچا),
						'other' => q({0} کاڌي جا چمچا),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(کاڌي جا چمچا),
						'one' => q({0} کاڌي جا چمچا),
						'other' => q({0} کاڌي جا چمچا),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(چانهن جا چمچا),
						'one' => q({0} چانهن جا چمچا),
						'other' => q({0} چانهن جا چمچا),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(چانهن جا چمچا),
						'one' => q({0} چانهن جا چمچا),
						'other' => q({0} چانهن جا چمچا),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ها|ها|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:نه|نه|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}، {1}),
				middle => q({0}، {1}),
				end => q({0}، ۽ {1}),
				2 => q({0} ۽ {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'arab',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'arab',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'arab' => {
			'decimal' => q(.),
		},
		'arabext' => {
			'decimal' => q(.),
			'group' => q(،),
		},
		'deva' => {
			'group' => q(،),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'long' => {
				'1000' => {
					'one' => '0 ھزار',
					'other' => '0 ھزار',
				},
				'10000' => {
					'one' => '00 ھزار',
					'other' => '00 هزار',
				},
				'100000' => {
					'one' => '000 هزار',
					'other' => '000 هزار',
				},
				'1000000' => {
					'one' => '0 ملين',
					'other' => '0 ملين',
				},
				'10000000' => {
					'one' => '00 ملين',
					'other' => '00 ملين',
				},
				'100000000' => {
					'one' => '000 ملين',
					'other' => '000 ملين',
				},
				'1000000000' => {
					'one' => '0 بلين',
					'other' => '0 بلين',
				},
				'10000000000' => {
					'one' => '00 بلين',
					'other' => '00 بلين',
				},
				'100000000000' => {
					'one' => '000 بلين',
					'other' => '000 بلين',
				},
				'1000000000000' => {
					'one' => '0 ٽرلين',
					'other' => '0 ٽرلين',
				},
				'10000000000000' => {
					'one' => '00 ٽرلين',
					'other' => '00 ٽرلين',
				},
				'100000000000000' => {
					'one' => '000 ٽرلين',
					'other' => '000 ٽرلين',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 هزار',
					'other' => '0 هزار',
				},
				'10000' => {
					'one' => '00 هزار',
					'other' => '00 هزار',
				},
				'100000' => {
					'one' => '000 هزار',
					'other' => '000 هزار',
				},
				'1000000' => {
					'one' => '0 ملين',
					'other' => '0 ملين',
				},
				'10000000' => {
					'one' => '00 ملين',
					'other' => '00 ملين',
				},
				'100000000' => {
					'one' => '000 ملين',
					'other' => '000 ملين',
				},
				'1000000000' => {
					'one' => '0 بلين',
					'other' => '0 بلين',
				},
				'10000000000' => {
					'one' => '00 بلين',
					'other' => '00 بلين',
				},
				'100000000000' => {
					'one' => '000 بلين',
					'other' => '000 بلين',
				},
				'1000000000000' => {
					'one' => '0 ٽرلين',
					'other' => '0 ٽرلين',
				},
				'10000000000000' => {
					'one' => '00 ٽرلين',
					'other' => '00 ٽرلين',
				},
				'100000000000000' => {
					'one' => '000 ٽرلين',
					'other' => '000 ٽرلين',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'positive' => '¤0هزار',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(گڏيل عرب امارات درهم),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(افغاني افغاني),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(الباني ليڪ),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(ارماني ڊرم),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(نيڌرلينڊ انٽليئن گلڊر),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(انگوليائي ڪوانزا),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(ارجنٽائن پيسو),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(آسٽريلوي ڊالر),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(اروبن فلورن),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(آذربائيجاني منت),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(بوسنيا هرزگوينا ڪنورٽبل مارڪ),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(باربيڊين ڊالر),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(بنگلاديشي ٽڪا),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(بلغارین لیو),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(بحريني دينار),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(برونڊي فرينڪ),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(برمودي ڊالر),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(برونائي ڊالر),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(بولیوین بولیویانو),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(برازيلي ريل),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(بهاماني ڊادلر),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(ڀوٽاني گلٽرم),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(بوستواني پولا),
				'one' => q(بوٽسواني پولا),
				'other' => q(بوستواني پولا),
			},
		},
		'BYN' => {
			symbol => 'р.',
			display_name => {
				'currency' => q(بیلاروسی ربل),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(بيليز ڊالر),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(ڪئينڊيائي ڊالر),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(ڪانگو فرينڪ),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(سوئس فرينڪ),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(چلي پيسو),
			},
		},
		'CNH' => {
			display_name => {
				'currency' => q(چيني يوآن \(غير ملڪي\)),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(چيني يوآن),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(ڪولمبيائي پيسو),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(ڪوسٽا ريڪا ڪولن),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(ڪيوبن ڪنورٽيبل پيسو),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(ڪيوبن پيسو),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(ڪيپ وردي ايسڪوڊو),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(چيڪ ڪرونا),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(جبوتي فرينڪ),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(دانش ڪرون),
				'one' => q(ڊينش ڪرون),
				'other' => q(دانش ڪرون),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(ڊومينيڪن پيسو),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(الجيريائي دينار),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(مصري پائونڊ),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(ايريٽيريائي ناڪفا),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(ايٿوپيائي بر),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(يورو),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(فجي ڊالر),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(فاڪلينڊ ٻيٽ پائونڊ),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(برطانوي پائونڊ),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(جارجيائي لاري),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(گهانين سيدي),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(جبرالٽر پائونڊ),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(گيمبيا دلاسائي),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(گني فرينڪ),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(گوئٽي مالا ڪٽزل),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(گيانا ڊالر),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(هانگ ڪانگ ڊالر),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(هونڊوراس ليمپرا),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(ڪروشيائي ڪونا),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(هيٽي گورڊي),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(هنگيرين فورنٽ),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(انڊونيشيائي رپيه),
				'one' => q(انڊونيشيائي رپيه),
				'other' => q(انڊونيشيائي رپيو),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(اسرائيلي نيو شيڪل),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(انڊين رپي),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(عراقي دينار),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ايراني ريال),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(آئيس لينڊي ڪرونا),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(جميڪائي ڊالر),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(اردني دينار),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(جاپاني يين),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(ڪينيائي سلنگ),
				'one' => q(ڪينيائي شلنگ),
				'other' => q(ڪينيائي سلنگ),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(ڪرغزستاني سوم),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(ڪمبوڊيائي ريال),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(ڪوموريائي فرينڪ),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(اتر ڪوريائي ون),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(ڏکڻ ڪوريائي ون),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(ڪويتي دينار),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(ڪيمين ٻيٽ ڊالر),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(قازقستان ٽينگا),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(لائوشيائي ڪپ),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(لبناني پائونڊ),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(سري لنڪن رپي),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(لائبیریائی ڊالر),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(ليسوٿو لوٽي),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(لبيائي دينار),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(موروڪيائي درهم),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(مالديپ ليو),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(ملاگاسي اریاری),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(ميسي ڊوني دينار),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(ميانمار ڪياٽ),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(منگولي تجرڪ),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(ميڪانيز پٽاڪا),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(موريشيائي اوگوئیا \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(موريشيائي اوگوئیا),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(ماريشيائي رپي),
				'one' => q(ماريشين روپي),
				'other' => q(ماريشيائي رپي),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(مالديپ روفيا),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(ملاوي ڪواچا),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(ميڪسيڪو پيسو),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(ملائيشيائي رنگٽ),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(موزمبيق ميٽيڪل),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(نميبائي ڊالر),
				'one' => q(نميبيائي ڊالر),
				'other' => q(نميبائي ڊالر),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(نائجريائي نائرا),
				'one' => q(نائجيريائي نائرا),
				'other' => q(نائجريائي نائرا),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(نڪارا گوا ڪارڊوبا),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(نارويائي ڪرون),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(نيپالي رپي),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(نيوزي لينڊي ڊالر),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(عماني ريال),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(پاناما پالبوا),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(پيرو سول),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(پاپوا نيو گني ڪنا),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(فلپائني پيسو),
			},
		},
		'PKR' => {
			symbol => 'Rs',
			display_name => {
				'currency' => q(پاڪستاني رپي),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(پولش زلاٽي),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(پيراگوئي گاراني),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(قطري ريال),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(رومانیائي لیو),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(سربيا دينار),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(روسي ربل),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(روانڊا فرينڪ),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(سعودي ريال),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(سولومان ٻيٽ ڊالر),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(سشلي رپي),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(سوڊاني پائونڊ),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(سويڊني ڪرونا),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(سنگاپوري ڊالر),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(سينٽ هيلنا پائونڊ),
			},
		},
		'SLE' => {
			display_name => {
				'currency' => q(سیرا لیونيائي لیون),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(سیرا لیونيائي لیون \(1964—2022\)),
				'one' => q(سیرا لیونيائي لیون \(1964—2022\)),
				'other' => q(سیرا لیونيائي لیون \(1964—2022\)),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(سومالي شلنگ),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(سرينامي ڊالر),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(ڏکڻ سوڊاني پائونڊ),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(سائو ٽوم ۽ پرنسپي دوبرا \(1977–2017\)),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(سائو ٽوم ۽ پرنسپي دوبرا),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(سيريائي پائونڊ),
				'one' => q(شامي پائونڊ),
				'other' => q(سيريائي پائونڊ),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(سوازي للانگيني),
			},
		},
		'THB' => {
			display_name => {
				'currency' => q(ٿائي باهت),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(تاجڪستاني سوموني),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(ترڪمانستان منت),
				'one' => q(ترڪمانستاني منت),
				'other' => q(ترڪمانستان منت),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(تیونس دینار),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(تونگن پانگا),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(ترڪي لرا),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(ٽرينڊيڊ ۽ ٽوباگو ڊالر),
			},
		},
		'TWD' => {
			display_name => {
				'currency' => q(نيو تائيوان ڊالر),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(تنزانيائي شلنگ),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(یوڪرائن هریونیا),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(يگانڊا شلنگ),
			},
		},
		'USD' => {
			display_name => {
				'currency' => q(آمريڪي ڊالر),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(يوروگوئي پيسو),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(ازبڪستاني سوم),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(Venezuelan Bolívar \(2008–2018\)),
				'one' => q(وینزویلا بولیور \(2008–2018\)),
				'other' => q(وینزویلا بولیور \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(وینزویلا بولیور),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(ويٽنامي ڊونگ),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(وانواتو واتو),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(ساموآن ٽالا),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(وچ آفريڪا فرينڪ),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(اوڀر ڪيريبين ڊالر),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(اولهه آفريڪا فرينڪ),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(CFP فرينڪ),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(اڻڄاتل سڪو),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(يمني ريال),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(ڏکڻ آفريقي رانڊ),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(زمبائي ڪواچا),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					wide => {
						nonleap => [
							'جنوري',
							'فيبروري',
							'مارچ',
							'اپريل',
							'مئي',
							'جون',
							'جولاءِ',
							'آگسٽ',
							'سيپٽمبر',
							'آڪٽوبر',
							'نومبر',
							'ڊسمبر'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'J',
							'F',
							'M',
							'A',
							'M',
							'J',
							'J',
							'A',
							'S',
							'O',
							'N',
							'D'
						],
						leap => [
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'چئترا',
							'ويشاخ',
							'جياسٿا',
							'اساڌا',
							'سروانا',
							'ڀدرا',
							'اسوينا',
							'ڪرتيڪا',
							'اگراھيانا',
							'پوزا',
							'ماگھا',
							'ڦلگونا'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'محرم',
							'صفر',
							'ربيع الاول',
							'ربیع الاخر',
							'جمادی الاول',
							'جمادي الاخر',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذوالقعد',
							'ذوالحجہ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'محرم',
							'صفر',
							'ربيع الاول',
							'ربیع الاخر',
							'جمادی الاول',
							'جمادي الاخر',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذوالقعد',
							'ذوالحجہ'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					wide => {
						mon => 'سومر',
						tue => 'اڱارو',
						wed => 'اربع',
						thu => 'خميس',
						fri => 'جمعو',
						sat => 'ڇنڇر',
						sun => 'آچر'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'سو',
						tue => 'اڱارو',
						wed => 'اربع',
						thu => 'خم',
						fri => 'جمعو',
						sat => 'ڇنڇر',
						sun => 'آچر'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'Q1',
						1 => 'Q2',
						2 => 'Q3',
						3 => 'Q5'
					},
					wide => {0 => 'پهرين ٽي ماهي',
						1 => 'ٻين ٽي ماهي',
						2 => 'ٽين ٽي ماهي',
						3 => 'چوٿين ٽي ماهي'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'Q1',
						1 => 'Q2',
						2 => 'Q3',
						3 => 'Q4'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'am' => q{صبح، منجهند},
					'pm' => q{شام، منجهند},
				},
				'narrow' => {
					'am' => q{صبح، منجهند},
					'pm' => q{منجهند، شام},
				},
				'wide' => {
					'am' => q{صبح، منجهند},
					'pm' => q{منجهند، شام},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'am' => q{صبح، منجهند},
					'pm' => q{منجهند، شام},
				},
				'wide' => {
					'am' => q{صبح، منجهند},
					'pm' => q{منجهند، شام},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'BC',
				'1' => 'CD'
			},
			wide => {
				'0' => 'قبل مسيح',
				'1' => 'عيسوي کان پهرين'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'ساڪا'
			},
		},
		'islamic' => {
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{EEEE, MMMM d, y},
			'long' => q{y MMMM d},
			'medium' => q{y MMM d},
			'short' => q{y-MM-dd},
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			GyMd => q{M/d/y GGGGG},
		},
		'gregorian' => {
			GyMd => q{M/d/y G},
			MMMMW => q{ھفتو W جو MMMM},
			yw => q{ھفتو w جو Y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => {
				h => q{h – h B},
			},
			Bhm => {
				h => q{h:mm – h:mm B},
				m => q{h:mm – h:mm B},
			},
			fallback => '{0} – {1}',
		},
		'gregorian' => {
			Bh => {
				h => q{h – h B},
			},
			Bhm => {
				h => q{h:mm – h:mm B},
				m => q{h:mm – h:mm B},
			},
			Gy => {
				G => q{y G – y G},
				y => q{y – y G},
			},
			GyM => {
				G => q{M/y GGGGG – M/y GGGGG},
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			GyMEd => {
				G => q{E, M/d/y GGGGG – E, M/d/y GGGGG},
				M => q{E, M/d/y – E, M/d/y GGGGG},
				d => q{E, M/d/y – E, M/d/y GGGGG},
				y => q{E, M/d/y – E, M/d/y GGGGG},
			},
			GyMMM => {
				G => q{MMM y G – MMM y G},
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			GyMMMEd => {
				G => q{E, MMM d, y G – E, MMM d, y G},
				M => q{E, MMM d – E, MMM d, y G},
				d => q{E, MMM d – E, MMM d, y G},
				y => q{E, MMM d, y – E, MMM d, y G},
			},
			GyMMMd => {
				G => q{MMM d, y G – MMM d, y G},
				M => q{MMM d – MMM d, y G},
				d => q{MMM d – d, y G},
				y => q{MMM d, y – MMM d, y G},
			},
			GyMd => {
				G => q{M/d/y GGGGG – M/d/y GGGGG},
				M => q{M/d/y – M/d/y GGGGG},
				d => q{M/d/y – M/d/y GGGGG},
				y => q{M/d/y – M/d/y GGGGG},
			},
			fallback => '{0} – {1}',
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		regionFormat => q({0} وقت),
		regionFormat => q({0} ڏينهن جو وقت),
		regionFormat => q({0} معياري وقت),
		'Afghanistan' => {
			long => {
				'standard' => q#افغانستان جو وقت#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#ابي جان#,
		},
		'Africa/Accra' => {
			exemplarCity => q#ايڪرا#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#ايڊيس اببا#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#الجيرز#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#ازمارا#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#باماڪو#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#بنگي#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#بينجال#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#بسائو#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#بلنٽائر#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#برازاويل#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#بوجمبورا#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#قائرا#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#ڪاسابلانڪا#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#سيوٽا#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#ڪوناڪري#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ڊاڪار#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#دارالسلام#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#جبوتي#,
		},
		'Africa/Douala' => {
			exemplarCity => q#دوالا#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#ال ايون#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#فري ٽائون#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#گيبورون#,
		},
		'Africa/Harare' => {
			exemplarCity => q#هراري#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#جوهانسبرگ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#جوبا#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#ڪمپالا#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#خرطوم#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#ڪيگالي#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#ڪنشاسا#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#لاگوس#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#لیبرویلی#,
		},
		'Africa/Lome' => {
			exemplarCity => q#لوم#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#لوانڊا#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#لوبمباشی#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#لوساڪا#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#ملابو#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#ماپوتو#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#ماسيرو#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#مبابين#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#موغادیشو#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#مونروویا#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#نيروبي#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#نجامينا#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#نيامي#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#نواڪشوط#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#آئوگو ڊائوگو#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#پورٽو نوو#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#سائو ٽوم#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ٽرپولي#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#تيونس#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ونڊهوڪ#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#مرڪزي آفريقا جو وقت#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#اوڀر آفريڪا جو وقت#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#ڏکڻ آفريڪا جو معياري وقت#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#اولهه آفريقا جي اونهاري جو وقت#,
				'generic' => q#اولهه آفريقا جو وقت#,
				'standard' => q#اولهه آفريقا جو معياري وقت#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#الاسڪا جي ڏينهن جو وقت#,
				'generic' => q#الاسڪا جو وقت#,
				'standard' => q#الاسڪا جو معياري وقت#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#ايميزون جي اونهاري جو وقت#,
				'generic' => q#ايميزون جو وقت#,
				'standard' => q#ايميزون جو معياري وقت#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#ادڪ#,
		},
		'America/Anchorage' => {
			exemplarCity => q#اينڪريج#,
		},
		'America/Anguilla' => {
			exemplarCity => q#انگويلا#,
		},
		'America/Antigua' => {
			exemplarCity => q#اينٽيگوا#,
		},
		'America/Araguaina' => {
			exemplarCity => q#اراگویانا#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#لا ریئوجا#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ریو گالیگوس#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#سالٽا#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#سان جوآن#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#سان لوئیس#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ٽوڪومين#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#اوشوآئیا#,
		},
		'America/Aruba' => {
			exemplarCity => q#اروبا#,
		},
		'America/Asuncion' => {
			exemplarCity => q#اسانسیون#,
		},
		'America/Bahia' => {
			exemplarCity => q#باحيه#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#باهیا بیندراس#,
		},
		'America/Barbados' => {
			exemplarCity => q#بارباڊوس#,
		},
		'America/Belem' => {
			exemplarCity => q#بیلم#,
		},
		'America/Belize' => {
			exemplarCity => q#بیلیز#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#بلانڪ سبلون#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#بائو وستا#,
		},
		'America/Bogota' => {
			exemplarCity => q#بگوٽا#,
		},
		'America/Boise' => {
			exemplarCity => q#بوئس#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#بيونوس ايئرس#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#ڪيمبرج بي#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#ڪيمپو گرانڊي#,
		},
		'America/Cancun' => {
			exemplarCity => q#ڪانڪون#,
		},
		'America/Caracas' => {
			exemplarCity => q#ڪراڪس#,
		},
		'America/Catamarca' => {
			exemplarCity => q#ڪيٽا مارڪا#,
		},
		'America/Cayenne' => {
			exemplarCity => q#ڪائين#,
		},
		'America/Cayman' => {
			exemplarCity => q#سيامن#,
		},
		'America/Chicago' => {
			exemplarCity => q#شڪاگو#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#چي هوا هوا#,
		},
		'America/Ciudad_Juarez' => {
			exemplarCity => q#سوڊيڊ جوريز#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#اٽيڪوڪن#,
		},
		'America/Cordoba' => {
			exemplarCity => q#ڪارڊوبا#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#ڪوسٽا ريڪا#,
		},
		'America/Creston' => {
			exemplarCity => q#ڪريسٽن#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#ڪوئيابا#,
		},
		'America/Curacao' => {
			exemplarCity => q#ڪيوراسائو#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ڊينمارڪ شون#,
		},
		'America/Dawson' => {
			exemplarCity => q#ڊاوسن#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ڊاوسن ڪريڪ#,
		},
		'America/Denver' => {
			exemplarCity => q#ڊينور#,
		},
		'America/Detroit' => {
			exemplarCity => q#ڊيٽرائيٽ#,
		},
		'America/Dominica' => {
			exemplarCity => q#ڊومينيڪا#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ايڊمونٽن#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ايرونيپ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ايل سلواڊور#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#فورٽ نيلسن#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#فورٽاليزا#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#گليس بي#,
		},
		'America/Godthab' => {
			exemplarCity => q#نيوڪ#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#گوز بي#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#گرانڊ ترڪ#,
		},
		'America/Grenada' => {
			exemplarCity => q#گريناڊا#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#گواڊيلوپ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#گوئٽي مالا#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#گواياڪيل#,
		},
		'America/Guyana' => {
			exemplarCity => q#گيانا#,
		},
		'America/Halifax' => {
			exemplarCity => q#هيلي فيڪس#,
		},
		'America/Havana' => {
			exemplarCity => q#هوانا#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#هرموسلو#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#ناڪس، انڊيانا#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#مرينگو، انڊيانا#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#پيٽرسبرگ، انڊيانا#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ٽيل سٽي، انڊيانا#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ويوي، انڊيانا#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ونسینیز، انڊیانا#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#ويناميڪ، انڊيانا#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#انڊيانا پولس#,
		},
		'America/Inuvik' => {
			exemplarCity => q#انووڪ#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#اڪالوئٽ#,
		},
		'America/Jamaica' => {
			exemplarCity => q#جمائڪا#,
		},
		'America/Jujuy' => {
			exemplarCity => q#ڪوڪوئي#,
		},
		'America/Juneau' => {
			exemplarCity => q#جونئو#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#مونٽيسيلو، ڪينٽڪي#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#ڪرالينڊڪ#,
		},
		'America/La_Paz' => {
			exemplarCity => q#لا پز#,
		},
		'America/Lima' => {
			exemplarCity => q#ليما#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#لاس اينجلس#,
		},
		'America/Louisville' => {
			exemplarCity => q#لوئي ويل#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#لوئر پرنسز ڪوارٽر#,
		},
		'America/Maceio' => {
			exemplarCity => q#میسیئو#,
		},
		'America/Managua' => {
			exemplarCity => q#ماناگوا#,
		},
		'America/Manaus' => {
			exemplarCity => q#منائوس#,
		},
		'America/Marigot' => {
			exemplarCity => q#ميريگوٽ#,
		},
		'America/Martinique' => {
			exemplarCity => q#مارٽينڪ#,
		},
		'America/Matamoros' => {
			exemplarCity => q#متاموروس#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#مزاٽلان#,
		},
		'America/Mendoza' => {
			exemplarCity => q#مينڊوزا#,
		},
		'America/Menominee' => {
			exemplarCity => q#مینومیني#,
		},
		'America/Merida' => {
			exemplarCity => q#ميريڊا#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#ميٽلاڪاٽالا#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#ميڪسيڪو شهر#,
		},
		'America/Miquelon' => {
			exemplarCity => q#میڪوئیلون#,
		},
		'America/Moncton' => {
			exemplarCity => q#مانڪٽن#,
		},
		'America/Monterrey' => {
			exemplarCity => q#مانٽيري#,
		},
		'America/Montevideo' => {
			exemplarCity => q#مونٽي ويڊيو#,
		},
		'America/Montserrat' => {
			exemplarCity => q#مانٽسريٽ#,
		},
		'America/Nassau' => {
			exemplarCity => q#ناسائو#,
		},
		'America/New_York' => {
			exemplarCity => q#نيويارڪ#,
		},
		'America/Nome' => {
			exemplarCity => q#نوم#,
		},
		'America/Noronha' => {
			exemplarCity => q#نورانهيا#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#بيولاه، اتر ڊڪوٽا#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#سينٽر، اتر ڊڪوٽا#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#نيو سيلم، اتر ڊڪوٽا#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#اوڪيناگا#,
		},
		'America/Panama' => {
			exemplarCity => q#پناما#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#پيراميريبو#,
		},
		'America/Phoenix' => {
			exemplarCity => q#فونيڪس#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#پورٽ او پرنس#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#اسپين جو ٻيٽ#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#پورٽو ويلهو#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#پورٽو ريڪو#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#پنٽا اريناس#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#رينڪن انليٽ#,
		},
		'America/Recife' => {
			exemplarCity => q#هيسيفي#,
		},
		'America/Regina' => {
			exemplarCity => q#ریجینا#,
		},
		'America/Resolute' => {
			exemplarCity => q#ريزوليوٽ#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ريو برانڪو#,
		},
		'America/Santarem' => {
			exemplarCity => q#سنٽاريم#,
		},
		'America/Santiago' => {
			exemplarCity => q#سينٽياگو#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#سينٽو ڊومينگو#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#سائو پولو#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#اٽوڪورٽومائٽ#,
		},
		'America/Sitka' => {
			exemplarCity => q#سٽڪا#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#سينٽ برٿليمي#,
		},
		'America/St_Johns' => {
			exemplarCity => q#سينٽ جانز#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#سينٽ ڪٽس#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#سينٽ لوسيا#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#سينٽ ٿامس#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#سينٽ ونسينٽ#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#سوئفٽ ڪرنٽ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ٽيگوسيگلپا#,
		},
		'America/Thule' => {
			exemplarCity => q#ٿولي#,
		},
		'America/Tijuana' => {
			exemplarCity => q#تيجوانا#,
		},
		'America/Toronto' => {
			exemplarCity => q#ٽورنٽو#,
		},
		'America/Tortola' => {
			exemplarCity => q#ٽورٽولا#,
		},
		'America/Vancouver' => {
			exemplarCity => q#وينڪوور#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#وائيٽ هائوس#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#وني پيگ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ياڪوتات#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#مرڪزي ڏينهن جو وقت#,
				'generic' => q#مرڪزي وقت#,
				'standard' => q#مرڪزي معياري وقت#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#مشرقي ڏينهن جو وقت#,
				'generic' => q#مشرقي وقت#,
				'standard' => q#مشرقي معياري وقت#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#پهاڙي ڏينهن جو وقت#,
				'generic' => q#پهاڙي وقت#,
				'standard' => q#پهاڙي معياري وقت#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#پيسيفڪ ڏينهن جو وقت#,
				'generic' => q#پيسيفڪ وقت#,
				'standard' => q#پيسيفڪ معياري وقت#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#ڪيسي#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ڊيوس#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ڊومانٽ درويئل#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#مڪوائري#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#موسن#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#ميڪ مرڊو#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#پامر#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#روڌرا#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#سيووا#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ٽرول#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ووستوڪ#,
		},
		'Apia' => {
			long => {
				'daylight' => q#اپيا جي ڏينهن جو وقت#,
				'generic' => q#اپيا جو وقت#,
				'standard' => q#اپيا جو معياري وقت#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#عربين جي ڏينهن جو وقت#,
				'generic' => q#عربين جو وقت#,
				'standard' => q#عربين جو معياري وقت#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#لانگ ائيربن#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#ارجنٽائن جي اونهاري جو وقت#,
				'generic' => q#ارجنٽينا جو وقت#,
				'standard' => q#ارجنٽائن معياري وقت#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#اولهه ارجنٽينا جي اونهاري جو وقت#,
				'generic' => q#اولهه ارجنٽينا جو وقت#,
				'standard' => q#اولهه ارجنٽينا جو معياري وقت#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#آرمينيا جي اونهاري جو وقت#,
				'generic' => q#آرمينيا جو وقت#,
				'standard' => q#آرمينيا جو معياري وقت#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#عدن#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#الماتي#,
		},
		'Asia/Amman' => {
			exemplarCity => q#امان#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#انيدر#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#اڪٽائو#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#ايڪٽوب#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#آشگاباد#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#آتيرائو#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#بغداد#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#بحرين#,
		},
		'Asia/Baku' => {
			exemplarCity => q#باڪو#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#بئنڪاڪ#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#برنل#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#بيروت#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#بشڪيڪ#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#برونائي#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#ڪلڪتا#,
		},
		'Asia/Chita' => {
			exemplarCity => q#چيتا#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#ڪولمبو#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#دمشق#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ڍاڪا#,
		},
		'Asia/Dili' => {
			exemplarCity => q#دلي#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#دبئي#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#دوشانبي#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#فاماگوستا#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#غزه#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#هيبرون#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#هانگ ڪانگ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#هووڊ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ارڪتسڪ#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#جڪارتا#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#جياپورا#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#يوروشلم#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#ڪابل#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#ڪمچاسڪي#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#ڪراچي#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#کٽمنڊو#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#کندياگا#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ڪريسنويارسڪ#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#ڪوالالمپور#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#کوچنگ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#ڪويت#,
		},
		'Asia/Macau' => {
			exemplarCity => q#مڪائو#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#مگادان#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#ميڪاسر#,
		},
		'Asia/Manila' => {
			exemplarCity => q#منيلا#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#مسقط#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#نيڪوسيا#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#نووڪزنيتسڪ#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#نوواسبئيرسڪ#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#اومسڪ#,
		},
		'Asia/Oral' => {
			exemplarCity => q#زباني#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#فنام پينه#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#پونٽيانڪ#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#شيانگ يانگ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#قطر#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#ڪوٽانسي#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#ڪيزلورڊا#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#رنگون#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#رياض#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#هوچي من#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#شخالين#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#سمرقند#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#سيول#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#شنگهائي#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#سنگاپور#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#سريديڪوليمسڪ#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#تائپي#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#تاشقنت#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#تبليسي#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#تهران#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#ٿمفو#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ٽوڪيو#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#تمسڪ#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#اولان باتر#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#يورمڪي#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#اسٽ نيرا#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#وينٽيان#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ولادووستوڪ#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#ياڪتسڪ#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#یڪاٽرنبرگ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#يريوان#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#ايٽلانٽڪ جي ڏينهن جو وقت#,
				'generic' => q#ايٽلانٽڪ جو وقت#,
				'standard' => q#ايٽلانٽڪ جو معياري وقت#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#ازورز#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#برمودا#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#ڪينري#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#ڪيپ ورڊي#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#فيرو#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#ماڊيرا#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ريڪيوڪ#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#ڏکڻ جورجيا#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#سينٽ هيلينا#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#اسٽينلي#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#ايڊيليڊ#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#برسبين#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#بروڪن هل#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ڊارون#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#يوڪلا#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#هوبارٽ#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#لنڊمين#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#لارڊ هائو#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#ميلبورن#,
		},
		'Australia/Perth' => {
			exemplarCity => q#پرٿ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#سڊني#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#آسٽريليا جو مرڪزي ڏينهن جو وقت#,
				'generic' => q#مرڪزي آسٽريليا جو وقت#,
				'standard' => q#آسٽريليا جو مرڪزي معياري وقت#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#آسٽريليا جو مرڪزي مغربي ڏينهن جو وقت#,
				'generic' => q#آسٽريليا جو مرڪزي مغربي وقت#,
				'standard' => q#آسٽريليا جو مرڪزي مغربي معياري وقت#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#آسٽريليا جو مشرقي ڏينهن جو وقت#,
				'generic' => q#اوڀر آسٽريليا جو وقت#,
				'standard' => q#آسٽريليا جو مشرقي معياري وقت#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#آسٽريليا جو مغربي ڏينهن جو وقت#,
				'generic' => q#مغربي آسٽريليا جو وقت#,
				'standard' => q#آسٽريليا جو مغربي معياري وقت#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#آذربائيجان جي اونهاري جو وقت#,
				'generic' => q#آذربائيجان جو وقت#,
				'standard' => q#آذربائيجان جو معياري وقت#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#ازورز جي اونهاري جو وقت#,
				'generic' => q#ازورز جو وقت#,
				'standard' => q#ازورز جو معياري وقت#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#بنگلاديش جي اونهاري جو وقت#,
				'generic' => q#بنگلاديش جو وقت#,
				'standard' => q#بنگلاديش جو معياري وقت#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#ڀوٽان جو وقت#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#بولويائي وقت#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#براسيليا جي اونهاري جو وقت#,
				'generic' => q#بريسيليائي وقت#,
				'standard' => q#براسيليا جو معياري وقت#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#برونائي دارالسلام جو وقت#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#ڪيپ ورڊ جي اونهاري جو وقت#,
				'generic' => q#ڪيپ ورڊ جو وقت#,
				'standard' => q#ڪيپ ورڊ جو معياري وقت#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#چمورو جو معياري وقت#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#چئٿم جي ڏينهن جو وقت#,
				'generic' => q#چئٿم جو وقت#,
				'standard' => q#چئٿم جو معياري وقت#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#چلي جي اونهاري جو وقت#,
				'generic' => q#چلي جو وقت#,
				'standard' => q#چلي جو معياري وقت#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#چائنا جي ڏينهن جو وقت#,
				'generic' => q#چين جو وقت#,
				'standard' => q#چائنا جو معياري وقت#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#ڪرسمس آئي لينڊ جو وقت#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#ڪوڪوس آئي لينڊ جو وقت#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#ڪولمبيا جي اونهاري جو وقت#,
				'generic' => q#ڪولمبيا جو وقت#,
				'standard' => q#ڪولمبيا جو معياري وقت#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#ڪوڪ آئي لينڊ جي اڌ اونهاري جو وقت#,
				'generic' => q#ڪوڪ آئي لينڊ جو وقت#,
				'standard' => q#ڪوڪ آئي لينڊ جو معياري وقت#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#ڪيوبا جي ڏينهن جو وقت#,
				'generic' => q#ڪيوبا جو وقت#,
				'standard' => q#ڪيوبا جو معياري وقت#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#ڊيوس جو وقت#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ڊومانٽ درويئل جو وقت#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#اوڀر تيمور جو وقت#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ايسٽر آئي لينڊ جي اونهاري جو وقت#,
				'generic' => q#ايسٽر آئي لينڊ جو وقت#,
				'standard' => q#ايسٽر آئي لينڊ جو معياري وقت#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ايڪواڊور جو وقت#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#گڏيل دنياوي وقت#,
			},
			short => {
				'standard' => q#م ع و#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#اڻڄاتل شهر#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ايمسٽرڊيم#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#اندورا#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#آستراخان#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ايٿنز#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#بلغراد#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#برلن#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#براتيسلوا#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#برسلز#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#بخاريسٽ#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#بداپيسٽ#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#بزيجين#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#چسينائو#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#ڪوپن هيگن#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ڊبلن#,
			long => {
				'daylight' => q#آئرش جو معياري وقت#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#جبرالٽر#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#گرنزي#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#هيلسنڪي#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#آئيزل آف مين#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#استنبول#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#جرسي#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#ڪلينن گراڊ#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#ڪِيو#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#ڪيروف#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#لسبن#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#لبليانا#,
		},
		'Europe/London' => {
			exemplarCity => q#لنڊن#,
			long => {
				'daylight' => q#برطانيا جي اونهاري جو وقت#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#لگزمبرگ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#ميڊرڊ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#مالٽا#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#ميريهام#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#منسڪ#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#موناڪو#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#ماسڪو#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#اوسلو#,
		},
		'Europe/Paris' => {
			exemplarCity => q#پئرس#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#پوڊگورسيا#,
		},
		'Europe/Prague' => {
			exemplarCity => q#پراگ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#رگا#,
		},
		'Europe/Rome' => {
			exemplarCity => q#روم#,
		},
		'Europe/Samara' => {
			exemplarCity => q#سمارا#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#سين مرينو#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#سراجیوو#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#سراتو#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#سمفروپول#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#اسڪوپي#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#سوفيا#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#اسٽاڪ هوم#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ٽالن#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#تراني#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#اليانوسڪ#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#وڊوز#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#وئٽيڪن#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#وينا#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ويلنيس#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#وولگوگراد#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#وارسا#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#زغرب#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#زيورخ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#مرڪزي يورپي اونهاري جو وقت#,
				'generic' => q#مرڪزي يورپي وقت#,
				'standard' => q#مرڪزي يورپي معياري وقت#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#مشرقي يورپي اونهاري جو وقت#,
				'generic' => q#مشرقي يورپي وقت#,
				'standard' => q#مشرقي يورپي معياري وقت#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#وڌيڪ مشرقي يورپي وقت#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#اولهه يورپي ڏينهن جو وقت#,
				'generic' => q#اولهه يورپي وقت#,
				'standard' => q#اولهه يورپي معياري وقت#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#فاڪ لينڊ آئي لينڊ جي اونهاري جو وقت#,
				'generic' => q#فاڪ لينڊ آئي لينڊ جو وقت#,
				'standard' => q#فاڪ لينڊ آئي لينڊ جو معياري وقت#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#فجي جي اونهاري جو وقت#,
				'generic' => q#فجي جو وقت#,
				'standard' => q#فجي جو معياري وقت#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#فرانسيسي گيانا جو وقت#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#فرانسيسي ڏاکڻيو ۽ انٽارڪٽڪ وقت#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#گرين وچ مين ٽائيم#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#گالاپاگوز جو وقت#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#گيمبيئر جو وقت#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#جارجيا جي اونهاري جو وقت#,
				'generic' => q#جارجيا جو وقت#,
				'standard' => q#جارجيا جو معياري وقت#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#گلبرٽ آئي لينڊ جو وقت#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#مشرقي گرين لينڊ جي اونهاري جو وقت#,
				'generic' => q#مشرقي گرين لينڊ جو وقت#,
				'standard' => q#مشرقي گرين لينڊ جو معياري وقت#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#مغربي گرين لينڊ جي اونهاري جو وقت#,
				'generic' => q#مغربي گرين لينڊ جو وقت#,
				'standard' => q#مغربي گرين لينڊ جو معياري وقت#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#خليجي معياري وقت#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#گيانائي وقت#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#هوائي اليوٽين جي ڏينهن جو وقت#,
				'generic' => q#هوائي اليوٽين جو وقت#,
				'standard' => q#هوائي اليوٽين جو معياري وقت#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#هانگ ڪانگ جي اونهاري جو وقت#,
				'generic' => q#هانگ ڪانگ جو وقت#,
				'standard' => q#هانگ ڪانگ جو معياري وقت#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#هووڊ جي اونهاري جو وقت#,
				'generic' => q#هووڊ جو وقت#,
				'standard' => q#هووڊ جو معياري وقت#,
			},
		},
		'India' => {
			long => {
				'standard' => q#ڀارت جو معياري وقت#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#انتاناناريوو#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#چاگوس#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ڪرسمس#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#ڪوڪوس#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#ڪومورو#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#ڪرگيولين#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ماهي#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#مالديپ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#موريشس#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#مياٽي#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ري يونين#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#هند سمنڊ جو وقت#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#انڊو چائنا جو وقت#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#مرڪزي انڊونيشيا جو وقت#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#اوڀر انڊونيشيا جو وقت#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#اولهه انڊونيشيا جو وقت#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ايران جي ڏينهن جو وقت#,
				'generic' => q#ايران جو وقت#,
				'standard' => q#ايران جو معياري وقت#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ارڪتسڪ جي ڏينهن جو وقت#,
				'generic' => q#ارڪتسڪ جو وقت#,
				'standard' => q#ارڪتسڪ جو معياري وقت#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#اسرائيل جي ڏينهن جو وقت#,
				'generic' => q#اسرائيل جو وقت#,
				'standard' => q#اسرائيل جو معياري وقت#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#جاپان جي ڏينهن جو وقت#,
				'generic' => q#جاپان جو وقت#,
				'standard' => q#جاپان جو معياري وقت#,
			},
		},
		'Kazakhstan' => {
			long => {
				'standard' => q#قزاقستان وقت#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#اوڀر قزاقستان جو وقت#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#اولهه قازقستان جو وقت#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#ڪوريا جي ڏينهن جو وقت#,
				'generic' => q#ڪوريا جو وقت#,
				'standard' => q#ڪوريا جو معياري وقت#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#ڪوسرائي جو وقت#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#ڪریسنویارسڪ جي ڏينهن جو وقت#,
				'generic' => q#ڪریسنویارسڪ جو وقت#,
				'standard' => q#ڪریسنویارسڪ جو معياري وقت#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#ڪرغزستان جو وقت#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#لائن آئي لينڊ جو وقت#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#لورڊ هووي جي ڏينهن جو وقت#,
				'generic' => q#لورڊ هووي جو وقت#,
				'standard' => q#لورڊ هووي جو معياري وقت#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#مگادان جي ڏينهن جي وقت#,
				'generic' => q#مگادان جو وقت#,
				'standard' => q#مگادان جو معياري وقت#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#ملائيشيا جو وقت#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#مالديپ جو وقت#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#مرڪيوسس جو وقت#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#مارشل آئي لينڊ جو وقت#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#موريشيس جي اونهاري جو وقت#,
				'generic' => q#موريشيس جو وقت#,
				'standard' => q#موريشيس جو معياري وقت#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#مائوسن جو وقت#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#ميڪسيڪن پيسيفڪ جي ڏينهن جو وقت#,
				'generic' => q#ميڪسيڪن پيسيفڪ وقت#,
				'standard' => q#ميڪسيڪن پيسيفڪ جو معياري وقت#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#اولان باتر جي اونهاري جو وقت#,
				'generic' => q#اولان باتر جو وقت#,
				'standard' => q#اولان باتر جو معياري وقت#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#ماسڪو جي ڏينهن جي وقت#,
				'generic' => q#ماسڪو جو وقت#,
				'standard' => q#ماسڪو جو معياري وقت#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#ميانمار جو وقت#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#نائورو جو وقت#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#نيپال جو وقت#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#نيو ڪيليڊونيا جي اونهاري جو وقت#,
				'generic' => q#نيو ڪيليڊونيا جو وقت#,
				'standard' => q#نيو ڪيليڊونيا جو معياري وقت#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#نيوزيلينڊ جي ڏينهن جو وقت#,
				'generic' => q#نيوزيلينڊ جو وقت#,
				'standard' => q#نيوزيلينڊ جو معياري وقت#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#نيو فائونڊ لينڊ جي ڏينهن جو وقت#,
				'generic' => q#نيو فائونڊ لينڊ جو وقت#,
				'standard' => q#نيو فائونڊ لينڊ جو معياري وقت#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#نيووي جو وقت#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#نار فوڪ آئي لينڊ جي ڏينهن جو وقت#,
				'generic' => q#نار فوڪ آئي لينڊ جو وقت#,
				'standard' => q#نار فوڪ آئي لينڊ جو معياري وقت#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#فرنانڊو دي نورونها جي اونهاري وقت#,
				'generic' => q#فرنانڊو دي نورونها جو وقت#,
				'standard' => q#فرنانڊو دي نورونها جو معياري وقت#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#نوواسبئيرسڪ جي ڏينهن جو وقت#,
				'generic' => q#نوواسبئيرسڪ جو وقت#,
				'standard' => q#نوواسبئيرسڪ جو معياري وقت#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#اومسڪ جي ڏينهن جو وقت#,
				'generic' => q#اومسڪ جو وقت#,
				'standard' => q#اومسڪ جو معياري وقت#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#اپيا#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#آڪلينڊ#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#بوگين ويليا#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#چئٿم#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ايسٽر#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#افاتي#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#اينڊربري#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#فڪائوفو#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#فجي#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#فنافوٽي#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#گالاپاگوز#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#گيمبيئر#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#گواڊل ڪينال#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#گوام#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#هونو لولو#,
		},
		'Pacific/Kanton' => {
			exemplarCity => q#ڪانٽن#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#ڪريٽمٽي#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#ڪوسرائي#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#ڪواجلين#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#مجورو#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#مرڪيوسس#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#مڊوي#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#نائرو#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#نيووي#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#نار فوڪ#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#نائوميا#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#پاگو پاگو#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#پلائو#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#پٽڪيرن#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#پونپیئي#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#پورٽ مورسبي#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#راروٽونگا#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#سيپن#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#تاهٽي#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#تراوا#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ٽونگاٽاپو#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#چيوڪ#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ويڪ#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ويلس#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#پاڪستان جي اونهاري جو وقت#,
				'generic' => q#پاڪستان جو وقت#,
				'standard' => q#پاڪستان جو معياري وقت#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#پلائو جو وقت#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#پاپوا نيو گني جو وقت#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#پيراگوئي جي اونهاري جو وقت#,
				'generic' => q#پيراگوئي جو وقت#,
				'standard' => q#پيراگوئي جو معياري وقت#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#پيرو جي اونهاري جو وقت#,
				'generic' => q#پيرو جو وقت#,
				'standard' => q#پيرو جو معياري وقت#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#فلپائن جي اونهاري جو وقت#,
				'generic' => q#فلپائن جو وقت#,
				'standard' => q#فلپائن جو معياري وقت#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#فونيڪس آئي لينڊ جو وقت#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#سينٽ پيئر ۽ ميڪلون جي ڏينهن جو وقت#,
				'generic' => q#سينٽ پيئر ۽ ميڪلون جو وقت#,
				'standard' => q#سينٽ پيئر ۽ ميڪلون جو معياري وقت#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#پٽڪيرن جو وقت#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#پوناپي جو وقت#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#پيانگ يانگ جو وقت#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#ري يونين جو وقت#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#روٿيرا جو وقت#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#سخالين جي ڏينهن جو وقت#,
				'generic' => q#سخالين جو وقت#,
				'standard' => q#سخالين جو معياري وقت#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#ساموا جي ڏينهن جو وقت#,
				'generic' => q#ساموا جو وقت#,
				'standard' => q#ساموا جو معياري وقت#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#شي شلز جو وقت#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#سنگاپور جو معياري وقت#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#سولومن آئي لينڊ جو وقت#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#ڏکڻ جارجيا جو وقت#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#سوري نام جو وقت#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#سائيوا جو وقت#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#تاهيٽي جو وقت#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#تائپي جي ڏينهن جو وقت#,
				'generic' => q#تائپي جو وقت#,
				'standard' => q#تائپي جو معياري وقت#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#تاجڪستان جو وقت#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#ٽوڪيلائو جو وقت#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#ٽونگا جي اونهاري جو وقت#,
				'generic' => q#ٽونگا جو وقت#,
				'standard' => q#ٽونگا جو معياري وقت#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#چيوڪ جو وقت#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#ترڪمانستان جي اونهاري جو وقت#,
				'generic' => q#ترڪمانستان جو وقت#,
				'standard' => q#ترڪمانستان جو معياري وقت#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#تووالو جو وقت#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#يوروگائي جي اونهاري جو وقت#,
				'generic' => q#يوروگائي جو وقت#,
				'standard' => q#يوروگائي جو معياري وقت#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#ازبڪستان جي اونهاري جو وقت#,
				'generic' => q#ازبڪستان جو وقت#,
				'standard' => q#ازبڪستان جو معياري وقت#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#وانواتو جي ڏينهن جو وقت#,
				'generic' => q#وانواتو جو وقت#,
				'standard' => q#وانواتو جو معياري وقت#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#وينزويلا جو وقت#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#اولادووستوڪ جي ڏينهن جو وقت#,
				'generic' => q#ولادووستوڪ جو وقت#,
				'standard' => q#ولادووستوڪ جو معياري وقت#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#وولگوگراد جي ڏينهن جو وقت#,
				'generic' => q#وولگوگراد جو وقت#,
				'standard' => q#وولگوگراد جو معياري وقت#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#ووسٽوڪ جو وقت#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#ويڪ آئي لينڊ جو وقت#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#ويلس ۽ فتونا جو وقت#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#ياڪتسڪ جي ڏينهن جو وقت#,
				'generic' => q#ياڪتسڪ جو وقت#,
				'standard' => q#ياڪتسڪ جو معياري وقت#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#يڪاٽيرنبرگ جي ڏينهن جو وقت#,
				'generic' => q#يڪاٽيرنبرگ جو وقت#,
				'standard' => q#يڪاٽيرنبرگ جو معياري وقت#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#يڪون جو وقت#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
