package Shipment::UPS::WSDL::TrackInterfaces::TrackService::TrackPort;
$Shipment::UPS::WSDL::TrackInterfaces::TrackService::TrackPort::VERSION = '3.03';
use strict;
use warnings;
use Class::Std::Fast::Storable;
use Scalar::Util qw(blessed);
use base qw(SOAP::WSDL::Client::Base);


# only load if it hasn't been loaded before
require Shipment::UPS::WSDL::TrackTypemaps::TrackService
  if not Shipment::UPS::WSDL::TrackTypemaps::TrackService->can('get_class');


sub START {

    my $proxy_domain = $_[2]->{proxy_domain} || 'wwwcie.ups.com';

    $_[0]->set_proxy('https://' . $proxy_domain . '/webservices/Track')
      if not $_[2]->{proxy};

    $_[0]
      ->set_class_resolver('Shipment::UPS::WSDL::TrackTypemaps::TrackService')
      if not $_[2]->{class_resolver};

    $_[0]->set_prefix($_[2]->{use_prefix}) if exists $_[2]->{use_prefix};
}

sub ProcessTrack {
    my ($self, $body, $header) = @_;
    die "ProcessTrack must be called as object method (\$self is <$self>)"
      if not blessed($self);
    return $self->SUPER::call(
        {   operation => 'ProcessTrack',
            soap_action =>
              'http://onlinetools.ups.com/webservices/TrackBinding/v2.0',
            style => 'document',
            body  => {


                'use'         => 'literal',
                namespace     => 'http://schemas.xmlsoap.org/wsdl/soap/',
                encodingStyle => '',
                parts =>
                  [qw( Shipment::UPS::WSDL::TrackElements::TrackRequest )],
            },
            header => {

                'use'         => 'literal',
                namespace     => 'http://schemas.xmlsoap.org/wsdl/soap/',
                encodingStyle => '',
                parts =>
                  [qw( Shipment::UPS::WSDL::TrackElements::UPSSecurity )],

            },
            headerfault => {

            },
            response => {
                header => {

                },
                body => {


                    'use'         => 'literal',
                    namespace     => 'http://schemas.xmlsoap.org/wsdl/soap/',
                    encodingStyle => '',
                    parts         => [
                        qw( Shipment::UPS::WSDL::TrackElements::TrackResponse )
                    ],
                },
            }
        },
        $body,
        $header
    );
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::UPS::WSDL::TrackInterfaces::TrackService::TrackPort

=head1 VERSION

version 3.03

=head1 SYNOPSIS

 use Shipment::UPS::WSDL::TrackInterfaces::TrackService::TrackPort;
 my $interface = Shipment::UPS::WSDL::TrackInterfaces::TrackService::TrackPort->new();

 my $response;
 $response = $interface->ProcessTrack();

=head1 DESCRIPTION

SOAP Interface for the TrackService web service
located at https://wwwcie.ups.com/webservices/Track.

=head1 NAME

Shipment::UPS::WSDL::TrackInterfaces::TrackService::TrackPort - SOAP Interface for the TrackService Web Service

=head1 SERVICE TrackService

=head2 Port TrackPort

=head1 METHODS

=head2 General methods

=head3 new

Constructor.

All arguments are forwarded to L<SOAP::WSDL::Client|SOAP::WSDL::Client>.

=head2 SOAP Service methods

Method synopsis is displayed with hash refs as parameters.

The commented class names in the method's parameters denote that objects
of the corresponding class can be passed instead of the marked hash ref.

You may pass any combination of objects, hash and list refs to these
methods, as long as you meet the structure.

List items (i.e. multiple occurences) are not displayed in the synopsis.
You may generally pass a list ref of hash refs (or objects) instead of a hash
ref - this may result in invalid XML if used improperly, though. Note that
SOAP::WSDL always expects list references at maximum depth position.

XML attributes are not displayed in this synopsis and cannot be set using
hash refs. See the respective class' documentation for additional information.

=head3 ProcessTrack

Returns a L<Shipment::UPS::WSDL::TrackElements::TrackResponse|Shipment::UPS::WSDL::TrackElements::TrackResponse> object.

 $response = $interface->ProcessTrack( {
    Request =>  { # Shipment::UPS::WSDL::TrackTypes::RequestType
      RequestOption =>  $some_value, # string
      TransactionReference =>  { # Shipment::UPS::WSDL::TrackTypes::TransactionReferenceType
        CustomerContext =>  $some_value, # string
        TransactionIdentifier =>  $some_value, # string
      },
    },
    InquiryNumber =>  $some_value, # string
    TrackingOption =>  $some_value, # string
    CandidateBookmark =>  $some_value, # string
    ShipperAccountInfo =>  { # Shipment::UPS::WSDL::TrackTypes::ShipperAccountInfoType
      PostalCode =>  $some_value, # string
      CountryCode =>  $some_value, # string
    },
  },,
 {
    UsernameToken =>  {
      Username =>  $some_value, # string
      Password =>  $some_value, # string
    },
    ServiceAccessToken =>  {
      AccessLicenseNumber =>  $some_value, # string
    },
  },,
 );

=head1 AUTHOR

Generated by SOAP::WSDL on Tue May  8 13:46:11 2012

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
