#import "MorphView.h"

#import <appkit/Button.h>
#import <appkit/NXImage.h>
#import <dpsclient/dpsclient.h>

#define MORPH_DELAY 2000

@implementation MorphView

- initFrame: (NXRect *) theFrame
{
	[super initFrame: theFrame];
	image0 = [NXImage findImageNamed: "scottInfo"];
	image1 = [NXImage findImageNamed: "otherInfo"];
	return self;
}

- morph : sender
{
float delta;
int n;
id tmpImage;
static BOOL morphingActive = NO;
static id lastSender;

	[self lockFocus];
	for(delta = 0; delta <= 1.0; delta += 0.05)
	{
		[image0 composite:NX_SOVER toPoint: &bounds.origin];
		[image1 dissolve: delta toPoint: &bounds.origin];
		[window flushWindow];
		for(n = 0; n < 100000; n ++);
	}
	[image1 composite:NX_SOVER toPoint: &bounds.origin];
	[window flushWindow];
	[self unlockFocus];
	tmpImage = image0;
	image0 = image1;
	image1 = tmpImage;
	if(morphingActive == NO)
	{
		lastSender = [sender setEnabled: NO];
		[self perform: _cmd with: self 
			afterDelay: MORPH_DELAY cancelPrevious: YES];
		morphingActive = YES;
	}
	else
	{
		morphingActive = NO;
		[lastSender setEnabled: YES];
	}

	return self;
}

- drawSelf:(const NXRect *) rects :(int) rectCount
{
	[image0 composite: NX_SOVER toPoint: &bounds.origin];
	return self;
}

@end
