import { BridgeIDBTransaction } from "./bridge-idb.js";
import { IDBRequest } from "./idbtypes.js";

export function promiseFromRequest(request: IDBRequest): Promise<any> {
  return new Promise((resolve, reject) => {
    request.onsuccess = () => {
      resolve(request.result);
    };
    request.onerror = () => {
      reject(request.error);
    };
  });
}

export function promiseFromTransaction(
  transaction: BridgeIDBTransaction,
): Promise<void> {
  return new Promise<void>((resolve, reject) => {
    transaction.oncomplete = () => {
      resolve();
    };
    transaction.onerror = () => {
      reject();
    };
  });
}