//
// C++ Implementation: lineoutputgenerator
//
// Description:
//
//
// Author: Lorenzo Bettini <bettini@gnu.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "lineoutputgenerator.h"

#include <iomanip>
#include "linenumdigit.h"
#include "my_sstream.h"
#include "maingeneratormap.h"
#include "textgenerator.h"
#include "textstyle.h"

using namespace std;

LineOutputGenerator::LineOutputGenerator(OutputBuffer& buff, ostream& os,
    TextStyle *anch, bool genref, const string &prefix):
  OutputGenerator(buff, os), generate_ref(genref && ! anch->empty()),
  anchor(anch), anchor_line_prefix(prefix), line_num(1)
{
  line_num_generator = generatormap->getGenerator("linenum");
}


LineOutputGenerator::~LineOutputGenerator()
{
}


void LineOutputGenerator::generate_line(const string& line)
{
  generate_line_info();
  ++line_num;
  OutputGenerator::generate_line(line);
}

void LineOutputGenerator::reset()
{
    OutputGenerator::reset();
    line_num = 1;
}

void
LineOutputGenerator::generate_line_info()
{
  ostringstream sout;

  sout << std::setw (line_num_digit) << std::setfill ('0')
        << line_num << ":";

  string line_str = line_num_generator->generateEntire(sout.str().c_str());

  if (generate_ref) {
    ostringstream line_n;
    line_n << anchor_line_prefix << line_num;
    sout.str("");
    sout << anchor->output(line_str, line_n.str());
    line_str = sout.str();
  }

  output_string(line_str + " ");
}
