[= AutoGen5 template -*- Mode: texinfo -*-

texi

##  Documentation template
##
## Time-stamp:        "2011-03-04 12:01:28 bkorb"
## Author:            Bruce Korb <bkorb@gnu.org>
##
##  This file is part of AutoOpts, a companion to AutoGen.
##  AutoOpts is free software.
##  AutoOpts is Copyright (c) 1992-2011 by Bruce Korb - all rights reserved
##
##  AutoOpts is available under any one of two licenses.  The license
##  in use must be one of these two and the choice is under the control
##  of the user of the license.
##
##   The GNU Lesser General Public License, version 3 or later
##      See the files "COPYING.lgplv3" and "COPYING.gplv3"
##
##   The Modified Berkeley Software Distribution License
##      See the file "COPYING.mbsd"
##
##  These files have the following md5sums:
##
##  43b91e8ca915626ed3818ffb1b71248b COPYING.gplv3
##  06a1a2e4760c90ea5e1dad8dfaac4d39 COPYING.lgplv3
##  66a5cedaf62c4b2637025f049f9b826f COPYING.mbsd

=][=

INVOKE initialization                   =][=

FOR concept =]
@cindex [= concept =][=
ENDFOR

=][=
 (out-push-new (string-substitute (out-name) ".texi" ".menu"))

 (ag-fprintf 0 "* %-32s Invoking %s\n"
  (string-append (get "prog-name") " Invocation::")
  (get "prog-name") )

 (out-pop)

=][= ?% explain %s "This program has no explanation.\n" =]
[=
(divert-convert "option-doc-format")

(join "\n\n"
    (if (exist? "prog-descrip")
        (stack  "prog-descrip")
        (if (exist? "prog-man-descrip")
            (stack  "prog-man-descrip")
            (if (exist? "prog-info-descrip")
                (stack  "prog-info-descrip")
                (stack  "detail")
)   )   )   )

=][=(convert-divert)=]

This [=(string-downcase doc-level)=] was generated by @strong{AutoGen},
using the @code{agtexi-cmd} template and the option descriptions for the [=(.
coded-prog-name)=] program.[=

IF (exist? "copyright") =]

This software is released under [=
  CASE copyright.type =][=
   =  gpl =]the GNU General Public License[=
   = lgpl =]the GNU General Public License with Library Extensions[=
   =  bsd =]the Free BSD License[=
   *      =]a specialized copyright license[=
  ESAC =].[=
ENDIF =]

@menu
[=
  ;; @c = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

  (define flag-val-str "")  =][=
  (if (exist? "flag.value")
      (set! flag-val-str (string-append " (-"
            (if (exist? "help-value") (get "help-value") "?") ")")) )

  (ag-fprintf 0 "* %s %-24s %s usage help%s\n"
      down-prog-name "usage::" (get "prog-name") flag-val-str)
  (out-push-new)
  =][=

FOR flag                                =][=

  IF (not (exist? "documentation"))     =][=

 (define opt-name (string-tr! (get "name") "A-Z^_" "a-z--"))
 (sprintf "* %s %-24s %s option" down-prog-name
         (string-append opt-name " ::") opt-name)
  =][= % value " (-%s)" =]
[=ENDIF                                 =][=

ENDFOR flag                             =][=

  (shell (string-append
   "sort <<\\_EOF_ | sed 's/ ::/:: /'\n"
        (out-pop #t) "_EOF_"))          =][=

IF
   (define home-rc-files (exist? "homerc"))
   (define environ-init  (exist? "environrc"))
   (or home-rc-files environ-init)

  =][=
  (sprintf "\n* %s %-24s %s" down-prog-name "option presets::"
           (string-append "presetting/configuring " down-prog-name) )
  =][=

ENDIF                                 =][=

(sprintf "\n* %s %-24s %s" down-prog-name "exit codes::"
         (string-append down-prog-name " exit codes") )

=][=

FOR doc-section                         =][=

(define opt-name (string-capitalize! (get "ds-type")))
(sprintf "\n* %s %-24s %s" down-prog-name (string-append opt-name "::")
         opt-name)                      =][=
 
ENDFOR  doc-section

=][=#
@c = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =]
@end menu

@node [=(. down-prog-name)=] usage
@[=(. sub-level)=] [=prog-name=] usage help[=
     (if (exist? "flag.value") " (-?)") =]
@cindex [=(. down-prog-name)=] usage

This is the automatically generated usage text for [=prog-name=]:

@exampleindent 0
@example
[=
(define help-opt
   (if (exist? "long-opts")      "--help"
   (if (exist? "help-value")     (string-append "-" (get "help-value"))
   (if (exist? "flag.value")     "'-?'"
                                 "help" ))) )

(shellf "PROG=./%1$s

    if [ ! -f ${PROG} ]
    then PROG=./`echo $PROG | tr '[A-Z]' '[a-z]'` ; fi

    if [ ! -f ${PROG} ]
    then PROG=./`echo $PROG | tr x_ x-` ; fi

    if [ ! -f ${PROG} ]
    then if %1$s %2$s > /dev/null 2>&1
         then PROG=%1$s
         else PROG='echo %1$s is unavailable - no'
    fi ; fi

    ${PROG} %2$s 2>&1 | \
        sed -e 's/USAGE:  lt-/USAGE:  /' \
            -e 's/@/@@/g;s/{/@{/g;s/}/@}/g' \
            -e 's/\t/        /g' "

    (get "prog-name") help-opt
)  =]
@end example
@exampleindent 4[=

#  FOR all options, except the `documentation' options, ...  =][=

(define opt-name       "")
(define extra-ct       0)
(define extra-text     "")
(define optname-from "A-Z_^")
(define optname-to   "a-z--")

(if (exist? "preserve-case") (begin
   (set! optname-from "_^")
   (set! optname-to   "--") ))  =][=#

@c = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =][=

FOR flag                        =][=

  IF (not (exist? "documentation")) =][=

    (set! opt-name (string-tr! (get "name") optname-from optname-to))
    (out-push-new (shellf "echo ${tmp_dir}/opt-text-%s" opt-name)) =][=
    INVOKE emit-opt-text        =][=
    (out-pop)                   =][=

  ENDIF documentation exists    =][=

ENDFOR flag                     =][=

`cat ${tmp_dir}/opt-text-*
rm -rf ${tmp_dir}`              =][=#
@c = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =][=

IF
   (define home-rc-files (exist? "homerc"))
   (define environ-init  (exist? "environrc"))
   (or home-rc-files environ-init)

  =]

@node [= (. down-prog-name) =] option presets
@[=(. sub-level)=] presetting/configuring [=prog-name=]

Any option that is not marked as @i{not presettable}
(@pxref{opt-attr no-preset,no preset}) may be preset by loading values from [=
 (if home-rc-files (string-append
     "configuration (\"rc\" or \"ini\") files"
     (if environ-init ", and values from " "") ))
=][=
  IF (. environ-init)
    =]environment variables named @code{[=(. UP-PROG-NAME)=]} and @code{[=
(. UP-PROG-NAME)=]_<OPTION_NAME>}. ``@code{<OPTION_NAME>}'' must be one of
the options listed above in upper case and segmented with underscores.
The @code{[=(. UP-PROG-NAME)=]} variable will be tokenized and parsed like
the command line.  The remaining variables are tested for existence and their
values are treated like option arguments[=
  ENDIF  have environment inits         =].
[=IF (. home-rc-files)                  =]
Configuration files may be in a wide variety of formats.
The basic format is an option name followed by a value (argument) on the
same line.  Values may be separated from the option name with a colon,
equal sign or simply white space.  Values may be continued across multiple
lines by escaping the newline with a backslash.

Multiple programs may also share the same initialization file.
Common options are collected at the top, followed by program specific
segments.  The segments are separated by lines like:
@example
[[=(. UP-PROG-NAME)=]]
@end example
@noindent
or by
@example
<?program [= prog-name =]>
@end example

@noindent
Do not mix these within one configuration file.

Compound values and carefully constructed string values may also be
specified using XML syntax:

@example
<option-name>
   <sub-opt>...&lt;...&gt;...</sub-opt>
</option-name>
@end example

@noindent
yielding an @code{option-name.sub-opt} string value of
@example
"...<...>..."
@end example

@code{Autogen} does not track suboptions.  You simply note that it is a
hierarchicly valued option.  @code{libopts} does provide a means for searching
the associated name/value pair list (@pxref{libopts-optionFindValue}).
[=
  ENDIF home-rc-files                   =][=
ENDIF                                   =][=#
@c = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =]

@node [= (. down-prog-name) =] exit codes
@[=(. sub-level)=] [=prog-name=] exit codes

One of the following exit values will be returned:
@table @samp
@item 0
[=(get "exit-desc[0]" "Successful program execution.")=]
@item 1
[=(get "exit-desc[1]"
 "The operation failed or the command syntax was not valid.")=][=

FOR exit-desc (for-from 2)              =][=
(sprintf "\n@item %d\n%s" (for-index)
 (get (sprintf "exit-desc[%d]" (for-index)))) =][=
ENDFOR exit-desc                        =]
@end table
[=

FOR doc-section                         =][=

(define opt-name (string-capitalize! (get "ds-type")))
(sprintf "\n\n@node %1$s %2$s\n@%3$s %1$s %2$s\n"
         down-prog-name opt-name sub-level)

=][=
 (join "\n\n" (stack "ds-text"))
=][=

ENDFOR  doc-section

@c = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =][=

DEFINE emit-opt-text            =]

@node [= (string-append down-prog-name " " opt-name) =]
@[=(. sub-level)=] [=(. opt-name)=] option[=
          % value " (-%s)" =]
@cindex [=(. down-prog-name)=]-[=(. opt-name)=]

This is the ``[=(string-downcase! (get "descrip"))=]'' option.[=
    (set! extra-ct 0)
    (out-push-new)  =][=

    IF (exist? "min") =]@item
is required to appear on the command line.
[=    (set! extra-ct (+ extra-ct 1)) =][=
    ENDIF=][=

    IF (exist? "max") =]@item
may appear [=
      IF % max (= "%s" "NOLIMIT")
         =]an unlimited number of times[=
      ELSE
         =]up to [=max=] times[=
      ENDIF=].
[=    (set! extra-ct (+ extra-ct 1)) =][=
    ENDIF=][=

    IF (exist? "enabled") =]@item
is enabled by default.
[=    (set! extra-ct (+ extra-ct 1)) =][=
    ENDIF=][=

    IF (exist? "ifdef") =]@item
must be compiled in by defining @code{[=(get "ifdef")
      =]} during the compilation.
[=    (set! extra-ct (+ extra-ct 1)) =][=
    ENDIF =][=

    IF (exist? "ifndef") =]@item
must be compiled in by @strong{un}-defining @code{[=(get "ifndef")
      =]} during the compilation.
[=    (set! extra-ct (+ extra-ct 1)) =][=
    ENDIF=][=

    IF (exist? "no_preset") =]@item
may not be preset with environment variables or configuration (rc/ini) files.
[=    (set! extra-ct (+ extra-ct 1)) =][=
    ENDIF=][=

    IF (exist? "equivalence") =]@item
is a member of the [=equivalence=] class of options.
[=    (set! extra-ct (+ extra-ct 1)) =][=
    ENDIF=][=

    IF (exist? "flags_must") =]@item
must appear in combination with the following options:
[=    FOR flags_must ", " =][=flags_must=][=
      ENDFOR=].
[=    (set! extra-ct (+ extra-ct 1)) =][=
    ENDIF=][=

    IF (exist? "flags_cant") =]@item
must not appear in combination with any of the following options:
[=    FOR flags_cant ", " =][=flags_cant=][=
      ENDFOR=].
[=    (set! extra-ct (+ extra-ct 1)) =][=
    ENDIF=][=

    IF  (~* (get "arg-type") "key|set") =]@item
This option takes a keyword as its argument[=

      CASE arg-type   =][=
      =* key          =][= (set! extra-ct (+ extra-ct 1)) =].
The argument sets an enumeration value that can be tested by comparing[=

      =* set          =][= (set! extra-ct (+ extra-ct 1)) =] list.
Each entry turns on or off membership bits.  These bits can be tested
with bit tests against[=
      ESAC arg-type   =] the option value macro ([=
(string-upcase (string-append
(if (exist? "prefix") (string-append (get "prefix") "_") "")
"OPT_VALUE_" (get "name")  )) =]).
The available keywords are:
@example
[= (shellf "${CLexe:-columns} --spread=1 -W50 <<_EOF_\n%s\n_EOF_"
            (join "\n" (stack "keyword"))  ) =]
@end example
[=

      IF (=* (get "arg-type") "key") =]
or their numeric equivalent.[=
      ENDIF =][=

    ENDIF key/set arg =][=

    IF (> extra-ct 0) =][=
      (set! extra-text (out-pop #t)) =]

This option has some usage constraints.  It:
@itemize @bullet
[=(. extra-text)
=]@end itemize
[=  ELSE  =][=
      (out-pop) =][=
    ENDIF =][=

?% doc "\n%s" "\nThis option has no @samp{doc} documentation." =][=
  IF (exist? "deprecated") =]

@strong{NOTE: THIS OPTION IS DEPRECATED}[=

  ENDIF     =][=

ENDDEF emit-opt-text

@c = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =][=

DEFINE header                          \=]
\input texinfo
@c -*-texinfo-*-
@c %**start of header
@setfilename [= (define sub-level "chapter") file-name =]
@settitle [= (sprintf (if (exist? "package") "%2$s - %1$s" "%s")
             (get "package")  (get "prog-title")) =]
@c %**end of header
@setchapternewpage off
@titlepage
@sp 10
@comment The title is printed in a large font.
@center @titlefont{Sample Title}

@c The following two commands start the copyright page.
@page
@vskip 0pt plus 1filll
[= IF (exist? "copyright") =]

This software is released under [=

  CASE copyright.type
=][=

   =  gpl
=]the GNU General Public License[=

   = lgpl
=]the GNU General Public License with Library Extensions[=

   =  bsd

=]the Free BSD License[=

   *
=]a specialized copyright license[=

  ESAC =].[=

ENDIF

=]
@end titlepage
[=

ENDDEF header

@c = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =][=

DEFINE initialization                   =][=
  (make-tmp-dir)
  (define down-prog-name (string-downcase! (get "prog-name")))
  (define UP-PROG-NAME   (string-upcase!   (get "prog-name")))
  (define doc-level (getenv "LEVEL"))
  (if (not (string? doc-level))
      (set! doc-level "section"))
  (define file-name       (string-append down-prog-name ".texi"))
  (define coded-prog-name (string-append "@code{" down-prog-name "}"))

  (define replace-prog-name (lambda (nm)
     (string-substitute (get nm) down-prog-name coded-prog-name )  ))

  (define was-diverted   #f)
  (define diversion-type "")
  (define cvt-script     "")

  (define divert-convert (lambda (src-type) (begin
     (set! diversion-type (get src-type ""))
     (set! was-diverted
           (not (or (== diversion-type "texi") (== diversion-type ""))))
     (if was-diverted   (begin
         (set! cvt-script
               (find-file (string-append diversion-type "2texi.sh")))
         (if (not (symbol? 'cvt-script))
             (error (sprintf "unknown source format type: %s" diversion-type)) )
         (out-push-new) ))  )))

  (define convert-divert (lambda ()
     (if was-diverted (shell (string-append
         cvt-script "<<\\_EOConversion_\n" (out-pop #t) "\n_EOConversion_\n"
  )) )))
  =][=

  CASE (. doc-level)    =][=
    == document         =][= INVOKE header =][=
    == chapter          =][= (define sub-level "section")       =][=
    == section          =][= (define sub-level "subsection")    =][=
    == subsection       =][= (define sub-level "subsubsection") =][=

    * =][=(error (sprintf "invalid doc level: %s\n" doc-level)) =][=

  ESAC documentation level  =][=

  IF (not (== doc-level "document"))    =][=
       (set! file-name (string-append "invoke-" file-name))
       \=]
@node [= prog-name =] Invocation
@[=(. doc-level)=] Invoking [= prog-name =]
@pindex [= prog-name  =]
@cindex [= prog-title =][=

  ENDIF document component

=]
@ignore
[=

(out-move file-name)
(dne "# " "# ")

=]
@end ignore
[=

ENDDEF initialization

@c agtexi-cmd.tpl ends here             =]
