/* Automatically generated file.  Do not edit directly. */

/* This file is part of The New Aspell
 * Copyright (C) 2001-2002 by Kevin Atkinson under the GNU LGPL
 * license version 2.0 or 2.1.  You should have received a copy of the
 * LGPL license along with this library if you did not you can find it
 * at http://www.gnu.org/.                                              */

#include "convert.hpp"
#include "error.hpp"
#include "language.hpp"
#include "language_types.hpp"
#include "language-c.hpp"
#include "mutable_string.hpp"

namespace aspell {

class CanHaveError;
struct Error;
class Language;

extern "C" Language * to_aspell_language(CanHaveError * obj)
{
  return static_cast<Language *>(obj);
}

extern "C" void delete_aspell_language(Language * ths)
{
  delete ths;
}

extern "C" unsigned int aspell_language_error_number(const Language * ths)
{
  return ths->err_ == 0 ? 0 : 1;
}

extern "C" const char * aspell_language_error_message(const Language * ths)
{
  return ths->err_ ? ths->err_->mesg : "";
}

extern "C" const Error * aspell_language_error(const Language * ths)
{
  return ths->err_;
}

extern "C" CasePattern aspell_language_case_pattern(Language * ths, const char * str, int str_size)
{
  ths->temp_str_0.clear();
  ths->to_internal_->convert(str, str_size, ths->temp_str_0);
  unsigned int s0 = ths->temp_str_0.size();
  return ths->real->case_pattern(MutableString(ths->temp_str_0.mstr(), s0));
}

extern "C" const char * aspell_language_fix_case(Language * ths, CasePattern cs, const char * str, int str_size)
{
  ths->temp_str_0.clear();
  ths->to_internal_->convert(str, str_size, ths->temp_str_0);
  unsigned int s0 = ths->temp_str_0.size();
  const char * s = ths->real->fix_case(cs, MutableString(ths->temp_str_0.mstr(), s0));
  if (s && ths->from_internal_) {
    ths->temp_str_1.clear();
    ths->from_internal_->convert(s,-1,ths->temp_str_1);
    ths->from_internal_->append_null(ths->temp_str_1);
    s = ths->temp_str_1.data();
  }
  return s;
}

extern "C" const char * aspell_language_to_soundslike(Language * ths, const char * str, int str_size)
{
  ths->temp_str_0.clear();
  ths->to_internal_->convert(str, str_size, ths->temp_str_0);
  unsigned int s0 = ths->temp_str_0.size();
  const char * s = ths->real->to_soundslike(MutableString(ths->temp_str_0.mstr(), s0));
  if (s && ths->from_internal_) {
    ths->temp_str_1.clear();
    ths->from_internal_->convert(s,-1,ths->temp_str_1);
    ths->from_internal_->append_null(ths->temp_str_1);
    s = ths->temp_str_1.data();
  }
  return s;
}



}

