// GUIConsView.h : interface of the CGUIConsView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_GUICONSVIEW_H__515B732E_1CF5_11D4_AB58_00400553A81B__INCLUDED_)
#define AFX_GUICONSVIEW_H__515B732E_1CF5_11D4_AB58_00400553A81B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CGUIConsCntrItem;
class CGUIConsDoc;

class CGUIConsView : public CRichEditView
{
	CFont				m_font;

public:
	int	char_size_x, char_size_y,
		win_size_col, win_size_row;

protected: // create from serialization only
	CGUIConsView();
	DECLARE_DYNCREATE(CGUIConsView)

// Attributes
public:
	CGUIConsDoc* GetDocument();

// Operations
public:
    void Put_Char(int c);
    void Put_NChars(int n, char *c);
    void Backd(int n);
    void Forwd(int n);
    void Displ(int n, char *pos);
    void Erase(int n);
    void Displ_Str(char *str);


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CGUIConsView)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void OnInitialUpdate(); // called first time after construct
//	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
public:
	int m_curCaretPos;
	void CheckCaretPos();
    void UpdateCaretPos();
    void ToggleInsert();

    virtual ~CGUIConsView();

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CGUIConsView)
	afx_msg void OnDestroy();
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnEditPaste();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in GUIConsView.cpp
inline CGUIConsDoc* CGUIConsView::GetDocument()
   { return (CGUIConsDoc*)m_pDocument; }
#endif

/*---------------------------------*/
/* Global Variables                */
/*---------------------------------*/

#ifdef GUICONSVIEW_FILE

       CGUIConsView *theView;

#else

extern CGUIConsView *theView;

#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_GUICONSVIEW_H__515B732E_1CF5_11D4_AB58_00400553A81B__INCLUDED_)
