/*
 * checkout.c by Mingqi Deng, July 6, 1989
 *
 *    checks the result of an ftp attempt made by autoftp30.sh (cf. 
 *    ftpget.c) to get a file from a remote host.
 *
 *  Compile:  
 *             cc -o checkout checkout.c
 *  Execute:
 *             checkout f_stdout f_stderr ftp_script f_tmp
 *    where:
 *      f_stdout   :- the standard output file used by ftpget.c
 *      f_stderr   :- the standard error-message file used by ftpget.c
 *      ftp_script :- the ftp command script file created by nextfile(.c)
 *      f_tmp      :- a temporary file for deleting null chars in
 *		      f_stderr and f_stdout, also used as stderr by
 *                    checkout(.c) for most of its error messages.
 *
 *  Exit status:
 *         99  : fatal error, quit this session of autoftp30.sh
 *          0  : finish an attempt, no further attempt should be made
 *		 on this requested file (either file successfully 
 * 		 received, ALARM in autoftp30.sh too small, or a wrong 
 *		 file name)
 *	    2  : a failed attempt that should be retried
 *
 *  Example:   
 *            checkout 1234stdout 1234stderr 1234ftp.script 1234tmp
 *
 *  Note   :
 *     Two constants max_line_length and max_line defined on the
 *     "#define" lines below specify the maximum length of lines in
 *     f_stderr and f_stdout, and the maximum number of lines in them
 *     altogether.In case they are not large enough (your will get a 
 *     message saying so), increase them.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/timeb.h>

#define max_line_length    160
#define max_line           400

char hold[max_line][max_line_length+1];
int  ctr,     /* number of lines in f_stderr and f_stdout */
     letter;  /* number of letters in f_stderr and f_stdout */
FILE *f_tmp;

main(argc, argv)
int argc;
char *argv[];
{
  int flag,ftp_get_file;
  char cmd[80],s[80],s1[80],s2[80],*rfile,*lfile,*sprintf(),*malloc();
  FILE *f_err, *f_out, *f_ftp;
  struct stat *buf;
  time_t tloc,timeofday;

  f_tmp = fopen(argv[4],"w");
  if (argc != 5) {
     fprintf(stderr,"***Usage: checkout stdout stderr ftp_script f_tmp\n");
     exit(99);
  }
  f_out = fopen(argv[1],"r");
  f_err = fopen(argv[2],"r");
  f_ftp = fopen(argv[3],"r");
  if (f_err == NULL || f_out == NULL || f_ftp == NULL) 
     { fprintf(f_tmp,"***File(s) '%s', '%s' or '%s' do not exist\n",
	       argv[1],argv[2],argv[3]);
       exit(99);}

  ctr=0; letter=0;      /* read in the stdout file of the ftp session*/
  while ((ctr<max_line) && (getline(hold[ctr],f_out,f_tmp)!=0)) ctr++;
  if (ctr == max_line) {
     fprintf(f_tmp,"%s\n%s\n%s\n",
      "***Increase the constant 'max_line' on the '#define' line",
      "   in file checkout.c, recompile it, then try again!");
     exit(99);
  }

                        /* read in the stderr file of the ftp session*/
  while ((ctr<max_line) && (getline(hold[ctr],f_err,f_tmp)!=0)) ctr++;
  if (ctr == max_line) {
     fprintf(f_tmp,"%s\n%s\n%s\n",
      "***Increase the constant 'max_line' on the '#define' line",
      "   in file checkout.c, recompile it, then try again!");
     exit(99);
  }
  if (letter==0)     /* empty file: a silent connection, try again */
      { printf("A silent connection, will try again.\n"); exit(2);} 
   
  flag  = detect("unknown host");
  flag  = (flag)? 1: detect("Unknown host");
  if (flag) {
         /* wrong remote host name, quit attempt for this run */
     fprintf(f_tmp,"***host unknown: check RemoteHost in autoftp30.sh!\n"); 
     exit(99);   
  }

           /* get the requested file names from the ftp script file 
		if a 'get' is performed. */
  ftp_get_file=0;
  while( fgets(s,max_line_length,f_ftp) != NULL)
     if (strncmp(s,"get",3) == 0) {
           extract3(s,s1,s1,s2);
           if (s1[0]!='\0') { rfile = s1; }
           else {
	     fprintf(f_tmp,"***Invalid ftp_script file '%s'\n",argv[3]);
     	     exit(99);
           }
	   if (s2[0]!='\0') lfile=s2;
           else             lfile=s1;
	   ftp_get_file=1;
     }

  flag = detect("Invalid use of terminal designator"); 
  flag = (flag)? 1:detect("File not accessible");
  flag = (flag)? 1:detect("File not accessable");
  flag = (flag)? 1:detect("file not found");
  flag = (flag)? 1:detect("File not found");
  flag = (flag)? 1:detect("not found");
  flag = (flag)? 1:detect("No such file");
  flag = (flag)? 1:detect("No such directory");

  if (flag) {
         /* wrong remote file name, quit attempt for this file */
     if (ftp_get_file) 
        fprintf(f_tmp,
		"***Remote file/direcortory %s not found!\n",rfile); 
     else 
        fprintf(f_tmp, "***Remote direcortory not found!\n"); 
     exit(0);    /* abort the current request */
  }
  
  flag = detect("refused");
  flag = (flag)? 1: detect("unreachable");
  flag = (flag)? 1: detect("failed");
  flag = (flag)? 1: detect("Connection timed out");
  flag = (flag)? 1: detect("timed out");
  flag = (flag)? 1: detect("Not connected");
  flag = (flag)? 1: detect("not connected");
  flag = (flag)? 1: detect("not accessable");
  flag = (flag)? 1: detect("not accessible");
  flag = (flag)? 1: detect("not available");
  flag = (flag)? 1: detect("time out");
  flag = (flag)? 1: detect("times out");
 
  if (flag) {		/* a bad connection, try again */
      printf("A bad connection, will try again.\n"); 
			/* remove the incomplete file if it exists */
      sprintf(cmd,"test -f '%s' && rm '%s'",lfile,lfile);
      system(cmd);
      exit(2);   /* try again */
  }

  flag  = detect("Transfer complete");
  flag  = (flag)? 1:detect("received");
  if (flag != 0)  {
      if (ftp_get_file) {
         fprintf(f_tmp,"=======File '%s'\n",rfile);
         fprintf(f_tmp,
		"       successfully received as '%s'.=======\n",lfile);
      } else
         fprintf(f_tmp,"=======Transfer successfully completed.\n");
      exit(0);  /* done for this RemoteFile */
  } else {
      flag = detect("Alarm call");
      if (ftp_get_file==0) {
         printf("   A silented connection. Will try again.\n");
         exit(2);
      }

         /* then check if too large a requested file */
      buf=(struct stat *)malloc(sizeof(struct stat));
      stat(lfile,buf);    /* get GMT time in seconds (from 12/31/1969
				19:00:00) for the file being received 
				since last modification. If the file 
				does not exist, 0 is returned. */
      timeofday = time(&tloc);   /* get current time */
		/* if the file was modified in last 5 minutes*/
      if (timeofday - buf->st_mtime < 300)  {
         if (flag == 0) fprintf(f_tmp, 
		"***I am confused. But most likely the chance is:\n");
         fprintf(f_tmp, "%s\n%s%s%s%s%s\n%s%s%s\n",
          "***'alarm' in autoftp30.sh appears too small for remote file",
          "   '",rfile,"' (to be received as '",lfile,"').",
          "   File '",lfile,"' removed, increase the 'alarm' and try again.");
 		/* remove the incomplete file (it must exist
			   since the difference is < 300)  */
          sprintf(cmd,"rm '%s'",lfile);
          system(cmd);
	  exit(0);   /* abort this request, do not try any more. */
      } else {
         if (flag == 0) 
 	   printf("***I am confused. But most likely the chance is:\n");
         printf("   A silented connection. Will try again.\n");
			/* remove the file if it exists. */
	 sprintf(cmd,"test -f '%s' && rm '%s'",lfile,lfile);
         system(cmd);
	 exit(2);   /* do not abort this request, try again. */
      } 
  } 
}

/* detect(s)
 *   returns 1 if string s is in the file f_err and f_out that have been
 * read into array hold.
 */
detect(s)
char *s;
{
  int i,flag;

  for (i=0; i<ctr && ((flag=substring(hold[i],s))==0); i++);
  return(flag);
}

/* substring:
 *   returns 1 if s2 is a substring of s1, 0 otherwise.
 */
substring(s1,s2)
char *s1,*s2;
{
   int i,l1,l2,found;

   l1 = strlen(s1); 
   l2 = strlen(s2); 
  
   found = 1; 
   for (i=0; i<=l1-l2 && found!=0; i++) 
       found = strncmp(s1+i,s2,l2);

   return(found==0);
}

/* getline(s,fin,fout)
*      reads an input line from file fin, and skips null chars, count 
*  the number of letters in the input file (result kept in global var
*  letter). All non-null characters are written to fout to eliminate
*  numerous annoying null character (inserted by ftp?) that causes very
*  slow scrolling when using MORE of UNIX to display the file fin.
*      return 0 if eof.
*/
getline(s,fin,fout)
char s[];
FILE *fin,*fout;
{
   char c;
   int  i,cc;  /* cc used to avoid machine dependent comparison
                  of getc()'s return value to EOF */

   i = 0; 
   while( ((cc=getc(fin)) != EOF) && i <= max_line_length) {
      c=cc;
      if (c=='\n') 
           { s[i]='\0'; putc(c,fout); return(1); }
      else 
           if (c != '\0') { 
   		putc(c,fout);
                if (c > 64 && c < 91 || c > 96 && c < 123 ) 
		     { letter++; s[i++]=c; }
                else 
		     if (c==' ')  s[i++]=c;
	   }
   }

   if (i>max_line_length) 
       { fprintf(f_tmp,"%s\n%s\n",
           "***'max_line_length' in checkout.c appears too small.",
           "   Please increase it, recompile and try again!");
         exit(99);
       }
  
   s[i] = '\0';
   return(0);
}

/* extract3(s,s0,s1,s2)
*     extracts 3 substring from s to s0, s1 and s2, where 
*   blanks, tabs are delimiters, new line character is ignored. S is 
*   terminated by a null character as usual, so will s0, s1 and s3.
*/
extract3(s,s0,s1,s2)
char s[],s0[],s1[],s2[];
{
   int i,head,tail,ptr,l;

   l = strlen(s); tail=0;
   for (i=0;i<3;i++) {
       ptr=0;
       head=tail;
       while(s[head]==' ' ||  /* skip blanks, tabs and new line */
	     s[head]==9   ||
	     s[head]=='\n') head++;
       tail=head;

       while(tail<l      &&  
	     s[tail]!=' '&&   /* stop if a blank, tab or NL is seen */
	     s[tail]!=9  &&
	     s[tail]!='\n')  
          switch(i) {
              case 0:  s0[ptr++]=s[tail++]; break;
              case 1:  s1[ptr++]=s[tail++]; break;
              case 2:  s2[ptr++]=s[tail++]; break;
          }
        switch(i) {
              case 0:  s0[ptr]='\0'; break;
              case 1:  s1[ptr]='\0'; break;
              case 2:  s2[ptr]='\0'; break;
        }
   }
}

