/*
 *  securelib:  a package to enhance network security.
 *
 *  Written by William LeFebvre, EECS Department, Northwestern University
 *  Internet address:  phil@eecs.nwu.edu
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/syscall.h>
#include <errno.h>

accept(s, addr, addrlen)

int s;
struct sockaddr *addr;
int *addrlen;

{
    register int retval;
    struct sockaddr sa;
    int salen;

    salen = sizeof(sa);
    if ((retval = syscall(SYS_accept, s, &sa, &salen)) >= 0)
    {
	if (_ok_address(retval, &sa, salen))
	{
	    _addrcpy(addr, addrlen, &sa, salen);
	    return (retval);
	}
	close(retval);
	errno = ECONNREFUSED;
	return (-1);
    }
    return (retval);
}

