/*
**	STRPEEL -- isolate delimited "word" and return pointer to next
**	'del'  is delimiter; if 'del'==0, delimiter is chars <= ' '
**	Typical usage:
**		register char *bp, *cp;
**		for (bp = buf; *bp; ) {
**		    bp = strpeel(cp = bp, 0);
**				cp points to <NUL> terminated word
**				bp points to unterminated next word
**		}
**	SPEEL -- return pointer to delimited "word" and set pointer to next
**	'del'  is delimiter; if 'del'==0, delimiter is chars <= ' '
**	Typical usage:
**		register char *cp;
**		char *bp;
**		for (bp = buf; cp = speel(&bp); ) {
**				cp points to <NUL> terminated word
**				bp points to unterminated next word
**		}
**	psl 1/89
*/

char	*
strpeel(sp, del)
char	*sp, del;
{
	for (; del? (*sp && *sp != del) : (*sp > ' '); sp++);
	if (*sp != '\0')	
	    for (*sp++ = '\0'; del? (*sp == del) : (*sp && *sp <= ' '); sp++);
	return(sp);
}

char	*
speel(spp, del)
char	**spp, del;
{
	register char *bp, *sp;

	for (sp = bp = *spp; del? (*sp && *sp != del) : (*sp > ' '); sp++);
	if (*sp != '\0')	
	    for (*sp++ = '\0'; del? (*sp == del) : (*sp && *sp <= ' '); sp++);
	*spp = sp;
	return(bp);
}
