#include <midi.h>

MpuCmd *
SetMpuNote(m, pitch, velocity, offset)
	MpuCmd *m;
	unsigned char pitch, velocity, offset;
/*
** Set 'm' to be a time-tagged MIDI command to play a note 'pitch'
** wth the given 'velocity' at time offset 'offset'.
** The 'pitch' is a number (eg, '60' for 'C4', c above middle c);
** the 'velocity' is in the range '0-100';
** `note:` 'velocity=0' means "note off" to the dx7.
*/
{
	m->time_tag = offset;
	m->mpu_time = (long) offset;
	m->arg_cnt = 2;
	m->cmd_type = m->mpu_cmd[0] = (unsigned char) CH_KEY_ON;
	m->mpu_cmd[1] = pitch;
	m->mpu_cmd[2] = velocity;
	return m;
}

MpuCmd *
MpuNote(pitch, velocity, offset)
	unsigned char pitch, velocity, offset;
/*
** Create and return a new 'MpuCmd' for a note event,
** meaning "play the note 'pitch' with 'velocity' at time 'offset'".
** See also 'SetMpuNote()'.
*/
{
	MpuCmd *m = Alloc(MpuCmd);
	m->mpu_cmd = (unsigned char *)malloc(3*sizeof(unsigned char));
	return SetMpuNote(m, pitch, velocity, offset);
}
