/*
**      SBSD -- Stochastic Binary Subdivision routines
**      psl 10/85
*/
#include        <stdio.h>
#include	<midi.h>

char	*sbsdinit(), *bufdt();

sbsd(sbsdpp, buf, len)
SBSDP	*sbsdpp;
char	*buf;
{
	char *bp;
	int i, note, dir, ninst;
	int laststat, lastnote, offtime;
	int t, lastt;
	INST *inst, *ip;

	inst = sbsdpp->inst;
	ninst = sbsdpp->ninst;
	lastnote = sbsdpp->lastnote;
	for (ip = inst; ip < &inst[ninst]; ip++) {
	    for (t = 0; t < MAXRES; t++)
		ip->pat[t] = 0;
	    divvy(ip, 0, MAXRES);
	}
	bp = buf;
	laststat = offtime = 0;
	for (t = lastt = 0; t < MAXRES; t++) {
	    for (ip = inst; ip < &inst[ninst]; ip++) {
		if (ip->pat[t]) {
		    if (bp - buf > len - 5)
			return(bp - buf);
		    if (ip->inum > 12)      /* absolute key number */
			note = ip->inum;
		    else {                  /* relative key change */
			if (sbsdpp->scaled) {       /* in a scale */
			    dir = ip->inum < 0? -1 : 1;
			    for (i = dir * ip->inum; i > 0; ) {
				note += dir;
				if (sbsdpp->scale[note % 12])
				    --i;
			    }
			} else              /* chromatic */
			    note += ip->inum;
		    }
		    if (note < sbsdpp->lolim || sbsdpp->hilim < note)
			continue;
		    if (offtime > t && note == lastnote) {
			offtime = t + ip->dur;
			continue;
		    }
		    if (laststat) {
			bp = bufdt(t, &lastt, bp);
			*bp++ = laststat;
			*bp++ = lastnote;
			*bp++ = 0x00;
		    }
		    bp = bufdt(t, &lastt, bp);
		    *bp++ = laststat = CH_KEY_ON | ip->chan;
		    *bp++ = lastnote = note;
		    *bp++ = ip->vel;
		    offtime = t + ip->dur;
		    break;
		}
	    }
	    if (offtime <= t && laststat) {
		bp = bufdt(t, &lastt, bp);
		*bp++ = laststat;
		*bp++ = lastnote;
		*bp++ = 0x00;
		laststat = 0;
	    }
	}
	if (laststat) {
	    bp = bufdt(t, &lastt, bp);
	    *bp++ = laststat;
	    *bp++ = lastnote;
	    *bp++ = 0x00;
	}
	bp = bufdt(MAXRES, &lastt, bp);
	*bp++ = MPU_TCWME;
	sbsdpp->lastnote = note;
	return(bp - buf);
}

static	char	*
bufdt(i, lastp, bp)
int	*lastp;
char	*bp;
{
	register int dt;

	dt = (i * 480) / MAXRES - *lastp;
	*lastp += dt;
	while (dt >= 240) {
	    *bp++ = MPU_TCIP;
	    dt -= 240;
	}
	*bp++ = dt;
	return(bp);
}

static
divvy(ip, lo, hi)
INST   *ip;
{
	int mid;

	mid = (lo + hi) >> 1;
	if (!ip->up)
	    ip->pat[lo] = '|';
	if ((rand() % 100) < ip->density && hi - lo > ip->res) {
	    divvy(ip, lo, mid);
	    divvy(ip, mid, hi);
	} else if (ip->up)
	    ip->pat[mid] = '|';
}

char	*
sbsdinit(file, sbsdpp, maxinst)
char    *file;
SBSDP   *sbsdpp;
{
	char buf[512], c[16];
	int i, a, b, d, e, f, g, ninst;
	INST *inst;
	FILE *ifp;

	if ((ifp = fopen(file, "r")) == NULL)
	    return("couldn't open file");
	if (!(inst = sbsdpp->inst))
	    return("INST pointer not initialized");
	for (ninst = 0; fgets(buf, sizeof buf, ifp); ) {
	    if (*buf == '#')				/* comment */
		continue;
	    if (*buf == 'S') {				/* scale */
		if (getscale(buf, sbsdpp))
		    return("Error in Scale line");
		continue;
	    }
	    if (*buf == 'L') {				/* Limits */
		if (getlimits(buf, sbsdpp))
		    return("Error in Limits line");
		continue;
	    }
	    i = sscanf(buf, "%d:%d:%c:%d:%d:%d:%d %*s\n",
	     &a, &b, c, &d, &e, &f, &g);
	    if (i == 7) {
		if (ninst >= maxinst)
		    return("too many instrument lines");
		inst[ninst].inum = a;
		inst[ninst].density = b;
		inst[ninst].up = (*c == 'u' || *c == 'U');
		if (d > MAXRES)
		    return("maximum resolution exceeded");
		inst[ninst].res = MAXRES / d;
		inst[ninst].dur = e;
		inst[ninst].vel = f;
		inst[ninst].chan = g - 1;
		ninst++;
	    }
	}
	fclose(ifp);
	if (!(sbsdpp->ninst = ninst))
	    return("no legal instrument lines found");
	return((char *) 0);
}

static
getscale(buf, sbsdpp)
char    *buf;
SBSDP   *sbsdpp;
{
	register char *cp;

	for (cp = buf; *cp > ' '; cp++);
	while (*cp && *cp <= ' ')
	    cp++;
	while (*cp) {
	    sbsdpp->scale[atoi(cp) % 12] = 1;
	    while (*cp && *cp++ != ',');
	    sbsdpp->scaled = 1;
	}
	return(!sbsdpp->scaled);
}

static
getlimits(buf, sbsdpp)
char    *buf;
SBSDP   *sbsdpp;
{
	register char *cp;
	int l, h;

	for (cp = buf; *cp > ' '; cp++);
	while (*cp && *cp <= ' ')
	    cp++;
	l = atoi(cp);
	while (*cp && *cp++ != ',');
	h = atoi(cp);
	sbsdpp->lolim = l < 0? 0 : l;
	sbsdpp->hilim = h >= 128? 127 : h;
	return(h < 0 || h < l || 128 <= l);
}
