#include <stdio.h>
#include <midi.h>

MidiTranspose(in,out,shift)
	FILE *in, *out;
/*
** Copy the midi data from 'in' and transpose it by 'shift' half steps,
** writing the result in 'out'.
** Example: 'MidiTranspose(in,out,-7)' transposes down a fifth.
*/
{
	MpuCmd m;
	unsigned char *c, k;
	while (GetMpuCmd(in,&m)) {
		c = m.mpu_cmd;
		k = (*c & M_CMD_MASK);
		if (k == CH_KEY_ON || k == CH_KEY_OFF)
			c[1] += (unsigned char) shift;
		PutMpuCmd(out,&m);
	}
}
