/*
**      DDM -- Digital Drum & Melody (using sbsd)
**      psl 1/89
*/
#include        <stdio.h>
#include	<midi.h>

#define MAXINST 64

char	*sbsdinit();

main(argc, argv)
char    *argv[];
{
	char *file, *cp, buf[2048];
	int rpt, olastnote, bars, seed, maxrep, len, debug, mformat;
	SBSDP sbsdp;
	INST inst[MAXINST];

	sbsdp.lolim = 0;
	sbsdp.hilim = 128;
	sbsdp.scaled = 0;
	sbsdp.lastnote = 60;		/* arbitrary */
	sbsdp.inst = inst;
	file = (char *) 0;
	bars = 1;
	mformat = 0;
	maxrep = 2;
	seed = (int) time((long *) 0) + getpid();
	debug = 0;
	while (--argc > 0) {
	    if (argv[argc][0] == '-') {
		switch (argv[argc][1]) {
		case 'b':                       /* set bar count */
		    bars = atoi(&argv[argc][2]);
		    break;
		case 'd':                       /* debug */
		    debug++;
		    break;
		case 'm':                       /* M format */
		    mformat++;
		    break;
		case 'r':                       /* max repeats */
		    maxrep = atoi(&argv[argc][2]);
		    break;
		case 's':                       /* specify rand() seed */
		    seed = atoi(&argv[argc][2]);
		    break;
		default:
		    goto syntax;
		}
	    } else if (!file)
		file = argv[argc];
	    else
		goto syntax;
	}
	if (file == 0) {
syntax:
	    fprintf(stderr,
	     "Usage: %s [-b#] [-debug] [-r#] [-s#] file >midi\n", argv[0]);
	    fprintf(stderr, "-b specifies # of bars to generate (default 1)\n");
	    fprintf(stderr, "-d shows patterns graphically\n");
	    fprintf(stderr, "-m generates m-format output\n");
	    fprintf(stderr, "-r set max # of repeats (default 2)\n");
	    fprintf(stderr, "-s species a seed for rand()\n");
	    fprintf(stderr, "File format is:\n");
	    fprintf(stderr, "key:density:up-beat:res:dur:vel:chan\n");
	    fprintf(stderr, "Instruments appear in priority order.\n");
	    exit(2);
	}
	srand(seed);
	if (debug || mformat)
	    printf("seed is %d\n", seed);
	if (cp = sbsdinit(file, &sbsdp, MAXINST)) {
	    fprintf(stderr, "Error in %s: %s\n", file, cp);
	    exit(1);
	}
	for (rpt = 0; bars != 0; --bars) {
	    if (--rpt < 0) {
		olastnote = sbsdp.lastnote;	/* save for display() */
		len = sbsd(&sbsdp, buf, sizeof buf);
		rpt = (rand() / 3) % maxrep;
	    }
	    if (debug) {
		sbsdp.lastnote = olastnote;
		display(&sbsdp);
	    } else if (mformat) {
		sbsdp.lastnote = olastnote;
		mdisplay(&sbsdp);
	    } else
		write(1, buf, len);
	}
	exit(0);
}

display(sbsdpp)
SBSDP	*sbsdpp;
{
	char buf[MAXRES+1];
	int t, ninst;
	INST *inst, *ip;

	inst = sbsdpp->inst;
	ninst = sbsdpp->ninst;
	buf[MAXRES] = '\0';
	printf("\n");
	for (ip = inst; ip < &inst[ninst]; ip++) {
	    for (t = 0; t < MAXRES; t++)
		buf[t] = ip->pat[t]? '|' : '.';
	    printf("%02x: %s\n", ip->inum, buf);
	}
}

mdisplay(sbsdpp)
SBSDP	*sbsdpp;
{
	int t, playing, playstart, playend, note, i, dir, ninst;
	INST *inst, *ip;
	extern char *notename(), *notedur();

	printf("#TITLE\tSBSD\n");
	printf("#METER\t4 4\n");
	printf("#TEMPO\t100\n");
	printf("#VOICES\tSOLO\n");
	printf("#CHAN\t1\n");
	note = sbsdpp->lastnote;
	playing = playstart = 0;
	inst = sbsdpp->inst;
	ninst = sbsdpp->ninst;
	for (t = 0; t < MAXRES; t++) {
	    if (playing && t >= playend) {
		printf("x\t%s%s\n", key2name(playing), notedur(t - playstart));
		playing = 0;
		playstart = t;
	    }
	    if (t % 64 == 0)
		printf("#BAR\n");
	    for (ip = inst; ip < &inst[ninst]; ip++) {
		if (ip->pat[t]) {
		    if (ip->inum > 12)  /* absolute key number */
			note = ip->inum;
		    else {                      /* relative key change */
			if (sbsdpp->scaled) {   /* in a scale */
			    dir = ip->inum < 0? -1 : 1;
			    for (i = dir * ip->inum; i > 0; ) {
				note += dir;
				if (sbsdpp->scale[note % 12])
				    --i;
			    }
			} else          /* chromatic */
			    note += ip->inum;
		    }
		    if (note < sbsdpp->lolim || sbsdpp->hilim < note)
			continue;
		    if (playstart != t)
			printf("x\t%s%s\n",
			 key2name(playing), notedur(t - playstart));
		    playstart = t;
		    playing = note;
		    playend = t + (ip->dur ? ip->dur : 64);
		    break;
		}
	    }
	}
	printf("x\t%s%s\n", key2name(playing), notedur(t - playstart));
	printf("#BAR\n");
	sbsdpp->lastnote = note;
}

char    *
notedur(t)
{
	register int i, v;
	static char buf[8];
	register char *cp = buf;

	v = 64;
	for (i = 0; v > t && i < 6; v >>= 1, i++);
	*cp++ = "whqestf"[i];
	for (i = 0; (t -= v) > 0 && i < 4; v >>= 1, i++);
	while (--i >= 0)
	    *cp++ = '.';
	*cp = '\0';
	return(buf);
}
