/*
** COUNTIN -- Trim off count-in bars cleverly.
** Copy MIDI data from the standard input to the standard output,
** trimming off whole measures of blank time and collecting the notes and
** other misc in partially blank measures - depositing it at the start
** of the first measure allowed through.
*/
#include <stdio.h>
#include <midi.h>

#define	IS_KEY_OFF(P)	(((P)->cmd[0]&M_CMD_MASK)==CH_KEY_OFF)
#define	IS_KEY_ON(P)	(((P)->cmd[0]&M_CMD_MASK)==CH_KEY_ON)
#define	IS_KEY(P)	(IS_KEY_ON(P)||IS_KEY_OFF(P))

main(argc, argv)
char *argv[];
{
	int i, bars = 0, files = 0, cpb = 2 * MPU_CLOCK_PERIOD;
	FILE *ifp;

	for (i = 1; i < argc; i++) {
	    if (argv[i][0] == '-') {
		switch (argv[i][1]) {
		case 'B':
		    cpb = atoi(&argv[i][2]);
		    break;
		case 'b':
		    bars = atoi(&argv[i][2]);
		    break;
		default:
		    goto syntax;
		}
	    } else if (ifp = fopen(argv[i], "r")) {
		countin(bars, cpb, ifp);
		fclose(ifp);
		files++;
	    } else {
		perror(argv[i]);
		goto syntax;
	    }
	}
	if (bars < 0) {
syntax:
	    fprintf(stderr,
	     "Usage: %s [-b#] [-B#] [files or stdin]\n", argv[0]);
	    fprintf(stderr, "-b# sets the number of bars to strip.\n");
	    fprintf(stderr, "-B# sets the number of MPU clocks per bar.\n");
	    exit(2);
	}
	if (!files)
	    countin(bars, cpb, stdin);
	exit(0);
}

countin(bars, cpb, ifp)
FILE	*ifp;
{
	int i, waiting;
	long now;
	MCMD *mp;

	waiting = 1;
	for (now = 0L; mp = getmcmd(stdin, now); ) {
	    now = mp->when;
	    if (waiting) {
		if (bars && (now / cpb) >= bars) {
		    dumpsaved(bars * cpb);
		    waiting = 0;
		} else if (bars == 0 && IS_KEY(mp))
		    bars = (now / cpb) + 1;
	    }
	    if (waiting)
		save(mp);
	    else
		putmcmd(stdout, mp);
	}
	exit(0);
}

#define	MAXSAV	256
u_char	Savebuf[3*MAXSAV], *Sbp = Savebuf;
int	Nsaved	= 0;
MCMD	Msave[MAXSAV];

save(mp)
MCMD	*mp;
{
	if (Nsaved >= MAXSAV || (Sbp + mp->len - Savebuf) >= 3 * MAXSAV) {
	    fprintf(stderr, "save buffer overflow... aborting\n");
	    exit(1);
	}
	Msave[Nsaved] = *mp;
	Msave[Nsaved++].cmd = Sbp;
	for (; --(mp->len) >= 0; *Sbp++ = *(mp->cmd)++);
}

dumpsaved(when)
{
	int i;

	for (i = 0; i < Nsaved; i++) {
	    Msave[i].when = when;
	    putmcmd(stdout, &Msave[i]);
	}
}

