/*

  sshauthmethodc.c

  Authors:
        Tatu Ylonen <ylo@ssh.fi>
        Markku-Juhani Saarinen <mjos@ssh.fi>
        Timo J. Rinne <tri@ssh.fi>
        Sami Lehtinen <sjl@ssh.fi>

  Copyright (C) 1997-1998 SSH Communications Security Oy, Espoo, Finland
  All rights reserved.

  SSH2 authentication methods for the client.

*/

#include "ssh2includes.h"
#include "sshencode.h"
#include "sshauth.h"
#include "readpass.h"
#include "authc-pubkey.h"
#include "authc-passwd.h"
#include "authc-hostbased.h"

#define SSH_DEBUG_MODULE "SshAuthMethodClient"

/* table of the supported authentication methods */

SshAuthClientMethod client_methods[] =
{
#ifndef SSH_WIN_CLIENT
  /* XXX test hostbased and pubkey auth on Windows later */
  { SSH_AUTH_HOSTBASED, ssh_client_auth_hostbased },
  { SSH_AUTH_PUBKEY, ssh_client_auth_pubkey }, 
#endif /* SSH_WIN_CLIENT */
  { SSH_AUTH_PASSWD, ssh_client_auth_passwd },
  { NULL, NULL }
};

/* Initializes the authentication methods array for the client. */

SshAuthClientMethod *ssh_client_authentication_initialize()
{
  SshAuthClientMethod *methods;
  int i = 0;
  
  methods = ssh_xcalloc(sizeof(client_methods)/sizeof(*client_methods),
                        sizeof(*client_methods));

  for (i = 0; client_methods[i].name != NULL; i++)
    {
      methods[i] = client_methods[i];
    }
  
  return methods;
}

/* Frees the returned authentication method array. */

void ssh_client_authentication_uninitialize(SshAuthClientMethod *methods)
{
  memset(methods, 'F', sizeof(client_methods));
  ssh_xfree(methods);
}
