/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)ks_ras.c	1.8 95/11/20 Sun Microsystems"

#include <stdio.h>
#include <ctype.h>
#include <values.h>
#include <sys/stat.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <dirent.h>
#include <unistd.h>

#ifdef SYSV
#include <libgen.h>
#endif

#ifdef __STDC__
#include <stdarg.h>
#endif /*__STDC__*/

#include <xview/notify.h>
#include <xview/seln.h>
#include <xview/icon.h>
#include <xview/cms.h>
#include <xview/win_screen.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <skip_conf.h>
#include "ks_ras.h"

extern char	*progname;

extern char *directory();

static char *
icon_path(char *name)
{
	struct stat		st;
	static char		path[256], prog[256];

	if (stat(name, &st) == 0) {
		return (name);
	}

	strcpy(prog, progname);
	strcpy(path, directory(prog));
	strcat(path, "/");
	strcat(path, name);

	if (stat(path, &st) == 0) {
		return (path);
	}

	strcpy(path, SKIP_BIN);
	strcat(path, "/");
	strcat(path, name);
	if (stat(path, &st) == 0) {
		return (path);
	}
	return (NULL);
}


Server_image
load_raster(char *fname, int *width, int *height, int *depth)
{
	unsigned char	r[256], g[256], b[256];
	FILE		*fp;
	int		linesize, lsize, csize, i, d, w, h;
	byte		*image, *line;
	struct rasterfile sunheader;
	Server_image	server_image;
	Cms		cms;
	Xv_singlecolor colours[256];
	char		*path;

	path = icon_path(fname);

	if (path == NULL) {
		return(NULL);
	}

	fp=fopen(icon_path(fname), "r");
	if (!fp) {
		return(NULL);
	}

	getlong (&sunheader.ras_magic, fp);
	getlong (&sunheader.ras_width, fp);
	getlong (&sunheader.ras_height, fp);
	getlong (&sunheader.ras_depth, fp);
	getlong (&sunheader.ras_length, fp);
	getlong (&sunheader.ras_type, fp);
	getlong (&sunheader.ras_maptype, fp);
	getlong (&sunheader.ras_maplength, fp);

	if (sunheader.ras_magic != RAS_MAGIC) {
		fclose(fp);
		fprintf( stderr, "not a Sun rasterfile\n");
		return(NULL);
	}

	/* make sure that the input picture can be dealt with */
	if (sunheader.ras_depth != 1 &&
		sunheader.ras_depth != 8 &&
		sunheader.ras_depth != 24 &&
		sunheader.ras_depth != 32) {
		fprintf (stderr, "Sun rasterfile image has depth %d\n", 
			sunheader.ras_depth);
		fprintf (stderr, "Depths supported are 1, 8, 24, and 32\n");
		fclose(fp);
		return(NULL);
	}

	if (sunheader.ras_type != RT_OLD &&
		sunheader.ras_type != RT_STANDARD &&
		sunheader.ras_type != RT_BYTE_ENCODED &&
		sunheader.ras_type != RT_FORMAT_RGB) {
		fprintf (stderr, "Sun rasterfile of unsupported type %d\n",
			sunheader.ras_type);
		fclose(fp);
		return(NULL);
	}

	if (sunheader.ras_maptype != RMT_RAW &&
		sunheader.ras_maptype != RMT_NONE &&
		sunheader.ras_maptype != RMT_EQUAL_RGB) {
		fprintf (stderr, "Sun rasterfile colormap of unsupported "
					"type %d\n", sunheader.ras_maptype);
		fclose(fp);
		return(NULL);
	}

	w = sunheader.ras_width;
	h = sunheader.ras_height;
	d = sunheader.ras_depth;

	csize = (sunheader.ras_maptype == RMT_NONE)? 0 : sunheader.ras_maplength;


	lsize = w * h;	 
	if (d == 24 || d == 32) {
		lsize = lsize * 3;
	}

	linesize = w * d;
	linesize /= 8;

	if (sunheader.ras_maptype == RMT_EQUAL_RGB && csize) {
		fread (r, 1, sunheader.ras_maplength/3, fp);
		fread (g, 1, sunheader.ras_maplength/3, fp);
		fread (b, 1, sunheader.ras_maplength/3, fp);
	} else if (sunheader.ras_maptype == RMT_RAW && csize) {
		fseek (fp, (long) csize, 1);
	}

	else {  /* no colormap, make one up */
		if (sunheader.ras_depth == 1) {
			r[0] = g[0] = b[0] = 0;
			r[1] = g[1] = b[1] = 255;
		} else if (sunheader.ras_depth == 8) {
			for (i = 0; i < 256; i++)
				r[i] = g[i] = b[i] = i;
		}
 	}


	/* allocate memory for picture and read it in */
	image = (byte *) malloc (lsize);
	line = (byte *) malloc (linesize);
	if (image == NULL || line == NULL) {
		if (image) free(image);
		if (line) free(line);
		fprintf(stderr, "Can't allocate memory for image\n");
		return(NULL);
	}


	for (i = 0; i < h; i++) {
		if (sunheader.ras_type == RT_BYTE_ENCODED) {
	  		if (rle_read(line, 1, linesize, fp, (i==0)) != linesize)
				 break;
		} else {
	  		if (fread (line, 1, linesize, fp) != linesize) {
				free(image);  free(line);  fclose(fp);
				fprintf (stderr, "file read error\n");
				return(NULL);
			}
		}

		switch (d) {
		case 1:
			memcpy((char *)(image + linesize * i),
						(char *)line, linesize);
			break;
		case 8:
			memcpy((char *)(image + w * i), (char *)line, w);
			break;
		case 24:
			memcpy((char *)(image + w * i * 3), (char *)line, w * 3);
			break;
		case 32: {
		   	int k;
		   	byte *ip, *op;
		   	ip = line;
		   	op = (byte *) (image + w * i * 3);
		   	for (k = 0; k<w; k++) {
		 		*ip++;	   /* skip 'alpha' */
		 		*op++ = *ip++;   /* red   */
		 		*op++ = *ip++;   /* green */
		 		*op++ = *ip++;   /* blue  */
		   	}
		 	}
		}
	}

	free(line);

	if (d == 24 || d == 32) {
		if (sunheader.ras_type != RT_FORMAT_RGB) fixBGR(image,w,h);
	}

	fclose(fp);

	for (i = 0; i < sunheader.ras_maplength/3; i++) {
		colours[i].red   = r[i];
		colours[i].green = g[i];
		colours[i].blue  = b[i];
	}

	cms = (Cms) xv_create(NULL, CMS, 
		CMS_SIZE, sunheader.ras_maplength/3,
		CMS_COLORS, colours,
		NULL);

	server_image = (Server_image) xv_create(NULL,
			SERVER_IMAGE, 
			XV_WIDTH, w,
			XV_HEIGHT, h,
			SERVER_IMAGE_DEPTH, d,
			SERVER_IMAGE_CMS, cms,
			SERVER_IMAGE_BITS, image,
			NULL);

	free(image);

	*width = w;
	*height = h;
	*depth = d;

	return (server_image);
}


static int
rle_read (ptr, size, nitems, fp, init)
byte *ptr;
int size, nitems,init;
FILE *fp;
{
	static int count, ch;
	int readbytes, c, read;

	if (init) { count = ch = 0; }

	readbytes = size * nitems;
	for (read = 0; read < readbytes; read++) {
	if (count) {
	  *ptr++ = (byte) ch;
	  count--;
	}

	else {
	  c = getc(fp);
	  if (c == EOF) break;

	  if (c == RAS_RLE) {   /* 0x80 */
	count = getc(fp);
	if (count == EOF) break;

	if (count < 0) count &= 0xff;
	if (count == 0) *ptr++ = c;
	else {
	  if ((ch = getc(fp)) == EOF) break;
	  *ptr++ = ch;
	}
	  }
	  else *ptr++ = c;
	}
	}

	return (read/size);
}


static int
getlong (l, fp)
	 long *l;
	 FILE *fp;
{
	int c0, c1, c2, c3;

	c0 = fgetc(fp);
	c1 = fgetc(fp);
	c2 = fgetc(fp);
	c3 = fgetc(fp);

	*l = (((u_long) c0 & 0xff) << 24) |
	   (((u_long) c1 & 0xff) << 16) |
	   (((u_long) c2 & 0xff) <<  8) |
	   (((u_long) c3 & 0xff));

	if (ferror(fp)) return EOF;

	return 0;
}

static void fixBGR(img,w,h)
unsigned char *img;
int w,h;
{
	int i,npixels;
	unsigned char tmp;

	npixels = w*h;
	for (i=0; i<npixels; i++) {
	tmp = img[0];		   /* swap red and blue channels */
	img[0] = img[2];
	img[2] = tmp;
	img += 3;			   /* bump to next pixel */
	}
}

char *
directory(char *s)
{
	register char   *p;

	if( !s  ||  !*s ) {
	        return  ".";
	}

	p = s + strlen( s );
	while( p != s  &&  *--p == '/' )
	        ;

	if ( p == s && *p == '/' ) {
	        return "/";
	}

	while( p != s )
	        if( *--p == '/' ) {
	                while ( *p == '/' )
	                        p--;
	                *++p = '\0';
	                return  s;
	        }

	return  ".";
}

