/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
 
#pragma ident "@(#)skip_msgs.C	1.13 96/01/16"
 
#include <sys/types.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>
#include <assert.h>

#include "Time.h"
#include "Bigint.h"
#include "Bstream.h"
#include "malloc.h"
#include "skip_log.h"


#include <netinet/in.h>
#include <sys/errno.h>

#include "skip_proto.h"
#include "skip_types.h"
#include "skip_conf.h"
#include "skip_keymgrmsgs.h"
#include "SkipCert.h"
#include "skip_fetchcert.h"
#include "skip_keymgr.h"

extern int		errno;
int		verbose;
int	UPDATE_FREQ;

void
set_kij_alg(int fd, unsigned char version, unsigned char kij_alg)
{
        struct Set_supported_kij        set;
 
        set.msgtype     = SKIP_SET_SUPPORTED_KIJ;
        set.version     = version;
        set.kij_alg     = kij_alg;
	
 	skip_log(SKIP_NOTICE, "Setting supported kij alg=%d for version %d",
                                                        kij_alg, version);
        fflush(stdout);
 
        if (put_skip_msg(fd, &set, sizeof(set)) < 0) {
                if (errno == EINTR) {
                        return;
                }
                if ((errno == EAGAIN) || (errno == EWOULDBLOCK)) {
                        return;
                }
                perror("skip_keymhr_putmsg");
        }
}

int
make_boxid_msg(u_char nsid, Bstream keyid, void *buf )
{
	struct Set_local_keyid	*set;
	int			flags;
	union skip_messages	*msg;

	msg=(union skip_messages *)buf;
	
	msg->msgtype= SKIP_SET_LOCAL_KEYID;
	set = &msg->set_keyid;
	set->nsid	= nsid;

	/*
	 * XXX - how to convert Bstreanm to keyid ???
	 */
	set->mkeyid.len = keyid.getlength();
	memcpy(set->mkeyid.buf, (char *) keyid.getdatap(), set->mkeyid.len);

	return sizeof (struct Set_local_keyid);
}
	
// Make an encrypted key request response.  

static u_long
make_enc_rsp(union skip_messages *dp, union skip_messages *response, 
		int *size, struct remote_info *host)
{
	skip_param_t   *req_params;
	Bstream e_kp, a_kp, iv, encrypted_kp, kp;
	u_long ncounter, time_left;
	u_long return_value;
	Bstream keyid;

	return_value=KEYMGR_OK;

	req_params   = &dp->enc_rsp.params;

	keyid = Bstream(req_params->r_mkeyid.len, 
			(u_char *)req_params->r_mkeyid.buf);

	if (verbose) {
		String temp;
		temp=keyid.gethexstr();
		skip_log(SKIP_NOTICE, "Received encrypt key request for 0x%s",
                                (const char*)temp);
	}

	// Fill in the remote host structure
	host->keyid = keyid;
	host->nsid  = req_params->r_nsid;
	bcopy(&req_params->ip_addr, &host->ip_addr, sizeof(struct in_addr));

	ncounter = CURRENT_NCOUNTER;
	time_left = UNTIL_NEXT_NCOUNTER;

	return_value = skip_generate_kp_iv( req_params->version,keyid,
				 	    req_params->s_nsid, 
					    req_params->kp_alg,
				 	    req_params->kij_alg, 
					    req_params->mac_alg,
				 	    kp, e_kp, a_kp, iv, 
					    encrypted_kp, ncounter);

	if (return_value)
		return return_value;
	response->enc_rsp.msgtype  = SKIP_ENCRYPTED_PKT_KEY_RSP;
	response->enc_rsp.params   = dp->enc_req.params;
	response->enc_rsp.params.counter_n   = htonl(ncounter);
	response->enc_rsp.params.ttl = time_left;

	response->enc_rsp.kp_keylen = kp.getlength();
	response->enc_rsp.kp_offset = sizeof(response->enc_rsp);
	memcpy((char *)response + sizeof(response->enc_rsp), kp.getdatap(), 
			kp.getlength());

	response->enc_rsp.iv_len   = iv.getlength();
	response->enc_rsp.iv_offset = sizeof(response->enc_rsp) + 
			kp.getlength(); 
	memcpy((char *)response + response->enc_rsp.iv_offset, iv.getdatap(), 
			iv.getlength());

	response->enc_rsp.ekp_keylen = encrypted_kp.getlength();
	response->enc_rsp.ekp_offset = response->enc_rsp.iv_offset +
						  iv.getlength();
	memcpy((char *)response + response->enc_rsp.ekp_offset,
			encrypted_kp.getdatap(), encrypted_kp.getlength());

	*size=sizeof(response->enc_rsp) + e_kp.getlength() +
			iv.getlength() + encrypted_kp.getlength();

	/*
	 * ESP/AH mode only ...  
	 */
       if (req_params->version == SKIP_V2 ) {
 
		if (req_params->kp_alg) {
			response->enc_rsp.E_kp_keylen =e_kp.getlength();
			response->enc_rsp.E_kp_offset = *size;

			memcpy((char *)&response->enc_rsp+
					response->enc_rsp.E_kp_offset,
					e_kp.getdatap(), e_kp.getlength());
			*size+=e_kp.getlength();
	      	} else  {
		      	response->enc_rsp.E_kp_keylen   = 0;
		}
 
		if (req_params->mac_alg) {
			response->enc_rsp.A_kp_keylen=a_kp.getlength();
			response->enc_rsp.A_kp_offset =
				response->enc_rsp.ekp_offset +
				a_kp.getlength();
			memcpy((char *)&response->enc_rsp+
				       response->enc_rsp.A_kp_offset,
					a_kp.getdatap(), 
					a_kp.getlength());
			*size+=a_kp.getlength();
		} else  {
			response->enc_rsp.A_kp_keylen   = 0;
		}
	}
	return return_value;
}

// Make a decrypted key request response.  
static u_long
make_dec_rsp(union skip_messages *dp, union skip_messages *response, 
		int *size, struct remote_info *host)
{
	Bstream e_kp, a_kp, kp, encrypted_kp;
	Bstream keyid;
	skip_param_t   *req_params;
	u_long return_value;

	return_value=KEYMGR_OK;

	req_params                          = &dp->dec_rsp.params;

	response->dec_rsp.msgtype       = SKIP_DECRYPTED_PKT_KEY_RSP;
	response->dec_rsp.params        = dp->dec_req.params;

	keyid=Bstream(req_params->r_mkeyid.len, 
			(u_char *)req_params->r_mkeyid.buf);

	if (verbose) {
		String temp;
		temp=keyid.gethexstr();
		skip_log(SKIP_NOTICE, "Received decrypt key request for 0x%s",
                                (const char*)temp);
	}

	// Fill in the remote host structure
	host->keyid = keyid;
	host->nsid  = req_params->s_nsid;
	bcopy(&req_params->ip_addr, &host->ip_addr, sizeof(struct in_addr));

	encrypted_kp = Bstream((int)dp->dec_req.ekp_keylen, 
				(u_char *)dp + dp->dec_req.ekp_offset);

//	XXX need to do bounds checking here.

	return_value = skip_decrypt_kp( req_params->version, keyid, 
					req_params->s_nsid, 
					req_params->kij_alg, 
					req_params->kp_alg, 
					req_params->mac_alg,
					encrypted_kp, kp, e_kp, a_kp, 
					ntohl(req_params->counter_n));

	if (return_value)
		return return_value;
	// stuff in the kp
	response->dec_rsp.kp_keylen     = kp.getlength();
	response->dec_rsp.kp_offset     = sizeof(response->dec_rsp);
	memcpy((char *)&response->dec_rsp + response->dec_rsp.kp_offset,
			kp.getdatap(), kp.getlength());

	// Stuff in the ekp
	response->dec_rsp.ekp_keylen    = encrypted_kp.getlength();
	response->dec_rsp.ekp_offset    = response->dec_rsp.kp_offset +
						   kp.getlength();
	memcpy((char *)&response->dec_rsp + response->dec_rsp.ekp_offset,
				encrypted_kp.getdatap(), 
				encrypted_kp.getlength());
	
	*size = sizeof (response->dec_rsp) + encrypted_kp.getlength() +
						  kp.getlength();
		
	response->dec_rsp.params.counter_n    = req_params->counter_n;
	response->dec_rsp.params.ttl          = UNTIL_NEXT_NCOUNTER;
	/*
	 * ESP/AH mode only ...
	 */
	if (req_params->version == SKIP_V2 ) {
 
		if (req_params->kp_alg) {
			response->dec_rsp.E_kp_keylen=e_kp.getlength(),
			response->dec_rsp.E_kp_offset =*size;
			memcpy((char *)response + *size, e_kp.getdatap(),
					 e_kp.getlength());
			*size+=e_kp.getlength();	
		} else  {
			response->dec_rsp.E_kp_keylen = 0;
		}
 
		if (req_params->mac_alg) {
			response->dec_rsp.A_kp_keylen = a_kp.getlength();
			response->dec_rsp.A_kp_offset = *size;
				memcpy((char *) response+ *size,
						a_kp.getdatap(), 
						a_kp.getlength());
                } else  {
			response->dec_rsp.A_kp_keylen   = 0;
		}
	}
	return return_value;
}

/* Make response generates a message based on the in message.  It
** returns the boxid of the requester if the request could not be
** fulfilled.  If the request can be filled, the routine returns
** zero.
*/
u_long 
make_response(void *in_buf, void *out_buf, int *size, struct remote_info *host)
{
	union skip_messages *dp, *response;

	u_long ret;

	dp = (union skip_messages *)in_buf;
	response =(union skip_messages *)out_buf;

	switch (dp->msgtype) {
 
	        case SKIP_ENCRYPTED_PKT_KEY_REQ: 
			ret = make_enc_rsp(dp, response, size, host);
			break;
		case SKIP_DECRYPTED_PKT_KEY_REQ:
			ret = make_dec_rsp(dp, response, size, host);
			break;
        	default:
               		 fprintf(stderr, "Unsupported message (%d) received\n",
               	                 dp->msgtype);
                	*size = 0;
			ret = 0;
	}
		return ret;
}

void
print_dec_rsp(struct Decrypted_key_rsp *dkrsp)
{
	assert (dkrsp->msgtype == SKIP_DECRYPTED_PKT_KEY_RSP);
	// printf("boxid=%lx\n", ntohl(dkrsp->params.nodeid));
	printf("kp_alg=%d\n", dkrsp->params.kp_alg);
	printf("kij_alg=%d\n", dkrsp->params.kij_alg);
	printf("ekp_keylen=%d\n", dkrsp->ekp_keylen);
	printf("ekp_offset=%d\n", dkrsp->ekp_offset);
	printf("kp_keylen=%d\n", dkrsp->kp_keylen);
	printf("kp_offset=%d\n", dkrsp->kp_offset);
	printf("ekp=\n");
	Bstream ekp((int)dkrsp->ekp_keylen, (byte *)dkrsp+dkrsp->ekp_offset);
		ekp.print();
	printf("kp=\n");
	Bstream kp((int)dkrsp->kp_keylen, (byte *)dkrsp+dkrsp->kp_offset);
		kp.print();
	printf("\n");
}

int
skip_alloc_size(void *s)
{
	return MGTCSIZE; 		/* XXX could be smarter */
}
