/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_dump_certs.C	1.6 95/11/22"

/*
 * Author: Ashar Aziz
 */
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <ndbm.h>
#include "Bstream.h"

#include "skip_certbase.h"

extern char *certs_base;

void
usage(char **argv)
{
	fprintf(stderr, "Usage: %s\n",
		argv[0]);
}

int
main(int argc, char **argv)
{
	int cnt = 0;
	if (argc > 1)
		usage(argv);

	DBM	*db;
	u_char	nsid;
	datum	key, cert;
	Bstream keystr, certstr;

	skip_db_lock();
	db = dbm_open((char *)((const char *)certs_base), O_RDWR, 0);
	if (db == NULL) {
		fprintf(stderr, "get_all_certs: unable to open ndbm file %s\n",
			(const char *)certs_base);
		exit(1);
	}
	for (key = dbm_firstkey(db); key.dptr != NULL;
	     key = dbm_nextkey(db)) {
		cert = dbm_fetch(db, key);
		keystr= Bstream(key.dsize, (byte *)key.dptr);

		certstr = Bstream(cert.dsize, (byte *)cert.dptr);
		keystr.fetchbyte(nsid);
		fprintf(stdout, "nsid = %d, ", nsid);
		fprintf(stdout, "boxid = "); keystr.print();
		fflush(stdout);
		fprintf(stdout, "cert = "); certstr.print();
		fflush(stdout);
		cnt++;
	}
	printf("Total of %d certificate(s) in %s database\n", cnt, certs_base);
	skip_db_unlock();
}
