;skeyf.star: folds halves of a 128-bit MD5 sum into a 64-bit
;quantity used by S/KEY by xoring them together.
;assumes a string on the stack; replaces first eight characters
;with the xor of the first eight and next eight characters.

SAVPTR		= #0679b	;save RPL interpreter registers
GETPTRLOOP	= #05143	;restore RPL interpreter registers, continue RPL

	header	`E'

	code

	call	SAVPTR
	move.a	@d1, a	;get pointer to string
	move.a	a, d0	;put in d0
	add	10, d0	;advance to string data
	move.w	@d0, a	;get first half of MD5 sum
	add	16, d0
	move.w	@d0, c	;get second half of MD5 sum
	move.w	c, b	;xor together
	and.w	a, b	;b = a & c
	add.w	c, a	;a = a + c
	sub.w	b, a
	sub.w	b, a	;a = a - 2 * (a & c)
	sub	16, d0
	move.w	a, @d0
	call	GETPTRLOOP

	endcode
