/* sigaddset.c: A replacement for the sigaddset function

This software is Copyright 1996 by Craig Metz, All Rights Reserved. The
Inner Net Copyright Notice and License Agreement applies to these
portions of the software.

        History:

	Created by cmetz for OPIE 2.2.
*/

#include "opie_cfg.h"

#ifndef _NSIG
#ifdef NSIG
#define _NSIG NSIG
#else /* NSIG */
#define _NSIG 32
#endif /* NSIG */
#endif /* _NSIG */

#include "opie.h"

int sigaddset FUNCTION((set, signum), sigset_t *set AND int signum)
{
#if sizeof(sigset_t) != sizeof(int)
Sorry, we don't currently support your system.
#else /* sizeof(sigset_t) != sizeof(int) */
	if (set && (signum > 0) && (signum < _NSIG))
		*set |= 1 << (signum - 1);
#endif /* sizeof(sigset_t) != sizeof(int) */

	return 0;
}
