/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/user/RCS/spxdestroy.c,v $
 *
 *
 *  MODULE NAME:    spxdestroy.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <cdc.h>
#include <strings.h>

static char *pname;

static usage()
{
    printf("Usage: %s [-f] [-a]\n", pname);
    printf("\t-f      force deletion of claimant credentials\n");
    printf("\t-a      automatically delete credentials if 1 shell\n");
    printf("\t          process exists\n");
    exit(1);
}

main(argc, argv)
    int    argc;
    char   *argv[];
{
    int             num_shells = 2, pid, tty, status;
    int             pfd[2];
    register char   *cp, *env;


    if ((env = (char *) getenv("SPHINX_CLAIMANT_FILE")) != NULL) {
      dest_claimant(1);
      exit(0);
    }

    cp = rindex (argv[0], '/');
    if (cp == NULL)
	pname = argv[0];
    else
	pname = cp+1;

    if (argc == 2) {
      if (strcmp(argv[1], "-f") == 0) {
        dest_claimant(1);
	exit(0);
      } else usage();
    }

    if (argc > 2)
	usage();

    tty = open("/dev/tty", 2);
    if (tty == -1) {
      fprintf(stderr, "%s: can't open /dev/tty\n");
      exit(-1);
    }

    if (pipe(pfd) == -1) {
      printf("pipe error\n");
      exit(-1);
    }

    /*
     *  want pass the result of "ps c | fgrep csh | wc -l" to
     *  num_shells variable
     *
     */
 
    if ((pid = fork()) == 0) {

      if (close(1) == -1)  printf("close error");
      if (dup(pfd[1]) != 1) printf("dup1 error");
      if (close(pfd[0]) == -1)  printf("close2 error");
      if (close(pfd[1]) == -1)  printf("close3 error");

      execlp("/bin/ps", "ps", "c", (char *) 0);
      exit(1);
    }

    if ((pid = fork()) == 0) {

      if (close(0) == -1)  printf("close4 error");
      if (dup(pfd[0]) != 0) printf("dup2 error");
      if (close(pfd[1]) == -1) printf("close5 error");
      if (close(pfd[0]) == -1) printf("close6 error");

      execlp("/bin/bin/fgrep", "fgrep", "csh", (char *) 0);
      exit(1);
    }

    if (close(pfd[0]) == -1) printf("close7 error");
    if (close(pfd[1]) == -1) printf("close8 error");
    wait(&status);

/*  for now don't destroy claimant credentials  */

    if (num_shells <= 1) {
        dest_claimant(1);
    }
    exit(0);
}
