/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/rsamd2_verify_aux.c,v $
 *
 *
 *  MODULE NAME:    rsamd2_verify_aux.c
 *
 *
 *  AUTHORS:
 *
 *      J. Tardo
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <ctype.h>
#include "SPHINX-types.h"
#include "sign_aux.h"

#include "bigrsacode.h"
#include "bigsignverify.h"
#include "BigRSA.h"
#include "objid.h"

#ifdef DEBUG
#undef DEBUG
#endif

#define MAX_SIG 2*DigitLim*sizeof(BigNumDigit)

typedef int (*IFX)();

/*  Define for more verbose debugging.
#define DEBUG2
*/

int rsamd2_verify_aux (x_in,encode_fn,key)
IFX encode_fn;
struct type_Sign_SignedData *x_in;
RSAKeyStorage *key;
{
	char *asn1_new_x = NULL, *signature_bits = NULL;
	int new_len, sig_len, status=0;

        if ( oid_cmp(x_in->algorithm->algorithm,
                        str2oid(OIW_MD2_WITH_RSA_OID)) != 0) {
#ifdef DEBUG
printf("%s: Algorithm Identifier Mismatch.\n", __FILE__);
#endif
                return(0);
        }

        status = ber_encode(x_in->toBeSigned,encode_fn,PS_LEN_LONG,&asn1_new_x,&new_len);

	signature_bits = prim2str((PE)x_in->signature, &sig_len);
	if(signature_bits == 0 ) {
#ifdef DEBUG
printf("\n%s: Error converting signature to string.", __FILE__);
#endif
		goto finished;
	}

#ifdef DEBUG2
printf("\n%s: recovered signature bits:\n", __FILE__);
hexdump(signature_bits,sig_len);
#endif

#ifdef DEBUG
printf("\n%s: Signing encoded data.\n", __FILE__);
fflush(stdout);
dumphex(asn1_new_x,new_len);
fflush(stdout);
#endif

        status=RSAVerify(asn1_new_x,new_len,key,signature_bits,sig_len);

#ifdef DEBUG
if(status==FALSE) printf("\n%s: verification failed.\n", __FILE__);
else printf("\n%s: success.\n", __FILE__);
#endif

finished:
	if (signature_bits != NULL) free(signature_bits);
	if (asn1_new_x != 0) free(asn1_new_x);
	return(status);
}

