/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/read_key.c,v $
 *
 *
 *  MODULE NAME:    read_key.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


/*
 *  This program reads a public key file of text as hex bytes and produces the 
 *  buffer of the binary values.  This buffer is then parsed into a name and
 *  key field.
 *
 */

#include <stdio.h>
#include "cdc.h"

int read_key(principal, pubtype, name_ava, uid, uidlen, hashkey, asn1_key, keylen)
char    *principal;
int     pubtype;
char    *name_ava;
unsigned char    *uid;
int     *uidlen;
unsigned char *hashkey;
unsigned char    *asn1_key;
int     *keylen;
{
    char keyfile[40], name[40], *ptr, domain[FULLNAME_SZ], new_princ[ANAME_SZ];
    unsigned char *uptr;
    int  i, c, j;
    int  hex;
    int  fullflag = 0;
    FILE *f;

    if (strcmp(principal, ".") == 0) {
      strcpy(domain, get_domain_name(NULL));
      i = strlen(domain);
      while (domain[--i] != '=');
      strcpy(new_princ, &domain[++i]);
    } else strcpy(new_princ, principal);

    strcpy(keyfile, new_princ);
    if (pubtype == 1)  strcat(keyfile, "_pubkey");
    else strcat(keyfile, "_privkey");
    if ((f = fopen(keyfile, "r")) == NULL) {
      printf("read_key : Could not open - %s\n",keyfile);
      return(-1);
    }
    i = 0;
    while ((c=getc(f)) == 0x20);
    if (c == 0x7b) fullflag = 1;
    name[i++] = c;
    while ((c = getc(f)) != '\n')  name[i++] = c;
    name[i] = '\0';

    uptr=uid;
    for (i=0;i<UID_SZ;i++) {
      if (fscanf(f, " %2x", &hex) == 1) *uptr++ = hex;
      else break;
    }
    *uidlen = i;
    while (getc(f)!=';');

    if (pubtype == 0) {
      i = 0;
      while (fscanf(f, " %2x", &hex) == 1) {
	hashkey[i] = hex;
	i++;
      }
      while (getc(f)!=';');
    }
    i = 0;
    while (fscanf(f, " %2x",&hex) == 1) {
      asn1_key[i] = hex;
      i++;
    }
    close(f);
    *keylen = i;
    strcpy(name_ava, name);
    return(fullflag);
}
