/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/api/RCS/make_response.c,v $
 *
 *
 *  MODULE NAME:    make_response.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <syslog.h>
#include "cdc.h"
#include "cdc_db.h"
#include "SPHINX-types.h"
#include "BigNum.h"
#include "BigRSA.h"
#include "random.h"
#include "spxapi_defs.h"
#include "objid.h"
#include "gssapi_defs.h"

static char cdc_request_login_data[256];
static int  cdc_request_login_len = 0;

int Sphinx_make_response(claimant_cred_opaque, ta_claimant_cred_opaque,
			 context_handle, output_token, output_tokenlen)
char  *claimant_cred_opaque;
char  *ta_claimant_cred_opaque;
ContextHandle *context_handle;
char  *output_token;
int   *output_tokenlen;
{
  int status;
  ClaimantCred    *claimant_cred;
  TrustedCred     *ta_claimant_cred;
  static RSAKeyStorage  userRSAKey;
  DESblock pwkey;
  char     privkey[sizeof(RSAKeyStorage)], cdc_server[ANAME_SZ];
  int      privkeylen, sig_len = 0, wrapper_adj;

  cdc_server[0] = '\0';
  claimant_cred = (ClaimantCred *) claimant_cred_opaque;
  ta_claimant_cred = (TrustedCred *) ta_claimant_cred_opaque;

  if ((status=read_login_cstub(claimant_cred->fullname, 0, privkey,
			       &privkeylen, cdc_server, 0)) < 0) {
    switch(status) {
      case CDC_UNAVAILABLE :
	/*
	 *  even though this host isn't able to communicate with CDC
	 *  server, maybe the other side can.  therefore build a request
	 *  login packet and return to caller
	 */
/*
	if ((build_login_req_apdu(cdc_request_login_data,
	                          cdc_request_login_len,
				  0,
				  claimant_cred->fullname,
				  NULL,0,0)) < 0)
	  return(SPX_S_BAD_TOKEN_FORMAT);
*/
	output_token[0] = 0xa8;
	if (cdc_request_login_len > 256) {
	  output_token[1] = 0x82;
	  output_token[2] = (cdc_request_login_len) / 256;
	  output_token[3] = (cdc_request_login_len) % 256;
	  wrapper_adj = 3;
	} else {
	  if (cdc_request_login_len > 128) {
	    output_token[1] = 0x81;
	    output_token[2] = cdc_request_login_len;
	    wrapper_adj = 2;
	  } else {
	    output_token[1] = cdc_request_login_len;
	    wrapper_adj = 1;
	  }
	}
	bcopy(cdc_request_login_data,
	      &output_token[wrapper_adj+1],
	      cdc_request_login_len);
	*output_tokenlen = cdc_request_login_len + wrapper_adj + 1;
	return(SPX_S_CLAIM_UNABLE_TO_ACCESS_CDC);
	break;
      default :
	return(SPX_S_CLAIM_CERTIFS_DONT_EXIST_IN_CDC);
	break;
    }
  }

  DES_read_password(&pwkey, "password: ", 0);
  if(!recover_private(&pwkey,privkey,privkeylen,&userRSAKey)) {
    bzero(&pwkey, sizeof(pwkey));
    bzero(privkey, sizeof(privkey));
    privkeylen=0;
    bzero(&userRSAKey, sizeof(userRSAKey));
    return(SPX_S_ILLEGAL_PASSWORD);
  }
  bzero(&pwkey, sizeof(pwkey));
  bzero(privkey, sizeof(privkey));
  privkeylen=0;

  *output_token = 0;
  if (status=RSASign(context_handle->mutual_resp, context_handle->mutual_len,
		     &userRSAKey, output_token+1, &sig_len));
  else {
    printf("error signing mutualresponse of len %d\n", context_handle->mutual_len);
    return(SPX_S_ERROR_SIGNING_MUTUAL);
  }
  bzero(&userRSAKey, sizeof(userRSAKey));
  *output_tokenlen = sig_len+1;
  return(1);
}
