/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/api/RCS/init_context.c,v $
 *
 *
 *  MODULE NAME:    init_context.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <syslog.h>
#include "cdc.h"
#include "cdc_db.h"
#include "SPHINX-types.h"
#include "BigNum.h"
#include "BigRSA.h"
#include "random.h"
#include "objid.h"
#include "spxapi_defs.h"

#define CLOCK_SKEW   5*60

extern int ps_len_strategy;

static RSAKeyStorage ver_pubRSAKey;
int  encode_SPHINX_AuthenticatorInfo();
int  encode_SPHINX_Authenticator();
int  encode_SPHINX_EncryptedKey();
int  encode_SPHINX_LongPosixTime();
int  encode_SPHINX_AuthenticationToken();
struct type_SPHINX_AlgorithmIdentifier *create_alg_id();
struct type_SPHINX_DistinguishedName *str_to_rdn();


int Sphinx_Init_sec_context(claimant_cred, ta_claimant_cred,
        context_handle, fulltargname, deleg_flag, mutual_flag,
        chanbinding, chanbinding_len, input_token, input_tokenlen,
        token, tokenlen, debugflag)
ClaimantCred  *claimant_cred;
TrustedCred   *ta_claimant_cred;
ContextHandle **context_handle;
char *fulltargname;
int  deleg_flag, mutual_flag;
char *chanbinding;
int  chanbinding_len;
char *input_token;
int  input_tokenlen;
char *token;
int  *tokenlen;
int  debugflag;
{
  ContextHandle   *ctx_handle;
  Claimant_ContextCache    claimantctx_cache;

  int             time_now, asn1len, i, keybuflen, build_tokenlen;
  int             explicit, result, found_in_cache = 0;
  int             signaturedata_sz, encrypted_deskey_len, wrapper_adj;
  char            cdc_server[2*ANAME_SZ], clm_ctx_filename[FULLNAME_SZ];
  unsigned char   keybuf[PRIVATE_KEY_SIZE], authenticator_type;
  unsigned char   *asn1_buf;
  char            temp[128], encrypted_deskey[2*DigitLim*sizeof(int)];
  char            *encrypted_rsakey;
  PE              userticket_pe;
  DESblock        deskey;

  struct type_SPHINX_AuthenticationToken   *authtoken;
  struct type_SPHINX_AuthenticatorInfo     *authinfo;
  struct type_SPHINX_EncryptedKey          *encrypkey;
  struct type_SPHINX_LoginTicket           *loginticket;
  struct type_SPHINX_Evidence              *evidence;
  struct type_SPHINX_LongPosixTime         *mutual_time;

  ps_len_strategy = PS_LEN_LONG;

  /*  check credential validity  */

  if ((claimant_cred->userticket_len == 0) ||
      (claimant_cred->deleg_flag == 0) ||
      (claimant_cred->s_privRSAKey == NULL)) {
    return(SPX_S_NOT_PROPER_CRED);
  }

  time_now = time(0);
  if (claimant_cred->after < time_now-CLOCK_SKEW)  {
    printf("credential file has expired ... %s", asctime(localtime(&claimant_cred->after)));
    return(SPX_S_TICKET_EXPIRED);
  }
  if (claimant_cred->before > time_now+CLOCK_SKEW) {
    printf("credential file is not valid yet ... %s", asctime(localtime(&claimant_cred->before)));
    return(SPX_S_TICKET_NOT_VALID_YET);
  }

  /*  read context cache for target  */

  strcpy(clm_ctx_filename,
	 clm_ctx_string(claimant_cred->name,NULL,fulltargname));
  if (clm_ctx_init(clm_ctx_filename, W_TKT_FIL) == ASUCCESS) {
    if (clm_ctx_get_context(fulltargname, &claimantctx_cache) == ASUCCESS)
      found_in_cache = 1;
  }
  clm_ctx_close();

  /*  if cache exists, check if it is valid  */

  if (found_in_cache) {
    if (claimantctx_cache.after < time_now-CLOCK_SKEW)
      found_in_cache = 0;
    if (claimantctx_cache.before > time_now+CLOCK_SKEW)
      found_in_cache = 0;
    if (claimantctx_cache.deleg_flag != deleg_flag)
      found_in_cache = 0;
    if (claimantctx_cache.chanbinding_len != chanbinding_len)
      found_in_cache = 0;
  }

  /*  make authtoken structure  */

  authtoken = (struct type_SPHINX_AuthenticationToken *) malloc(sizeof(struct type_SPHINX_AuthenticationToken));

  if (found_in_cache) {

    authinfo = (struct type_SPHINX_AuthenticatorInfo *) malloc(sizeof(struct type_SPHINX_AuthenticatorInfo));
    authenticator_type = 0;
    if (deleg_flag)
      authenticator_type = 1 << bit_SPHINX_type_delegationRequired;
    if (mutual_flag)
      authenticator_type = (authenticator_type | 1 << bit_SPHINX_type_mutualRequested);
    authinfo->type =
      strb2bitstr(&authenticator_type, 8, PE_CLASS_UNIV, PE_PRIM_BITS);
    authinfo->whenSigned =
      (struct type_SPHINX_LongPosixTime *) malloc(sizeof(struct type_SPHINX_LongPosixTime));
    authinfo->whenSigned->seconds = time_now;
    authinfo->whenSigned->nanoseconds = 0;
    authinfo->channelId = str2qb(chanbinding, chanbinding_len, 1);
    desmac_sign_aux(authinfo, encode_SPHINX_AuthenticatorInfo,
		    &claimantctx_cache.deskey, &authtoken->authenticator);
/*
 * ka  5/22/91  - don't send channel binding info in token
 */
    free(authinfo->channelId);
    authinfo->channelId = NULL;

    if ((ber_encode(authtoken->authenticator,
			     encode_SPHINX_Authenticator,
			     PS_LEN_LONG, &asn1_buf, &asn1len)) == NOTOK) {
      printf("ber_encode authenticator error (found_in_cache is 1)!\n");
      return(SPX_S_MALLOC_ERROR);
    }
    bcopy(&claimantctx_cache.charbuf[claimantctx_cache.verifier_fn_len],
	  token, claimantctx_cache.token_len);
    i = DecodeHeaderLength(token);
    bcopy(&asn1_buf[1], &token[i+1], asn1len-1);
    *tokenlen = claimantctx_cache.token_len;
  } else {
    /*
     *  previous token request not found in cache, so issue call to
     *  read_pub_key()
     */

    /*  read verifier public key and name  */

    if (!input_tokenlen) {
      if ((i = read_pub_key(fulltargname, &ver_pubRSAKey, ta_claimant_cred,
			    cdc_server, 0)) <= 0) {
	switch(i) {
	  /*
	   *  CDC is unavailable on this side
	   */
          case -1 :
	          /*
		   *  get the cdc request and forward it to verifier
		   */
	          forward_cdc_request_len(tokenlen);
		  if (*tokenlen > 0) {
		    token[0] = 0xa5;
		    if (*tokenlen > 256) {
		      token[1] = 0x82;
		      token[2] = (*tokenlen) / 256;
		      token[3] = (*tokenlen) % 256;
		      wrapper_adj = 3;
		    } else {
		      if (*tokenlen > 128) {
			token[1] = 0x81;
			token[2] = (*tokenlen);
			wrapper_adj = 2;
		      } else {
			token[1] = (*tokenlen);
			wrapper_adj = 1;
		      }
		    }
		    forward_cdc_request_data(&token[wrapper_adj+1]);
		    *tokenlen += wrapper_adj;
		    *tokenlen += 1;
		    *context_handle = NULL;  /*  context handle not valid */
		    printf("SPX-info : CDC unavailable on claimant side, forwarding CDC request\n");
		    return(SPX_S_INIT_CONTINUE);
		  }
	          return(SPX_S_CLAIM_UNABLE_TO_ACCESS_CDC);
                  break;
          case -2 :
                  return(SPX_S_CLAIM_CANT_FIND_CERTIF_PATH_GOING_DN);
                  break;
          case -3 :
                  return(SPX_S_CLAIM_CANT_FIND_CERTIF_PATH_GOING_UP);
                  break;
          case -4 :
                  return(SPX_S_CLAIM_TARGET_IN_UNKNOWN_DOMAIN);
                  break;
          case -5 :
                  return(SPX_S_CLAIM_CERTIFS_DONT_EXIST_IN_CDC);
                  break;
          default :
                  return(SPX_S_CLAIM_READ_PUB_KEY_ERROR);
                  break;
        }
      }
    } else {
      /*
       *  use the input_token as the verifier certification path
       */
      if ((i = partial_read_pub_key(fulltargname, &ver_pubRSAKey,
				    ta_claimant_cred, input_token,
				    input_tokenlen, 0)) <= 0) {
	switch(i) {
          case -2 :
		  syslog(LOG_INFO, "  partial_read_pub_key: tree walk dn");
                  return(SPX_S_CLAIM_CANT_FIND_CERTIF_PATH_GOING_DN);
                  break;
          case -4 :
		  syslog(LOG_INFO, "  partial_read_pub_key: unknown domain");
                  return(SPX_S_CLAIM_TARGET_IN_UNKNOWN_DOMAIN);
                  break;
          case -5 :
		  syslog(LOG_INFO, "  partial_read_pub_key: verif certifs don't exist");
                  return(SPX_S_CLAIM_CERTIFS_DONT_EXIST_IN_CDC);
                  break;
          default :
		  syslog(LOG_INFO, "  partial_read_pub_key: error - %d", i);
                  return(SPX_S_CLAIM_READ_PUB_KEY_ERROR);
                  break;
        }
      }
    }

    /*  generate random des key  */

    *encrypted_deskey=0;
    InitAuthenticationKey(&ver_pubRSAKey, claimant_cred->s_privRSAKey,
	     &claimantctx_cache.deskey,
	     encrypted_deskey+1, &encrypted_deskey_len, claimant_cred->after );

    /*  version  */

    authtoken->version = NULL;              /*  use default, versionZero  */

    /*  authdata  */

    authinfo = (struct type_SPHINX_AuthenticatorInfo *) malloc(sizeof(struct type_SPHINX_AuthenticatorInfo));
    authenticator_type = 0;
    if (deleg_flag)
      authenticator_type = 1 << bit_SPHINX_type_delegationRequired;
    if (mutual_flag)
      authenticator_type = (authenticator_type | 1 << bit_SPHINX_type_mutualRequested);
    authinfo->type = strb2bitstr(&authenticator_type, 8, PE_CLASS_UNIV, PE_PRIM_BITS);
    authinfo->whenSigned = (struct type_SPHINX_LongPosixTime *) malloc(sizeof(struct type_SPHINX_LongPosixTime));
    authinfo->whenSigned->seconds = time_now;
    authinfo->whenSigned->nanoseconds = 0;
    authinfo->channelId = str2qb(chanbinding, chanbinding_len, 1);
    desmac_sign_aux(authinfo,encode_SPHINX_AuthenticatorInfo,
		    &claimantctx_cache.deskey,
		    &authtoken->authenticator);
/*
 * ka  5/22/91  - don't send channel binding info in token
 */
    free(authinfo->channelId);
    authinfo->channelId = NULL;

    /*  encryptedkey  */

    encrypkey = (struct type_SPHINX_EncryptedKey *) malloc(sizeof(struct type_SPHINX_EncryptedKey));
    authtoken->encryptedkey = encrypkey;
    i = (i=BnnNumDigits(ver_pubRSAKey.n,ver_pubRSAKey.nl))*8 -
      BnnNumLeadingZeroBitsInDigit(ver_pubRSAKey.n[i-1]);
    encrypkey->algorithm = create_alg_id(RSA_OID,&i);
    encrypkey->encryptedAuthKey = str2prim(encrypted_deskey,
					   encrypted_deskey_len+1,
					   PE_CLASS_UNIV, PE_PRIM_BITS);
    prim2bit(encrypkey->encryptedAuthKey);

    /*  userclaimant  */

    authtoken->userclaimant = (struct type_SPHINX_UserClaimant *) malloc(sizeof(struct type_SPHINX_UserClaimant));

    /*  loginticket  */

    if (!(userticket_pe = ssdu2pe(claimant_cred->userticket, claimant_cred->userticket_len, 0, &result))) {
      return(SPX_S_NOT_PROPER_CRED);
    }
    explicit = 1;
    if (decode_SPHINX_LoginTicket(userticket_pe, explicit, &claimant_cred->userticket_len, NULLCP, &loginticket) == NOTOK) {
      printf("illegal loginticket in claimant cred file\n");
      return(SPX_S_NOT_PROPER_CRED);
    }
    authtoken->userclaimant->userTicket = (struct type_SPHINX_LoginTicket *) loginticket;

    /*  evidence  */

    evidence = (struct type_SPHINX_Evidence *) malloc(sizeof(struct type_SPHINX_Evidence));
    authtoken->userclaimant->evidence = evidence;
    if (deleg_flag) {
      evidence->offset = type_SPHINX_Evidence_delegator;
      evidence->un.delegator =
	(struct type_SPHINX_Delegator *) malloc(sizeof(struct type_SPHINX_Delegator));
      evidence->un.delegator->algorithm = create_alg_id(DEC_DEA_OID,NULL);
      hide_privateP(&claimantctx_cache.deskey, &encrypted_rsakey,
             &keybuflen, claimant_cred->s_privRSAKey);
      *keybuf=0;
      bcopy(encrypted_rsakey,keybuf+1,keybuflen);
      free(encrypted_rsakey);
      evidence->un.delegator->encryptedPrivKey = 
	str2prim(keybuf, keybuflen+1, PE_CLASS_UNIV, PE_PRIM_BITS);
      prim2bit(evidence->un.delegator->encryptedPrivKey);
    } else {
      evidence->offset = type_SPHINX_Evidence_sharedKeyTicketSignature;
      evidence->un.sharedKeyTicketSignature =
	(struct type_SPHINX_SignatureData *) malloc(sizeof(struct type_SPHINX_SignatureData));
      evidence->un.sharedKeyTicketSignature->algorithm = create_alg_id(OIW_MD2_WITH_RSA_OID,NULL);
      if ((ber_encode(encrypkey,encode_SPHINX_EncryptedKey,PS_LEN_LONG,&asn1_buf, &asn1len)) == NOTOK) {
	printf("error BER encoding encrypkey\n");
	return(SPX_S_MALLOC_ERROR);
      }
      *temp = 0;
      if (!RSASign(asn1_buf,asn1len,claimant_cred->s_privRSAKey,temp+1,&signaturedata_sz)) {
	printf("error signing encrypkey\n");
	return(SPX_S_RSA_SIGN_ERROR);
      }
      evidence->un.sharedKeyTicketSignature->signatureBits = str2prim(temp, 1+signaturedata_sz, PE_CLASS_UNIV, PE_PRIM_BITS);
      prim2bit(evidence->un.sharedKeyTicketSignature->signatureBits);
    }
    authtoken->userclaimant->userName = str_to_rdn(claimant_cred->fullname);
    authtoken->nodeclaimant = NULL;
    i = ber_encode(authtoken,encode_SPHINX_AuthenticationToken,PS_LEN_LONG,
                                &asn1_buf, &asn1len);
    if (i < 0) {
      printf("unable to encode authentication token\n");
      return(SPX_S_MALLOC_ERROR);
    }
    bcopy(asn1_buf, token, asn1len);
    *tokenlen = asn1len;
  }

  /*  save context info in local cache  */

  if (found_in_cache == 0) {
    if (clm_ctx_init(clm_ctx_filename, W_TKT_FIL) != ASUCCESS) {
      if ((i = in_clm_ctx(clm_ctx_filename)) != ASUCCESS) {
	printf("init_context : can't in_clm_ctx - %d\n", i);
	return(SPX_S_CANT_ESTAB_CLAIMANT_CRED);
      }
      if (clm_ctx_init(clm_ctx_filename, W_TKT_FIL) != ASUCCESS) {
	printf("clm_ctx_init failed again (after in_clm_ctx!\n");
	return(SPX_S_CANT_ESTAB_CLAIMANT_CRED);
      }
    }
    claimantctx_cache.before = time_now;
    if (time_now + 3*60*60 < claimant_cred->after)
      claimantctx_cache.after = time_now + 3*60*60;
    else claimantctx_cache.after =  claimant_cred->after;
    claimantctx_cache.deleg_flag = deleg_flag;
    claimantctx_cache.chanbinding_len = chanbinding_len;
    claimantctx_cache.verifier_fn_len = strlen(fulltargname);
    claimantctx_cache.token_len = asn1len;
    strcpy(claimantctx_cache.charbuf, fulltargname);
    bcopy(token, &claimantctx_cache.charbuf[claimantctx_cache.verifier_fn_len], asn1len);
    clm_ctx_add_context(&claimantctx_cache, fulltargname);
    clm_ctx_close();
  }

  /*  create context handle with des key and mutual response,  if one  */

  ctx_handle = (ContextHandle *) malloc(sizeof(ContextHandle));
  *context_handle = ctx_handle;
  bcopy(claimantctx_cache.deskey.bytes, (char *) ctx_handle->deskey.bytes,
        sizeof(deskey.bytes));
  strcpy(ctx_handle->issuer_ln, claimant_cred->name);
  strcpy(ctx_handle->issuer_fn, claimant_cred->fullname);
  strcpy(ctx_handle->claimant_file, "");
  ctx_handle->deleg_flag = deleg_flag;
  if (mutual_flag) {
    DESblock mac;
    mutual_time = (struct type_SPHINX_LongPosixTime *)malloc(sizeof(struct type_SPHINX_LongPosixTime));
    mutual_time->seconds = time_now + 1;
    mutual_time->nanoseconds = 0;
    ber_encode(mutual_time,encode_SPHINX_LongPosixTime,PS_LEN_LONG,&asn1_buf,
	       &asn1len);
    DES_X9_MAC(&claimantctx_cache.deskey,asn1_buf,asn1len,&mac);
    ctx_handle->mutual_resp[0] = 0x80;
    ctx_handle->mutual_resp[1] = 6;
    bcopy(&mac, &ctx_handle->mutual_resp[2], 6);
    ctx_handle->mutual_len = 8;
    return(SPX_S_INIT_CONTINUE);
  } else {
    ctx_handle->mutual_len = 0;
    bzero(ctx_handle->mutual_resp, MUTUAL_RESP_SZ);
  }
  return(SPX_S_INIT_SUCCESS);
}

api_hexdump(p, l)
char *p;
int l;
{
  int i;

  for (i=0; i<l; i++)  {
    if ((i>0) && (i%16 == 0))  printf("\n");
    printf(" %02x", (unsigned char ) p[i]);
  }
  printf("\n");
}
