/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { AbsoluteTime, Duration } from "@gnu-taler/taler-util";
import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { Fragment, h, VNode } from "preact";
import { Part } from "../../components/Part.js";
import { PaymentButtons } from "../../components/PaymentButtons.js";
import { Time } from "../../components/Time.js";
import {
  getAmountWithFee,
  InvoicePaymentDetails,
} from "../../wallet/Transaction.js";
import { PaymentStates } from "../Payment/views.js";

const inFiveMinutes = AbsoluteTime.addDuration(
  AbsoluteTime.now(),
  Duration.fromSpec({ minutes: 5 }),
);

export function ReadyView(
  state: PaymentStates,
): VNode {
  const { i18n } = useTranslationContext();
  const { summary, effective, amount, expiration } = state;

  const willExpireSoon =
    expiration && AbsoluteTime.cmp(expiration, inFiveMinutes) === -1;

  return (
    <Fragment>
      <section style={{ textAlign: "left" }}>
        <Part title={i18n.str`Subject`} text={<div>{summary}</div>} />
        {!effective ? undefined :
          <Part
            title={i18n.str`Details`}
            text={
              <InvoicePaymentDetails
                amount={getAmountWithFee(effective, amount, "debit")}
              />
            }
          />
        }
        {willExpireSoon && (
          <Part
            title={i18n.str`Expires at`}
            text={<Time timestamp={expiration} format="HH:mm" />}
            kind="neutral"
          />
        )}
      </section>

      <PaymentButtons paymentState={state} />

    </Fragment>
  );
}
