/* This is one of the cipher files for the cipher interface written
** by wart@ugcs.caltech.edu
**
** Please don't steal my code without my permission.
**
*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "term.h"
#include "types.h"
#include "ctypes.h"

aristocrat::aristocrat(){
  int i;

  **ocipher = '\0';
  length = 0;
  type = ARISTOCRAT;
  num_lines = 0;
  for(i = 0; i < 26; i++)
    key[i] = BLANK;
}

int aristocrat::execute_option(char option){
  switch(option){
    case SUBSTITUTE:
      substitute();
      break;
    case UNDO:
      undo();
      break;
    default:
      base_exec_option(option);
      break;
  }

  return TRUE;
}

int aristocrat::set_period(int newperiod){
  return TRUE;
}

void aristocrat::show_menu(){
  menu(1, "(S)ubstitute   (U)ndo   (W)rite   (Q)uit");
}

void aristocrat::substitute(){
  char ct_letter, pt_letter;

  /* Get the encoded letter 
  */

  prompt("What is the encoded letter?  ");
  ct_letter = get_char();

  prompt("What is the decoded letter?  ");
  pt_letter = get_char();

  alter_key(ct_letter, pt_letter);
}

void aristocrat::undo(){
  char ct_letter;

  prompt("What is the encoded letter?  ");
  ct_letter = get_char();

  if(ct_letter == '*'){
    for(ct_letter = 'a'; ct_letter <= 'z'; ct_letter++)
      alter_key(ct_letter, ' ');
  }

  else
    alter_key(ct_letter, ' ');
}

void aristocrat::alter_key(char ct_letter, char pt_letter){
  ct_letter |= ' ';

  if(pt_letter != BLANK)
    pt_letter |= ' ';
  
  key[ct_letter - 'a'] = pt_letter;
}

void aristocrat::show_cipher(){
  char c;
  int line, i;

  for(line = 0; line < num_lines; line++){
    for(i = 0; i < strlen(ocipher[line]); i++){
      c = ocipher[line][i];
      put_char(toupper(c), i, line*2+4);
      if(isalpha(c))
	put_char(key[(int) c - 'a'], i, line*2+3);
    }
  }
}

int aristocrat::get_cipher_from_file(FILE *fptr){
  int line=0;

  do{
    fgets(ocipher[line], SCREENWIDTH, fptr);
    strcat(cipher, ocipher[line]);
    ocipher[line][strlen(ocipher[line])-1] = '\0';
  } while(line++ < MAXLINES && !feof(fptr));
  num_lines = line-1;

  return strlen(cipher);
}

void aristocrat::copy_key(char *string){
  strcpy(string, key);
}

void aristocrat::decipher(char *string){
  int i=0;

  while(cipher[i]){
    if(isalpha(cipher[i]))
      *string++ = key[cipher[i++] - 'a'];
    else
      *string++ = cipher[i++];
  }
  *string++ = '\0';
}

void aristocrat::read_key(FILE *fptr){
  char temp_str[STRINGLENGTH];

  fgets(temp_str, STRINGLENGTH, fptr);
  temp_str[26] = '\0';
  strcpy(key, temp_str);
}

void aristocrat::show_key(){
  int i, j;
  int match_found = FALSE;

  msgprint(0, num_lines*2+5, "Pt: ");
  msgprint(0, num_lines*2+6, "Ct: ");
  /* Since most ACA arist/patris ciphers use K2 keyed alphabets we
  ** will save ourselves some work in keyword recovery if we 
  ** print out the plaintext alphabet in normal order.
  */
  for(i = 0; i < 26; i++){
    put_char(i+'a',  i*2+5, num_lines*2+5);
    match_found = FALSE;
    for(j = 0; j < 26; j++){
      if(key[j] != BLANK && key[j] - 'a' == i){
	put_char(toupper(j+'a'),  i*2+5, num_lines*2+6);
	match_found = TRUE;
      }
    }
    if(!match_found)
      put_char(BLANK,  i*2+5, num_lines*2+6);
  }
}
