/*********************************************************************
**
**     File name:               ssh_msg.c
**                                  
**                              Copyright 1997 Tadayoshi Kohno.
**				All rights reserved.
**                              See the LICENSE file.
**
**     Purpose:                 handle generic messages w/ remote machine
**
**     Author/Date:             Tadayoshi Kohno, 8 December 1997
**
**     References:
**	SSHv1.5 protocol definition from draft-ylonen-ssh-protocol-00.txt
**
**     Notes:
**
**     Functions:
**	ssh_msg_disconnect_encode	encode an SSH_MSG_DISCONNECT message
**
*********************************************************************/

#ifndef lint
static char *RCSid="$Header: /home/cia/kohno/libssh/libssh/RCS/ssh_msg.c,v 3.1 1998/03/07 16:32:59 kohno Exp $";
#endif

#include "ssh_msg.h"
#include "ssh_types.h"
#include "ssh_mp_stream.h"


/*********************************************************************
**
**     Function:                ssh_msg_disconnect_encode
**
**     Purpose:                 encode an SSH_MSG_DISCONNECT message
**
**     Entry (pre) conditions:  connection established
**
**     Parameters:              *data		data for packet
**				*data_len	length of data for packet
**
**				reason		reason for disconnecting
**
**     Return value:            S_GOOD
**
**     Error codes:             S_BAD		not used
**
**     Side effects:            *data, *data_len set
**
**     Author/Date:             Tadayoshi Kohno, 8 December 1997
**
**     Notes:
**
*********************************************************************/

int ssh_msg_disconnect_encode
(
	uint8_t * data,		/* data of packet */
	uint32_t * data_len,	/* length of data */

	uint8_t * reason	/* reason to disconnect */
)
{
	*data_len = string_to_stream(data, reason);
	return(S_GOOD);
}

