/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public final class DHParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private int primeSize = 512;
    private int exponentSize = 504;
    private SecureRandom random;

    protected AlgorithmParameters engineGenerateParameters() {
        AlgorithmParameters algorithmParameters = null;
        try {
            BigInteger bigInteger;
            int n;
            BigInteger bigInteger2;
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            BigInteger bigInteger3 = BigInteger.valueOf(1L);
            do {
                n = 20;
                bigInteger = new BigInteger(this.primeSize, n, this.random);
                bigInteger2 = bigInteger.subtract(bigInteger3);
            } while (!(bigInteger2 = bigInteger2.shiftRight(1)).isProbablePrime(n));
            DHParameterSpec dHParameterSpec = this.exponentSize > 0 ? new DHParameterSpec(bigInteger, BigInteger.valueOf(2L), this.exponentSize) : new DHParameterSpec(bigInteger, BigInteger.valueOf(2L));
            algorithmParameters = AlgorithmParameters.getInstance("DH", "SunJCE");
            algorithmParameters.init(dHParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException.getMessage());
        }
        return algorithmParameters;
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        this.primeSize = n;
        this.exponentSize = 0;
        this.random = secureRandom;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
        }
        DHGenParameterSpec dHGenParameterSpec = (DHGenParameterSpec)algorithmParameterSpec;
        this.primeSize = dHGenParameterSpec.getPrimeSize();
        if (this.primeSize <= 0) {
            throw new InvalidAlgorithmParameterException("Modulus size must be greater than zero");
        }
        this.exponentSize = dHGenParameterSpec.getExponentSize();
        if (this.exponentSize <= 0) {
            throw new InvalidAlgorithmParameterException("Exponent size must be greater than zero");
        }
        if (this.exponentSize >= this.primeSize) {
            throw new InvalidAlgorithmParameterException("Exponent size must be less than modulus size");
        }
    }
}

