/*
 * Definitions relevant to the IPSEC <> radij tree interfacing
 * Copyright (C) 1996, 1997  John Ioannidis.
 * Copyright (C) 1998, 1999  Richard Guy Briggs.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * RCSID $Id: ipsec_radij.h,v 1.10 1999/11/17 15:53:39 rgb Exp $
 */

#include <freeswan.h>

int ipsec_walk(char *);

int ipsec_rj_walker_procprint(struct radij_node *, void *);
int ipsec_rj_walker_delete(struct radij_node *, void *);

struct wsbuf
{
	char *buffer;
	int length;
	off_t offset;
	int len;
	int prev_len;
	off_t begin;
	off_t pos;
};

#if 0
struct eroute * ipsec_makeroute(struct sockaddr_encap *ea, struct sockaddr_encap *em, struct sa_id);
#endif
int ipsec_makeroute(struct sockaddr_encap *ea, struct sockaddr_encap *em, struct sa_id);

#if 0
struct eroute * ipsec_breakroute(struct sockaddr_encap *ea, struct sockaddr_encap *em);
#endif
int ipsec_breakroute(struct sockaddr_encap *ea, struct sockaddr_encap *em);

int ipsec_radijinit(void);
int ipsec_cleareroutes(void);
int ipsec_radijcleanup(void);

extern struct radij_node_head *rnh;
extern spinlock_t eroute_lock;

struct eroute * ipsec_findroute(struct sockaddr_encap *);

#define O1(x) (int)(((x)>>24)&0xff)
#define O2(x) (int)(((x)>>16)&0xff)
#define O3(x) (int)(((x)>>8)&0xff)
#define O4(x) (int)(((x))&0xff)

#ifdef DEBUG_IPSEC

extern int debug_radij;
void rj_dumptrees(void);

#define DB_RJ_DUMPTREES	0x0001
#define DB_RJ_FINDROUTE 0x0002

#endif

/*
 * $Log: ipsec_radij.h,v $
 * Revision 1.10  1999/11/17 15:53:39  rgb
 * Changed all occurrences of #include "../../../lib/freeswan.h"
 * to #include <freeswan.h> which works due to -Ilibfreeswan in the
 * klips/net/ipsec/Makefile.
 *
 * Revision 1.9  1999/10/01 00:01:23  rgb
 * Added eroute structure locking.
 *
 * Revision 1.8  1999/04/11 00:28:59  henry
 * GPL boilerplate
 *
 * Revision 1.7  1999/04/06 04:54:26  rgb
 * Fix/Add RCSID Id: and Log: bits to make PHMDs happy.  This includes
 * patch shell fixes.
 *
 * Revision 1.6  1999/01/22 06:23:26  rgb
 * Cruft clean-out.
 *
 * Revision 1.5  1998/10/25 02:42:08  rgb
 * Change return type on ipsec_breakroute and ipsec_makeroute and add an
 * argument to be able to transmit more infomation about errors.
 *
 * Revision 1.4  1998/10/19 14:44:29  rgb
 * Added inclusion of freeswan.h.
 * sa_id structure implemented and used: now includes protocol.
 *
 * Revision 1.3  1998/07/28 00:03:31  rgb
 * Comment out temporary inet_nto4u() kluge.
 *
 * Revision 1.2  1998/07/14 18:22:00  rgb
 * Add function to clear the eroute table.
 *
 * Revision 1.1  1998/06/18 21:27:49  henry
 * move sources from klips/src to klips/net/ipsec, to keep stupid
 * kernel-build scripts happier in the presence of symlinks
 *
 * Revision 1.5  1998/05/25 20:30:38  rgb
 * Remove temporary ipsec_walk, rj_deltree and rj_delnodes functions.
 *
 * Rename ipsec_rj_walker (ipsec_walk) to ipsec_rj_walker_procprint and
 * add ipsec_rj_walker_delete.
 *
 * Revision 1.4  1998/05/21 13:02:56  rgb
 * Imported definitions from ipsec_radij.c and radij.c to support /proc 3k
 * limit fix.
 *
 * Revision 1.3  1998/04/21 21:29:09  rgb
 * Rearrange debug switches to change on the fly debug output from user
 * space.  Only kernel changes checked in at this time.  radij.c was also
 * changed to temporarily remove buggy debugging code in rj_delete causing
 * an OOPS and hence, netlink device open errors.
 *
 * Revision 1.2  1998/04/14 17:30:39  rgb
 * Fix up compiling errors for radij tree memory reclamation.
 *
 * Revision 1.1  1998/04/09 03:06:10  henry
 * sources moved up from linux/net/ipsec
 *
 * Revision 1.1.1.1  1998/04/08 05:35:04  henry
 * RGB's ipsec-0.8pre2.tar.gz ipsec-0.8
 *
 * Revision 0.4  1997/01/15 01:28:15  ji
 * No changes.
 *
 * Revision 0.3  1996/11/20 14:39:04  ji
 * Minor cleanups.
 * Rationalized debugging code.
 *
 * Revision 0.2  1996/11/02 00:18:33  ji
 * First limited release.
 *
 *
 */
